/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.routing.experimental;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.routing.Router;
import org.http4k.routing.RouterMatch;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002!\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00070\u0002j\u0002`\u0001B\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0011\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0003H\u0096\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/http4k/routing/experimental/ResourceLoadingHandler;", "Lorg/http4k/core/HttpHandler;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "pathSegments", "", "resourceLoader", "Lorg/http4k/routing/Router;", "<init>", "(Ljava/lang/String;Lorg/http4k/routing/Router;)V", "invoke", "convertPath", "path", "http4k-incubator"})
public final class ResourceLoadingHandler
implements Function1<Request, Response> {
    @NotNull
    private final String pathSegments;
    @NotNull
    private final Router resourceLoader;

    public ResourceLoadingHandler(@NotNull String pathSegments, @NotNull Router resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)pathSegments, (String)"pathSegments");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.pathSegments = pathSegments;
        this.resourceLoader = resourceLoader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Response invoke(@NotNull Request request) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.getMethod() == Method.GET && StringsKt.startsWith$default((String)request.getUri().getPath(), (String)this.pathSegments, (boolean)false, (int)2, null)) {
            RouterMatch matchResult = this.resourceLoader.match(request.uri(Uri.Companion.of(this.convertPath(request.getUri().getPath()))));
            if (matchResult instanceof RouterMatch.MatchingHandler) {
                response = ((RouterMatch.MatchingHandler)matchResult).invoke(request);
                return response;
            } else if (matchResult instanceof RouterMatch.MethodNotMatched) {
                response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.METHOD_NOT_ALLOWED, null, (int)2, null);
                return response;
            } else if (matchResult instanceof RouterMatch.Unmatched) {
                response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.NOT_FOUND, null, (int)2, null);
                return response;
            } else {
                if (!(matchResult instanceof RouterMatch.MatchedWithoutHandler)) throw new NoWhenBranchMatchedException();
                response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.NOT_FOUND, null, (int)2, null);
            }
            return response;
        } else {
            response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.NOT_FOUND, null, (int)2, null);
        }
        return response;
    }

    private final String convertPath(String path) {
        return Intrinsics.areEqual((Object)this.pathSegments, (Object)"/") || Intrinsics.areEqual((Object)this.pathSegments, (Object)"") ? path : StringsKt.replace$default((String)path, (String)this.pathSegments, (String)"", (boolean)false, (int)4, null);
    }
}

