/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.routing.experimental;

import java.io.ByteArrayInputStream;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.http4k.core.ContentType;
import org.http4k.core.MemoryResponse;
import org.http4k.core.Request;
import org.http4k.core.etag.ETag;
import org.http4k.routing.experimental.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\rJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lorg/http4k/routing/experimental/InMemoryResource;", "Lorg/http4k/routing/experimental/Resource;", "content", "", "contentType", "Lorg/http4k/core/ContentType;", "lastModified", "Ljava/time/Instant;", "etag", "Lorg/http4k/core/etag/ETag;", "<init>", "([BLorg/http4k/core/ContentType;Ljava/time/Instant;Lorg/http4k/core/etag/ETag;)V", "", "(Ljava/lang/String;Lorg/http4k/core/ContentType;Ljava/time/Instant;Lorg/http4k/core/etag/ETag;)V", "getContentType", "()Lorg/http4k/core/ContentType;", "getLastModified", "()Ljava/time/Instant;", "getEtag", "()Lorg/http4k/core/etag/ETag;", "openStream", "Ljava/io/ByteArrayInputStream;", "length", "", "getLength", "()Ljava/lang/Long;", "Ljava/lang/Long;", "http4k-incubator"})
public final class InMemoryResource
implements Resource {
    @NotNull
    private final byte[] content;
    @NotNull
    private final ContentType contentType;
    @Nullable
    private final Instant lastModified;
    @Nullable
    private final ETag etag;
    @Nullable
    private final Long length;

    public InMemoryResource(@NotNull byte[] content, @NotNull ContentType contentType, @Nullable Instant lastModified, @Nullable ETag etag) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.content = content;
        this.contentType = contentType;
        this.lastModified = lastModified;
        this.etag = etag;
        this.length = this.content.length;
    }

    public /* synthetic */ InMemoryResource(byte[] byArray, ContentType contentType, Instant instant, ETag eTag, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            instant = null;
        }
        if ((n & 8) != 0) {
            eTag = null;
        }
        this(byArray, contentType, instant, eTag);
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public Instant getLastModified() {
        return this.lastModified;
    }

    @Override
    @Nullable
    public ETag getEtag() {
        return this.etag;
    }

    public InMemoryResource(@NotNull String content, @NotNull ContentType contentType, @Nullable Instant lastModified, @Nullable ETag etag) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        byte[] byArray = content.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this(byArray, contentType, lastModified, etag);
    }

    public /* synthetic */ InMemoryResource(String string, ContentType contentType, Instant instant, ETag eTag, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            instant = null;
        }
        if ((n & 8) != 0) {
            eTag = null;
        }
        this(string, contentType, instant, eTag);
    }

    @Override
    @NotNull
    public ByteArrayInputStream openStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    @Nullable
    public Long getLength() {
        return this.length;
    }

    @Override
    public boolean isModifiedSince(@NotNull Instant instant) {
        return Resource.DefaultImpls.isModifiedSince(this, instant);
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getHeaders() {
        return Resource.DefaultImpls.getHeaders(this);
    }

    @Override
    @NotNull
    public MemoryResponse invoke(@NotNull Request request) {
        return Resource.DefaultImpls.invoke(this, request);
    }
}

