/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.routing.experimental;

import java.io.ByteArrayInputStream;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.ContentType;
import org.http4k.core.MemoryResponse;
import org.http4k.core.Request;
import org.http4k.core.etag.ETag;
import org.http4k.routing.experimental.Resource;
import org.http4k.routing.experimental.ResourceSummary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/http4k/routing/experimental/ResourceInfoResource;", "Lorg/http4k/routing/experimental/Resource;", "resourceSummary", "Lorg/http4k/routing/experimental/ResourceSummary;", "content", "", "contentType", "Lorg/http4k/core/ContentType;", "<init>", "(Lorg/http4k/routing/experimental/ResourceSummary;[BLorg/http4k/core/ContentType;)V", "getContent", "()[B", "getContentType", "()Lorg/http4k/core/ContentType;", "openStream", "Ljava/io/ByteArrayInputStream;", "length", "", "getLength", "()Ljava/lang/Long;", "lastModified", "Ljava/time/Instant;", "getLastModified", "()Ljava/time/Instant;", "http4k-incubator"})
final class ResourceInfoResource
implements Resource {
    @NotNull
    private final byte[] content;
    @NotNull
    private final ContentType contentType;
    private final long length;
    @Nullable
    private final Instant lastModified;

    public ResourceInfoResource(@NotNull ResourceSummary resourceSummary, @NotNull byte[] content, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)resourceSummary, (String)"resourceSummary");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.content = content;
        this.contentType = contentType;
        this.length = this.content.length;
        this.lastModified = resourceSummary.getLastModified();
    }

    @NotNull
    public final byte[] getContent() {
        return this.content;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public ByteArrayInputStream openStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    @NotNull
    public Long getLength() {
        return this.length;
    }

    @Override
    @Nullable
    public Instant getLastModified() {
        return this.lastModified;
    }

    @Override
    @Nullable
    public ETag getEtag() {
        return Resource.DefaultImpls.getEtag(this);
    }

    @Override
    public boolean isModifiedSince(@NotNull Instant instant) {
        return Resource.DefaultImpls.isModifiedSince(this, instant);
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getHeaders() {
        return Resource.DefaultImpls.getHeaders(this);
    }

    @Override
    @NotNull
    public MemoryResponse invoke(@NotNull Request request) {
        return Resource.DefaultImpls.invoke(this, request);
    }
}

