/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.fileupload.util.ParameterParser;
import org.http4k.multipart.AlreadyClosedException;
import org.http4k.multipart.ParseError;
import org.http4k.multipart.StreamingPart;
import org.http4k.multipart.TokenBoundedInputStream;
import org.http4k.multipart.TokenNotFoundException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u001e\u001f !B\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0013\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0096\u0002J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0016H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/http4k/multipart/StreamingMultipartFormParts;", "", "Lorg/http4k/multipart/StreamingPart;", "boundary", "", "encoding", "Ljava/nio/charset/Charset;", "inputStream", "Lorg/http4k/multipart/TokenBoundedInputStream;", "([BLjava/nio/charset/Charset;Lorg/http4k/multipart/TokenBoundedInputStream;)V", "boundaryWithPrefix", "iterator", "", "mixedName", "", "oldBoundary", "oldBoundaryWithPrefix", "state", "Lorg/http4k/multipart/StreamingMultipartFormParts$MultipartFormStreamState;", "addPrefixToBoundary", "filenameFromMap", "contentDisposition", "", "findBoundary", "", "parseHeaderLines", "parseNextPart", "parsePart", "trim", "string", "BoundedInputStream", "Companion", "MultipartFormStreamState", "StreamingMulipartFormPartIterator", "http4k-multipart"})
public final class StreamingMultipartFormParts
implements Iterable<StreamingPart>,
KMappedMarker {
    private final Iterator<StreamingPart> iterator;
    private byte[] boundary;
    private byte[] boundaryWithPrefix;
    private MultipartFormStreamState state;
    private String mixedName;
    private byte[] oldBoundary;
    private byte[] oldBoundaryWithPrefix;
    private final Charset encoding;
    private final TokenBoundedInputStream inputStream;
    private static final int DEFAULT_BUFSIZE = 4096;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte DASH = 45;
    private static final int HEADER_SIZE_MAX = 10240;
    @NotNull
    private static final byte[] FIELD_SEPARATOR;
    @NotNull
    private static final byte[] STREAM_TERMINATOR;
    public static final Companion Companion;

    @Override
    @NotNull
    public Iterator<StreamingPart> iterator() {
        return this.iterator;
    }

    private final byte[] addPrefixToBoundary(byte[] boundary) {
        if (boundary == null) {
            Intrinsics.throwNpe();
        }
        byte[] b = new byte[boundary.length + Companion.getFIELD_SEPARATOR().length];
        System.arraycopy(boundary, 0, b, 2, boundary.length);
        System.arraycopy(Companion.getFIELD_SEPARATOR(), 0, b, 0, Companion.getFIELD_SEPARATOR().length);
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void findBoundary() {
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)MultipartFormStreamState.findPrefix))) {
            if (!this.inputStream.matchInStream(Companion.getFIELD_SEPARATOR())) {
                throw (Throwable)new TokenNotFoundException("Boundary must be proceeded by field separator, but didn't find it");
            }
            this.state = MultipartFormStreamState.findBoundary;
        }
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)MultipartFormStreamState.findBoundary)) && !this.inputStream.matchInStream(this.boundary)) {
            TokenNotFoundException tokenNotFoundException;
            byte[] byArray = this.boundary;
            Charset charset = this.encoding;
            StringBuilder stringBuilder = new StringBuilder().append("Boundary not found <<");
            TokenNotFoundException tokenNotFoundException2 = tokenNotFoundException;
            TokenNotFoundException tokenNotFoundException3 = tokenNotFoundException;
            String string = new String(byArray, charset);
            tokenNotFoundException2(stringBuilder.append(string).append(">>").toString());
            throw (Throwable)tokenNotFoundException3;
        }
        this.state = MultipartFormStreamState.boundaryFound;
        if (this.inputStream.matchInStream(Companion.getSTREAM_TERMINATOR())) {
            if (!this.inputStream.matchInStream(Companion.getFIELD_SEPARATOR())) throw (Throwable)new TokenNotFoundException("Stream terminator must be followed by field separator, but didn't find it");
            if (this.mixedName != null) {
                this.boundary = this.oldBoundary;
                this.boundaryWithPrefix = this.oldBoundaryWithPrefix;
                this.mixedName = null;
                this.state = MultipartFormStreamState.findBoundary;
                this.findBoundary();
                return;
            } else {
                this.state = MultipartFormStreamState.eos;
            }
            return;
        } else {
            if (!this.inputStream.matchInStream(Companion.getFIELD_SEPARATOR())) {
                throw (Throwable)new TokenNotFoundException("Boundary must be followed by field separator, but didn't find it");
            }
            this.state = MultipartFormStreamState.header;
        }
    }

    private final StreamingPart parseNextPart() {
        this.findBoundary();
        return Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)MultipartFormStreamState.header)) ? this.parsePart() : null;
    }

    private final StreamingPart parsePart() {
        StreamingPart streamingPart;
        Map<String, String> headers2 = this.parseHeaderLines();
        String contentType = headers2.get("Content-Type");
        if (contentType != null && StringsKt.startsWith$default((String)contentType, (String)"multipart/mixed", (boolean)false, (int)2, null)) {
            Map<String, String> contentDisposition = new ParameterParser().parse(headers2.get("Content-Disposition"), ';');
            Map<String, String> contentTypeParams = new ParameterParser().parse(contentType, ';');
            this.mixedName = this.trim(contentDisposition.get("name"));
            this.oldBoundary = this.boundary;
            this.oldBoundaryWithPrefix = this.boundaryWithPrefix;
            Object object = Companion.getSTREAM_TERMINATOR();
            Charset charset = this.encoding;
            Object object2 = new StringBuilder();
            StreamingMultipartFormParts streamingMultipartFormParts = this;
            String string = new String((byte[])object, charset);
            StringBuilder stringBuilder = ((StringBuilder)object2).append(string);
            String string2 = this.trim(contentTypeParams.get("boundary"));
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            object = stringBuilder.append(string2).toString();
            charset = this.encoding;
            Object object3 = object;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = ((String)object3).getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            object2 = byArray;
            streamingMultipartFormParts.boundary = (byte[])object2;
            this.boundaryWithPrefix = this.addPrefixToBoundary(this.boundary);
            this.state = MultipartFormStreamState.findBoundary;
            streamingPart = this.parseNextPart();
        } else {
            Map<String, String> contentDisposition = new ParameterParser().parse(headers2.get("Content-Disposition"), ';');
            String string = contentDisposition.containsKey("attachment") ? this.mixedName : this.trim(contentDisposition.get("name"));
            if (string == null) {
                throw (Throwable)new ParseError("no name for part");
            }
            String fieldName = string;
            boolean bl = !contentDisposition.containsKey("filename");
            Map<String, String> map = contentDisposition;
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"contentDisposition");
            streamingPart = new StreamingPart(fieldName, bl, contentType, this.filenameFromMap(map), new BoundedInputStream(), headers2);
        }
        return streamingPart;
    }

    private final String filenameFromMap(Map<String, String> contentDisposition) {
        String string;
        if (contentDisposition.containsKey("filename")) {
            String string2 = contentDisposition.get("filename");
            if (string2 == null) {
                string2 = "";
            }
            string = this.trim(string2);
        } else {
            string = null;
        }
        return string;
    }

    private final String trim(String string) {
        String string2;
        String string3 = string;
        if (string3 != null) {
            String $receiver$iv = string3;
            CharSequence $receiver$iv$iv = $receiver$iv;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $receiver$iv$iv.charAt(index$iv$iv);
                boolean bl = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string2 = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseHeaderLines() {
        if (Intrinsics.areEqual((Object)((Object)MultipartFormStreamState.header), (Object)((Object)this.state)) ^ true) {
            throw (Throwable)new IllegalStateException("Expected state " + (Object)((Object)MultipartFormStreamState.header) + " but got " + (Object)((Object)this.state));
        }
        HashMap<String, CharSequence> result = new HashMap<String, CharSequence>();
        String previousHeaderName = null;
        long maxByteIndexForHeader = this.inputStream.currentByteIndex() + (long)Companion.getHEADER_SIZE_MAX();
        while (this.inputStream.currentByteIndex() < maxByteIndexForHeader) {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            CharSequence $receiver$iv;
            String string;
            int startIndex$iv$iv;
            CharSequence $receiver$iv$iv;
            HashMap<String, CharSequence> hashMap;
            CharSequence charSequence;
            String header = Companion.readStringFromStreamUntilMatched(this.inputStream, Companion.getFIELD_SEPARATOR(), (int)(maxByteIndexForHeader - this.inputStream.currentByteIndex()), this.encoding);
            if (Intrinsics.areEqual((Object)header, (Object)"")) {
                this.state = MultipartFormStreamState.contents;
                return result;
            }
            CharSequence charSequence2 = header;
            String string2 = "\\s+.*";
            if ((string2 = new Regex(string2)).matches(charSequence2)) {
                void $receiver$iv2;
                if (previousHeaderName == null) {
                    Intrinsics.throwNpe();
                }
                charSequence2 = header;
                charSequence = new StringBuilder().append((String)result.get(previousHeaderName)).append("; ");
                hashMap = result;
                $receiver$iv$iv = (CharSequence)$receiver$iv2;
                startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv2;
                    int index$iv$iv2 = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it2 = $receiver$iv$iv.charAt(index$iv$iv2);
                    boolean bl = match$iv$iv2 = it2 <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv2) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv2) break;
                    --endIndex$iv$iv;
                }
                String string3 = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                hashMap.put(string, charSequence.append(string3).toString());
                continue;
            }
            int index = StringsKt.indexOf$default((CharSequence)header, (String)":", (int)0, (boolean)false, (int)6, null);
            if (index < 0) {
                throw (Throwable)new ParseError("Header didn't include a colon <<" + header + ">>");
            }
            $receiver$iv$iv = header;
            startIndex$iv$iv = 0;
            String string4 = $receiver$iv$iv;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(startIndex$iv$iv, index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            $receiver$iv$iv = string5;
            CharSequence $receiver$iv$iv22 = $receiver$iv;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv = $receiver$iv$iv22.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv2 : endIndex$iv$iv;
                it = $receiver$iv$iv22.charAt(index$iv$iv);
                boolean bl = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            previousHeaderName = ((Object)$receiver$iv$iv22.subSequence(startIndex$iv$iv2, endIndex$iv$iv + 1)).toString();
            $receiver$iv = header;
            int $receiver$iv$iv22 = index + 1;
            string = previousHeaderName;
            hashMap = result;
            String string6 = $receiver$iv;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring($receiver$iv$iv22);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            charSequence = string7;
            $receiver$iv = charSequence;
            CharSequence $receiver$iv$iv3 = $receiver$iv;
            startIndex$iv$iv2 = 0;
            endIndex$iv$iv = $receiver$iv$iv3.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv2 : endIndex$iv$iv;
                it = $receiver$iv$iv3.charAt(index$iv$iv);
                boolean bl = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            charSequence = ((Object)$receiver$iv$iv3.subSequence(startIndex$iv$iv2, endIndex$iv$iv + 1)).toString();
            hashMap.put(string, charSequence);
        }
        throw (Throwable)new TokenNotFoundException("Didn't find end of Header section within " + Companion.getHEADER_SIZE_MAX() + " bytes");
    }

    private StreamingMultipartFormParts(byte[] boundary, Charset encoding, TokenBoundedInputStream inputStream) {
        this.encoding = encoding;
        this.inputStream = inputStream;
        this.iterator = new StreamingMulipartFormPartIterator();
        this.boundary = Companion.prependBoundaryWithStreamTerminator(boundary);
        this.boundaryWithPrefix = this.addPrefixToBoundary(this.boundary);
        this.state = MultipartFormStreamState.findBoundary;
        this.oldBoundary = boundary;
        this.oldBoundaryWithPrefix = this.boundaryWithPrefix;
    }

    static {
        Companion = new Companion(null);
        DEFAULT_BUFSIZE = 4096;
        CR = (byte)13;
        LF = (byte)10;
        DASH = (byte)45;
        HEADER_SIZE_MAX = 10240;
        FIELD_SEPARATOR = new byte[]{StreamingMultipartFormParts.Companion.getCR(), StreamingMultipartFormParts.Companion.getLF()};
        STREAM_TERMINATOR = new byte[]{StreamingMultipartFormParts.Companion.getDASH(), StreamingMultipartFormParts.Companion.getDASH()};
    }

    public static final /* synthetic */ void access$setBoundaryWithPrefix$p(StreamingMultipartFormParts $this, @NotNull byte[] byArray) {
        $this.boundaryWithPrefix = byArray;
    }

    public /* synthetic */ StreamingMultipartFormParts(@NotNull byte[] boundary, @NotNull Charset encoding, @NotNull TokenBoundedInputStream inputStream, DefaultConstructorMarker $constructor_marker) {
        this(boundary, encoding, inputStream);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\t\u0010\t\u001a\u00020\u0006H\u0096\u0002J\t\u0010\n\u001a\u00020\u0002H\u0096\u0002J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/http4k/multipart/StreamingMultipartFormParts$StreamingMulipartFormPartIterator;", "", "Lorg/http4k/multipart/StreamingPart;", "(Lorg/http4k/multipart/StreamingMultipartFormParts;)V", "currentPart", "isEndOfStream", "", "()Z", "nextIsKnown", "hasNext", "next", "safelyParseNextPart", "http4k-multipart"})
    public final class StreamingMulipartFormPartIterator
    implements Iterator<StreamingPart>,
    KMappedMarker {
        private boolean nextIsKnown;
        private StreamingPart currentPart;

        @Override
        public boolean hasNext() {
            if (!this.nextIsKnown) {
                this.nextIsKnown = true;
                if (Intrinsics.areEqual((Object)((Object)StreamingMultipartFormParts.this.state), (Object)((Object)MultipartFormStreamState.contents))) {
                    StreamingPart streamingPart = this.currentPart;
                    if (streamingPart == null) {
                        Intrinsics.throwNpe();
                    }
                    streamingPart.getInputStream().close();
                }
                this.currentPart = this.safelyParseNextPart();
            }
            return !this.isEndOfStream();
        }

        @Override
        @NotNull
        public StreamingPart next() {
            if (this.nextIsKnown) {
                if (this.isEndOfStream()) {
                    throw (Throwable)new NoSuchElementException("No more parts in this MultipartForm");
                }
                this.nextIsKnown = false;
            } else {
                if (Intrinsics.areEqual((Object)((Object)StreamingMultipartFormParts.this.state), (Object)((Object)MultipartFormStreamState.contents))) {
                    StreamingPart streamingPart = this.currentPart;
                    if (streamingPart == null) {
                        Intrinsics.throwNpe();
                    }
                    streamingPart.getInputStream().close();
                }
                this.currentPart = this.safelyParseNextPart();
                if (this.isEndOfStream()) {
                    throw (Throwable)new NoSuchElementException("No more parts in this MultipartForm");
                }
            }
            StreamingPart streamingPart = this.currentPart;
            if (streamingPart == null) {
                Intrinsics.throwNpe();
            }
            return streamingPart;
        }

        private final StreamingPart safelyParseNextPart() {
            StreamingPart streamingPart;
            try {
                streamingPart = StreamingMultipartFormParts.this.parseNextPart();
            }
            catch (IOException e) {
                this.nextIsKnown = true;
                this.currentPart = null;
                throw (Throwable)new ParseError(e);
            }
            return streamingPart;
        }

        private final boolean isEndOfStream() {
            return this.currentPart == null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/http4k/multipart/StreamingMultipartFormParts$BoundedInputStream;", "Ljava/io/InputStream;", "(Lorg/http4k/multipart/StreamingMultipartFormParts;)V", "closed", "", "endOfStream", "close", "", "read", "", "readNextByte", "http4k-multipart"})
    private final class BoundedInputStream
    extends InputStream {
        private boolean endOfStream;
        private boolean closed;

        @Override
        public int read() {
            if (this.closed) {
                throw (Throwable)new AlreadyClosedException();
            }
            return this.endOfStream ? -1 : this.readNextByte();
        }

        private final int readNextByte() {
            int n;
            int result = StreamingMultipartFormParts.this.inputStream.readByteFromStreamUnlessTokenMatched(StreamingMultipartFormParts.this.boundaryWithPrefix);
            switch (result) {
                case -1: {
                    StreamingMultipartFormParts.this.state = MultipartFormStreamState.findPrefix;
                    this.endOfStream = true;
                    n = -1;
                    break;
                }
                case -2: {
                    StreamingMultipartFormParts.this.state = MultipartFormStreamState.boundaryFound;
                    this.endOfStream = true;
                    n = -1;
                    break;
                }
                default: {
                    n = result;
                }
            }
            return n;
        }

        @Override
        public void close() {
            this.closed = true;
            if (!this.endOfStream) {
                try {
                    while (this.readNextByte() >= 0) {
                    }
                }
                catch (IOException e) {
                    this.endOfStream = true;
                    throw (Throwable)new ParseError(e);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/http4k/multipart/StreamingMultipartFormParts$MultipartFormStreamState;", "", "(Ljava/lang/String;I)V", "findPrefix", "findBoundary", "boundaryFound", "eos", "header", "contents", "error", "http4k-multipart"})
    private static final class MultipartFormStreamState
    extends Enum<MultipartFormStreamState> {
        public static final /* enum */ MultipartFormStreamState findPrefix;
        public static final /* enum */ MultipartFormStreamState findBoundary;
        public static final /* enum */ MultipartFormStreamState boundaryFound;
        public static final /* enum */ MultipartFormStreamState eos;
        public static final /* enum */ MultipartFormStreamState header;
        public static final /* enum */ MultipartFormStreamState contents;
        public static final /* enum */ MultipartFormStreamState error;
        private static final /* synthetic */ MultipartFormStreamState[] $VALUES;

        static {
            MultipartFormStreamState[] multipartFormStreamStateArray = new MultipartFormStreamState[7];
            MultipartFormStreamState[] multipartFormStreamStateArray2 = multipartFormStreamStateArray;
            multipartFormStreamStateArray[0] = findPrefix = new MultipartFormStreamState();
            multipartFormStreamStateArray[1] = findBoundary = new MultipartFormStreamState();
            multipartFormStreamStateArray[2] = boundaryFound = new MultipartFormStreamState();
            multipartFormStreamStateArray[3] = eos = new MultipartFormStreamState();
            multipartFormStreamStateArray[4] = header = new MultipartFormStreamState();
            multipartFormStreamStateArray[5] = contents = new MultipartFormStreamState();
            multipartFormStreamStateArray[6] = error = new MultipartFormStreamState();
            $VALUES = multipartFormStreamStateArray;
        }

        public static MultipartFormStreamState[] values() {
            return (MultipartFormStreamState[])$VALUES.clone();
        }

        public static MultipartFormStreamState valueOf(String string) {
            return Enum.valueOf(MultipartFormStreamState.class, string);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eJ&\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006'"}, d2={"Lorg/http4k/multipart/StreamingMultipartFormParts$Companion;", "", "()V", "CR", "", "getCR", "()B", "DASH", "getDASH", "DEFAULT_BUFSIZE", "", "getDEFAULT_BUFSIZE", "()I", "FIELD_SEPARATOR", "", "getFIELD_SEPARATOR", "()[B", "HEADER_SIZE_MAX", "getHEADER_SIZE_MAX", "LF", "getLF", "STREAM_TERMINATOR", "getSTREAM_TERMINATOR", "parse", "", "Lorg/http4k/multipart/StreamingPart;", "boundary", "inputStream", "Ljava/io/InputStream;", "encoding", "Ljava/nio/charset/Charset;", "maxStreamLength", "prependBoundaryWithStreamTerminator", "readStringFromStreamUntilMatched", "", "tokenBoundedInputStream", "Lorg/http4k/multipart/TokenBoundedInputStream;", "endOfToken", "maxStringSizeInBytes", "http4k-multipart"})
    public static final class Companion {
        private final int getDEFAULT_BUFSIZE() {
            return DEFAULT_BUFSIZE;
        }

        private final byte getCR() {
            return CR;
        }

        private final byte getLF() {
            return LF;
        }

        private final byte getDASH() {
            return DASH;
        }

        public final int getHEADER_SIZE_MAX() {
            return HEADER_SIZE_MAX;
        }

        @NotNull
        public final byte[] getFIELD_SEPARATOR() {
            return FIELD_SEPARATOR;
        }

        @NotNull
        public final byte[] getSTREAM_TERMINATOR() {
            return STREAM_TERMINATOR;
        }

        @NotNull
        public final Iterable<StreamingPart> parse(@NotNull byte[] boundary, @NotNull InputStream inputStream, @NotNull Charset encoding) {
            Intrinsics.checkParameterIsNotNull((Object)boundary, (String)"boundary");
            Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
            Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
            return new StreamingMultipartFormParts(boundary, encoding, new TokenBoundedInputStream(inputStream, this.getDEFAULT_BUFSIZE(), 0, 4, null), null);
        }

        @NotNull
        public final Iterable<StreamingPart> parse(@NotNull byte[] boundary, @NotNull InputStream inputStream, @NotNull Charset encoding, int maxStreamLength) {
            Intrinsics.checkParameterIsNotNull((Object)boundary, (String)"boundary");
            Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
            Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
            return new StreamingMultipartFormParts(boundary, encoding, new TokenBoundedInputStream(inputStream, this.getDEFAULT_BUFSIZE(), maxStreamLength), null);
        }

        @NotNull
        public final byte[] prependBoundaryWithStreamTerminator(@NotNull byte[] boundary) {
            Intrinsics.checkParameterIsNotNull((Object)boundary, (String)"boundary");
            byte[] actualBoundary = new byte[boundary.length + 2];
            System.arraycopy(this.getSTREAM_TERMINATOR(), 0, actualBoundary, 0, 2);
            System.arraycopy(boundary, 0, actualBoundary, 2, boundary.length);
            return actualBoundary;
        }

        @NotNull
        public final String readStringFromStreamUntilMatched(@NotNull TokenBoundedInputStream tokenBoundedInputStream, @NotNull byte[] endOfToken, int maxStringSizeInBytes, @NotNull Charset encoding) {
            Intrinsics.checkParameterIsNotNull((Object)tokenBoundedInputStream, (String)"tokenBoundedInputStream");
            Intrinsics.checkParameterIsNotNull((Object)endOfToken, (String)"endOfToken");
            Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
            byte[] buffer = new byte[maxStringSizeInBytes];
            int bytes = tokenBoundedInputStream.getBytesUntil(endOfToken, buffer, encoding);
            int n = 0;
            return new String(buffer, n, bytes, encoding);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

