/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.multipart;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.multipart.ParseError;
import org.http4k.multipart.Part;
import org.http4k.multipart.StreamingPart;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ0\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J:\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/http4k/multipart/MultipartFormMap;", "", "()V", "formParts", "", "Lorg/http4k/multipart/Part;", "parts", "", "Lorg/http4k/multipart/StreamingPart;", "encoding", "Ljava/nio/charset/Charset;", "writeToDiskThreshold", "", "temporaryFileDirectory", "Ljava/io/File;", "serialisePart", "part", "bytes", "", "storeInMemory", "length", "partInputStream", "Ljava/io/InputStream;", "writeToDisk", "fileName", "", "http4k-multipart"})
public final class MultipartFormMap {
    public static final MultipartFormMap INSTANCE;

    @NotNull
    public final List<Part> formParts(@NotNull Iterable<StreamingPart> parts, @NotNull Charset encoding, int writeToDiskThreshold, @NotNull File temporaryFileDirectory) {
        Intrinsics.checkParameterIsNotNull(parts, (String)"parts");
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        Intrinsics.checkParameterIsNotNull((Object)temporaryFileDirectory, (String)"temporaryFileDirectory");
        List result = new ArrayList();
        byte[] bytes = new byte[writeToDiskThreshold];
        for (StreamingPart part : parts) {
            if (part.getFieldName() == null) {
                throw (Throwable)new ParseError("no name for part");
            }
            result.add(this.serialisePart(encoding, writeToDiskThreshold, temporaryFileDirectory, part, bytes));
        }
        return result;
    }

    private final Part serialisePart(Charset encoding, int writeToDiskThreshold, File temporaryFileDirectory, StreamingPart part, byte[] bytes) {
        int count;
        int length2 = 0;
        do {
            if ((count = part.getInputStream().read(bytes, length2, writeToDiskThreshold - length2)) >= 0) continue;
            return new Part.InMemory(part, this.storeInMemory(bytes, length2, part.getInputStream()), encoding);
        } while ((length2 += count) < writeToDiskThreshold);
        return new Part.DiskBacked(part, this.writeToDisk(part.getFileName(), writeToDiskThreshold, temporaryFileDirectory, bytes, length2, part.getInputStream()));
    }

    private final byte[] storeInMemory(byte[] bytes, int length2, InputStream partInputStream) {
        partInputStream.close();
        byte[] result = new byte[length2];
        System.arraycopy(bytes, 0, result, 0, length2);
        return result;
    }

    private final File writeToDisk(String fileName, int writeToDiskThreshold, File temporaryFileDirectory, byte[] bytes, int length2, InputStream partInputStream) {
        int readLength;
        String string = fileName;
        if (string == null) {
            string = UUID.randomUUID().toString() + "-";
        }
        File tempFile = File.createTempFile(string, ".tmp", temporaryFileDirectory);
        tempFile.deleteOnExit();
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        outputStream.write(bytes, 0, length2);
        while ((readLength = partInputStream.read(bytes, 0, writeToDiskThreshold)) >= 0) {
            outputStream.write(bytes, 0, readLength);
        }
        partInputStream.close();
        File file = tempFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"tempFile");
        return file;
    }

    private MultipartFormMap() {
        INSTANCE = this;
    }

    static {
        new MultipartFormMap();
    }
}

