/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.multipart;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.multipart.ParseError;
import org.http4k.multipart.Part;
import org.http4k.multipart.PartMetaData;
import org.http4k.multipart.StreamingPart;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J(\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/http4k/multipart/MultipartFormParser;", "", "encoding", "Ljava/nio/charset/Charset;", "writeToDiskThreshold", "", "temporaryFileDirectory", "Ljava/io/File;", "(Ljava/nio/charset/Charset;ILjava/io/File;)V", "formParts", "", "Lorg/http4k/multipart/Part;", "parts", "", "Lorg/http4k/multipart/StreamingPart;", "serialisePart", "part", "bytes", "", "storeInMemory", "length", "writeToDisk", "kotlin.jvm.PlatformType", "http4k-multipart"})
public final class MultipartFormParser {
    private final Charset encoding;
    private final int writeToDiskThreshold;
    private final File temporaryFileDirectory;

    @NotNull
    public final List<Part> formParts(@NotNull Iterable<StreamingPart> parts) {
        Intrinsics.checkParameterIsNotNull(parts, (String)"parts");
        boolean bl = false;
        List result = new ArrayList();
        byte[] bytes = new byte[this.writeToDiskThreshold];
        for (StreamingPart part : parts) {
            if (part.getFieldName() == null) {
                throw (Throwable)new ParseError("no name for part");
            }
            result.add(this.serialisePart(part, bytes));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Part serialisePart(StreamingPart part, byte[] bytes) {
        int count;
        int length = 0;
        do {
            if ((count = part.getInputStream().read(bytes, length, this.writeToDiskThreshold - length)) >= 0) continue;
            Closeable closeable = part.getInputStream();
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                Part part2 = new Part.InMemory(part, this.storeInMemory(bytes, length), this.encoding);
                return part2;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } while ((length += count) < this.writeToDiskThreshold);
        Closeable closeable = part.getInputStream();
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl3 = false;
            PartMetaData partMetaData = part;
            File file = this.writeToDisk(part, bytes, length);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"writeToDisk(part, bytes, length)");
            Part part3 = new Part.DiskBacked(partMetaData, file);
            return part3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final byte[] storeInMemory(byte[] bytes, int length) {
        byte[] byArray = new byte[length];
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$apply = byArray;
        boolean bl3 = false;
        System.arraycopy(bytes, 0, $this$apply, 0, length);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File writeToDisk(StreamingPart part, byte[] bytes, int length) {
        String string = part.getFileName();
        if (string == null) {
            string = UUID.randomUUID().toString() + "-";
        }
        File file = File.createTempFile(string, ".tmp", this.temporaryFileDirectory);
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        $this$apply.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream($this$apply);
        boolean bl4 = false;
        boolean bl5 = false;
        FileOutputStream $this$apply2 = fileOutputStream;
        boolean bl6 = false;
        $this$apply2.write(bytes, 0, length);
        Closeable closeable = $this$apply2;
        boolean bl7 = false;
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl8 = false;
            long l = ByteStreamsKt.copyTo((InputStream)part.getInputStream(), (OutputStream)it, (int)this.writeToDiskThreshold);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return file;
    }

    public MultipartFormParser(@NotNull Charset encoding, int writeToDiskThreshold, @NotNull File temporaryFileDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        Intrinsics.checkParameterIsNotNull((Object)temporaryFileDirectory, (String)"temporaryFileDirectory");
        this.encoding = encoding;
        this.writeToDiskThreshold = writeToDiskThreshold;
        this.temporaryFileDirectory = temporaryFileDirectory;
    }
}

