/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.multipart;

import java.io.InputStream;
import java.nio.InvalidMarkException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.multipart.BitFiddling;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\n\b\u0010\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J \u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0002J\b\u0010 \u001a\u00020\u0007H\u0002J\b\u0010!\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/http4k/multipart/CircularBufferedInputStream;", "Ljava/io/InputStream;", "inputStream", "maxExpectedBufSize", "", "(Ljava/io/InputStream;I)V", "EOS", "", "buffer", "", "bufferIndexMask", "", "bufferSize", "cursor", "getCursor", "()J", "setCursor", "(J)V", "leftBounds", "markInvalid", "readLimit", "rightBounds", "available", "mark", "", "readlimit", "markSupported", "read", "b", "off", "len", "read1", "readMore", "reset", "http4k-multipart"})
public class CircularBufferedInputStream
extends InputStream {
    @NotNull
    private final InputStream inputStream;
    private final int bufferSize;
    private final long bufferIndexMask;
    @NotNull
    private final byte[] buffer;
    private long cursor;
    private long rightBounds;
    private long leftBounds;
    private long readLimit;
    private boolean markInvalid;
    private boolean EOS;

    public CircularBufferedInputStream(@NotNull InputStream inputStream2, int maxExpectedBufSize) {
        Intrinsics.checkNotNullParameter((Object)inputStream2, (String)"inputStream");
        this.inputStream = inputStream2;
        this.bufferSize = Integer.highestOneBit(maxExpectedBufSize) * 2;
        this.bufferIndexMask = this.bufferSize - 1;
        this.buffer = new byte[this.bufferSize];
    }

    protected final long getCursor() {
        return this.cursor;
    }

    protected final void setCursor(long l) {
        this.cursor = l;
    }

    @Override
    public int read() {
        return this.EOS ? -1 : this.read1();
    }

    private final int read1() {
        while (this.cursor == this.rightBounds) {
            if (this.readMore()) continue;
            return -1;
        }
        long l = this.cursor;
        this.cursor = l + 1L;
        return BitFiddling.getAnInt(this.buffer[(int)(l & this.bufferIndexMask)], 255);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.EOS) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            int result = this.read1();
            if (result == -1) {
                return i;
            }
            b[i + off] = (byte)result;
        }
        return len;
    }

    private final boolean readMore() {
        long rightIndex;
        long leftIndex = this.leftBounds & this.bufferIndexMask;
        int readThisManyBytes = leftIndex > (rightIndex = this.rightBounds & this.bufferIndexMask) ? (int)(leftIndex - rightIndex) : (int)((long)this.buffer.length - rightIndex);
        int readBytes = this.inputStream.read(this.buffer, (int)rightIndex, readThisManyBytes);
        if (readBytes < 0) {
            this.EOS = true;
            return false;
        }
        this.rightBounds += (long)readBytes;
        if (this.cursor - this.leftBounds > this.readLimit) {
            this.leftBounds = this.cursor;
            this.readLimit = 0L;
            this.markInvalid = true;
        }
        return true;
    }

    @Override
    public int available() {
        return (int)(this.rightBounds - this.cursor);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() {
        if (this.markInvalid) {
            throw new InvalidMarkException();
        }
        this.cursor = this.leftBounds;
        this.readLimit = 0L;
        this.markInvalid = false;
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (readlimit > this.bufferSize) {
            String string2 = "Readlimit (%d) cannot be bigger than buffer size (%d)";
            Object[] objectArray = new Object[]{readlimit, this.bufferSize};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            throw new ArrayIndexOutOfBoundsException(string3);
        }
        this.leftBounds = this.cursor;
        this.markInvalid = false;
        this.readLimit = readlimit;
    }
}

