/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.multipart;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.multipart.DiskLocation;
import org.http4k.multipart.MultipartFile;
import org.http4k.multipart.ParseError;
import org.http4k.multipart.Part;
import org.http4k.multipart.StreamingPart;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J$\u0010\u0015\u001a\u00020\u0016*\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/http4k/multipart/MultipartFormParser;", "", "encoding", "Ljava/nio/charset/Charset;", "writeToDiskThreshold", "", "diskLocation", "Lorg/http4k/multipart/DiskLocation;", "(Ljava/nio/charset/Charset;ILorg/http4k/multipart/DiskLocation;)V", "formParts", "", "Lorg/http4k/multipart/Part;", "parts", "", "Lorg/http4k/multipart/StreamingPart;", "serialisePart", "part", "bytes", "", "storeInMemory", "length", "writeFile", "Lorg/http4k/multipart/MultipartFile;", "http4k-multipart"})
@SourceDebugExtension(value={"SMAP\nMultipartFormParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartFormParser.kt\norg/http4k/multipart/MultipartFormParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class MultipartFormParser {
    @NotNull
    private final Charset encoding;
    private final int writeToDiskThreshold;
    @NotNull
    private final DiskLocation diskLocation;

    public MultipartFormParser(@NotNull Charset encoding, int writeToDiskThreshold, @NotNull DiskLocation diskLocation) {
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        Intrinsics.checkNotNullParameter((Object)diskLocation, (String)"diskLocation");
        this.encoding = encoding;
        this.writeToDiskThreshold = writeToDiskThreshold;
        this.diskLocation = diskLocation;
    }

    @NotNull
    public final List<Part> formParts(@NotNull Iterable<StreamingPart> parts) {
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        List result = new ArrayList();
        byte[] bytes = new byte[this.writeToDiskThreshold];
        for (StreamingPart part : parts) {
            if (part.getFieldName() == null) {
                throw new ParseError("no name for part");
            }
            result.add(this.serialisePart(part, bytes));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Part serialisePart(StreamingPart part, byte[] bytes) {
        int count;
        int length = 0;
        do {
            if ((count = part.getInputStream().read(bytes, length, this.writeToDiskThreshold - length)) >= 0) continue;
            Closeable closeable = part.getInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Part part2 = new Part.InMemory(part, this.storeInMemory(bytes, length), this.encoding);
                return part2;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } while ((length += count) < this.writeToDiskThreshold);
        Closeable closeable = part.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Part part3 = new Part.DiskBacked(part, this.writeFile(this.diskLocation.createFile(part.getFileName()), part, bytes, length));
            return part3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final byte[] storeInMemory(byte[] bytes, int length) {
        byte[] byArray;
        byte[] $this$storeInMemory_u24lambda_u242 = byArray = new byte[length];
        boolean bl = false;
        System.arraycopy(bytes, 0, $this$storeInMemory_u24lambda_u242, 0, length);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MultipartFile writeFile(MultipartFile $this$writeFile, StreamingPart part, byte[] bytes, int length) {
        FileOutputStream fileOutputStream;
        File file;
        MultipartFile multipartFile;
        MultipartFile multipartFile2 = multipartFile = $this$writeFile;
        boolean bl = false;
        File $this$writeFile_u24lambda_u246_u24lambda_u245 = file = multipartFile2.file();
        boolean bl2 = false;
        FileOutputStream $this$writeFile_u24lambda_u246_u24lambda_u245_u24lambda_u244 = fileOutputStream = new FileOutputStream($this$writeFile_u24lambda_u246_u24lambda_u245);
        boolean bl3 = false;
        $this$writeFile_u24lambda_u246_u24lambda_u245_u24lambda_u244.write(bytes, 0, length);
        Closeable closeable = $this$writeFile_u24lambda_u246_u24lambda_u245_u24lambda_u244;
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl4 = false;
            ByteStreamsKt.copyTo((InputStream)part.getInputStream(), (OutputStream)it, (int)this.writeToDiskThreshold);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return multipartFile;
    }
}

