/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.multipart;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.lens.MultipartFormKt;
import org.http4k.multipart.StreamingMultipartFormParts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0013\b\u0016\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u000eJ;\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u001e\u0010\u0013\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00160\u0015j\u0002`\u0014\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u0002J3\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\t2\u001e\u0010\u0013\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00160\u0015j\u0002`\u0014\u00a2\u0006\u0002\u0010\u001eJ3\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u000e2\u001e\u0010\u0013\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00160\u0015j\u0002`\u0014\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tJC\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u001e\u0010\u0013\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00160\u0015j\u0002`\u0014\u00a2\u0006\u0002\u0010(JK\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000e2\u001e\u0010\u0013\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00160\u0015j\u0002`\u0014\u00a2\u0006\u0002\u0010,J\u0006\u0010-\u001a\u00020\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/http4k/multipart/MultipartFormBuilder;", "", "inBoundary", "", "encoding", "Ljava/nio/charset/Charset;", "<init>", "([BLjava/nio/charset/Charset;)V", "boundary", "", "(Ljava/lang/String;)V", "Ljava/util/ArrayDeque;", "waitingToStream", "", "Ljava/io/InputStream;", "stream", "field", "name", "value", "headers", "Lorg/http4k/core/Parameters;", "", "Lkotlin/Pair;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)Lorg/http4k/multipart/MultipartFormBuilder;", "appendHeader", "", "headerName", "headerValue", "part", "contents", "(Ljava/lang/String;Ljava/util/List;)Lorg/http4k/multipart/MultipartFormBuilder;", "(Ljava/io/InputStream;Ljava/util/List;)Lorg/http4k/multipart/MultipartFormBuilder;", "add", "bytes", "startMultipart", "multipartFieldName", "subpartBoundary", "attachment", "fileName", "contentType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)Lorg/http4k/multipart/MultipartFormBuilder;", "file", "fieldName", "filename", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/io/InputStream;Ljava/util/List;)Lorg/http4k/multipart/MultipartFormBuilder;", "endMultipart", "http4k-multipart"})
@SourceDebugExtension(value={"SMAP\nMultipartFormBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartFormBuilder.kt\norg/http4k/multipart/MultipartFormBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1863#2,2:90\n*S KotlinDebug\n*F\n+ 1 MultipartFormBuilder.kt\norg/http4k/multipart/MultipartFormBuilder\n*L\n49#1:90,2\n*E\n"})
public final class MultipartFormBuilder {
    @NotNull
    private final Charset encoding;
    @NotNull
    private final ArrayDeque<byte[]> boundary;
    @NotNull
    private final List<InputStream> waitingToStream;

    public MultipartFormBuilder(@NotNull byte[] inBoundary, @NotNull Charset encoding) {
        Intrinsics.checkNotNullParameter((Object)inBoundary, (String)"inBoundary");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        this.encoding = encoding;
        this.boundary = new ArrayDeque();
        this.waitingToStream = new ArrayList();
        this.boundary.push(StreamingMultipartFormParts.Companion.prependBoundaryWithStreamTerminator(inBoundary));
    }

    public /* synthetic */ MultipartFormBuilder(byte[] byArray, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charset.defaultCharset();
        }
        this(byArray, charset);
    }

    public MultipartFormBuilder(@NotNull String boundary) {
        Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
        String string = boundary;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Charset charset2 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
        this(byArray, charset2);
    }

    public /* synthetic */ MultipartFormBuilder(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = MultipartFormKt.getMULTIPART_BOUNDARY();
        }
        this(string);
    }

    @NotNull
    public final InputStream stream() {
        byte[] byArray = this.boundary.peek();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"peek(...)");
        this.add(byArray);
        this.add(StreamingMultipartFormParts.Companion.getSTREAM_TERMINATOR());
        this.add(StreamingMultipartFormParts.Companion.getFIELD_SEPARATOR());
        return new SequenceInputStream(Collections.enumeration((Collection)this.waitingToStream));
    }

    @NotNull
    public final MultipartFormBuilder field(@NotNull String name, @NotNull String value, @NotNull List<Pair<String, String>> headers) {
        MultipartFormBuilder multipartFormBuilder;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        MultipartFormBuilder $this$field_u24lambda_u240 = multipartFormBuilder = this;
        boolean bl = false;
        $this$field_u24lambda_u240.part(value, (List<Pair<String, String>>)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name + '\"'))), (Iterable)headers));
        return multipartFormBuilder;
    }

    private final void appendHeader(String headerName, String headerValue) {
        StringBuilder stringBuilder = new StringBuilder().append(headerName).append(": ");
        String string = headerValue;
        if (string == null) {
            string = "";
        }
        String headerLine = stringBuilder.append(string).toString();
        byte[] byArray = headerLine.getBytes(this.encoding);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.add(byArray);
        this.add(StreamingMultipartFormParts.Companion.getFIELD_SEPARATOR());
    }

    @NotNull
    public final MultipartFormBuilder part(@NotNull String contents, @NotNull List<Pair<String, String>> headers) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        byte[] byArray = contents.getBytes(this.encoding);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.part(new ByteArrayInputStream(byArray), headers);
    }

    @NotNull
    public final MultipartFormBuilder part(@NotNull InputStream contents, @NotNull List<Pair<String, String>> headers) {
        MultipartFormBuilder multipartFormBuilder;
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        MultipartFormBuilder $this$part_u24lambda_u242 = multipartFormBuilder = this;
        boolean bl = false;
        byte[] byArray = $this$part_u24lambda_u242.boundary.peek();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"peek(...)");
        $this$part_u24lambda_u242.add(byArray);
        $this$part_u24lambda_u242.add(StreamingMultipartFormParts.Companion.getFIELD_SEPARATOR());
        if (!((Collection)headers).isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)headers);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                String first = (String)pair.component1();
                String second = (String)pair.component2();
                $this$part_u24lambda_u242.appendHeader(first, second);
            }
            $this$part_u24lambda_u242.add(StreamingMultipartFormParts.Companion.getFIELD_SEPARATOR());
        }
        $this$part_u24lambda_u242.waitingToStream.add(contents);
        $this$part_u24lambda_u242.add(StreamingMultipartFormParts.Companion.getFIELD_SEPARATOR());
        return multipartFormBuilder;
    }

    private final void add(byte[] bytes) {
        this.waitingToStream.add(new ByteArrayInputStream(bytes));
    }

    @NotNull
    public final MultipartFormBuilder startMultipart(@NotNull String multipartFieldName, @NotNull String subpartBoundary) {
        MultipartFormBuilder multipartFormBuilder;
        Intrinsics.checkNotNullParameter((Object)multipartFieldName, (String)"multipartFieldName");
        Intrinsics.checkNotNullParameter((Object)subpartBoundary, (String)"subpartBoundary");
        MultipartFormBuilder $this$startMultipart_u24lambda_u243 = multipartFormBuilder = this;
        boolean bl = false;
        byte[] byArray = $this$startMultipart_u24lambda_u243.boundary.peek();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"peek(...)");
        $this$startMultipart_u24lambda_u243.add(byArray);
        $this$startMultipart_u24lambda_u243.add(StreamingMultipartFormParts.Companion.getFIELD_SEPARATOR());
        $this$startMultipart_u24lambda_u243.appendHeader("Content-Disposition", "form-data; name=\"" + multipartFieldName + '\"');
        $this$startMultipart_u24lambda_u243.appendHeader("Content-Type", "multipart/mixed; boundary=\"" + subpartBoundary + '\"');
        $this$startMultipart_u24lambda_u243.add(StreamingMultipartFormParts.Companion.getFIELD_SEPARATOR());
        ArrayDeque<byte[]> arrayDeque = $this$startMultipart_u24lambda_u243.boundary;
        byte[] byArray2 = (new String(StreamingMultipartFormParts.Companion.getSTREAM_TERMINATOR(), $this$startMultipart_u24lambda_u243.encoding) + subpartBoundary).getBytes($this$startMultipart_u24lambda_u243.encoding);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        arrayDeque.push(byArray2);
        return multipartFormBuilder;
    }

    @NotNull
    public final MultipartFormBuilder attachment(@NotNull String fileName, @NotNull String contentType, @NotNull String contents, @NotNull List<Pair<String, String>> headers) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"Content-Disposition", (Object)("attachment; filename=\"" + fileName + '\"')), TuplesKt.to((Object)"Content-Type", (Object)contentType)};
        return this.part(contents, (List<Pair<String, String>>)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)headers));
    }

    @NotNull
    public final MultipartFormBuilder file(@NotNull String fieldName, @NotNull String filename, @NotNull String contentType, @NotNull InputStream contents, @NotNull List<Pair<String, String>> headers) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + fieldName + "\"; filename=\"" + filename + '\"')), TuplesKt.to((Object)"Content-Type", (Object)contentType)};
        return this.part(contents, (List<Pair<String, String>>)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)headers));
    }

    @NotNull
    public final MultipartFormBuilder endMultipart() {
        MultipartFormBuilder multipartFormBuilder;
        MultipartFormBuilder $this$endMultipart_u24lambda_u244 = multipartFormBuilder = this;
        boolean bl = false;
        byte[] byArray = $this$endMultipart_u24lambda_u244.boundary.pop();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"pop(...)");
        $this$endMultipart_u24lambda_u244.add(byArray);
        $this$endMultipart_u24lambda_u244.add(StreamingMultipartFormParts.Companion.getSTREAM_TERMINATOR());
        $this$endMultipart_u24lambda_u244.add(StreamingMultipartFormParts.Companion.getFIELD_SEPARATOR());
        return multipartFormBuilder;
    }
}

