/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.fileupload.util.ParameterParser;
import org.http4k.multipart.AlreadyClosedException;
import org.http4k.multipart.ParseError;
import org.http4k.multipart.StreamingPart;
import org.http4k.multipart.TokenBoundedInputStream;
import org.http4k.multipart.TokenNotFoundException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\b\b\u0000\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004 !\"#B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00060\fR\u00020\u0000H\u0096\u0002J\u0012\u0010\u0015\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0002J\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u001cH\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012H\u0002J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/http4k/multipart/StreamingMultipartFormParts;", "", "Lorg/http4k/multipart/StreamingPart;", "inBoundary", "", "encoding", "Ljava/nio/charset/Charset;", "inputStream", "Lorg/http4k/multipart/TokenBoundedInputStream;", "<init>", "([BLjava/nio/charset/Charset;Lorg/http4k/multipart/TokenBoundedInputStream;)V", "iterator", "Lorg/http4k/multipart/StreamingMultipartFormParts$StreamingMultipartFormPartIterator;", "boundary", "boundaryWithPrefix", "state", "Lorg/http4k/multipart/StreamingMultipartFormParts$MultipartFormStreamState;", "mixedName", "", "oldBoundary", "oldBoundaryWithPrefix", "addPrefixToBoundary", "findBoundary", "", "parseNextPart", "parsePart", "filenameFromMap", "contentDisposition", "", "trim", "string", "parseHeaderLines", "StreamingMultipartFormPartIterator", "BoundedInputStream", "MultipartFormStreamState", "Companion", "http4k-multipart"})
@SourceDebugExtension(value={"SMAP\nStreamingMultipartFormParts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingMultipartFormParts.kt\norg/http4k/multipart/StreamingMultipartFormParts\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,303:1\n108#2:304\n80#2,22:305\n108#2:327\n80#2,22:328\n108#2:350\n80#2,22:351\n108#2:373\n80#2,22:374\n*S KotlinDebug\n*F\n+ 1 StreamingMultipartFormParts.kt\norg/http4k/multipart/StreamingMultipartFormParts\n*L\n108#1:304\n108#1:305,22\n123#1:327\n123#1:328,22\n128#1:350\n128#1:351,22\n129#1:373\n129#1:374,22\n*E\n"})
public final class StreamingMultipartFormParts
implements Iterable<StreamingPart>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Charset encoding;
    @NotNull
    private final TokenBoundedInputStream inputStream;
    @NotNull
    private final StreamingMultipartFormPartIterator iterator;
    @NotNull
    private byte[] boundary;
    @NotNull
    private byte[] boundaryWithPrefix;
    @NotNull
    private MultipartFormStreamState state;
    @Nullable
    private String mixedName;
    @NotNull
    private byte[] oldBoundary;
    @NotNull
    private byte[] oldBoundaryWithPrefix;
    private static final int DEFAULT_BUFSIZE = 4096;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte DASH = 45;
    public static final int HEADER_SIZE_MAX = 10240;
    @NotNull
    private static final byte[] FIELD_SEPARATOR;
    @NotNull
    private static final byte[] STREAM_TERMINATOR;

    private StreamingMultipartFormParts(byte[] inBoundary, Charset encoding, TokenBoundedInputStream inputStream) {
        this.encoding = encoding;
        this.inputStream = inputStream;
        this.iterator = new StreamingMultipartFormPartIterator();
        this.boundary = Companion.prependBoundaryWithStreamTerminator(inBoundary);
        this.boundaryWithPrefix = this.addPrefixToBoundary(this.boundary);
        this.state = MultipartFormStreamState.FindBoundary;
        this.oldBoundary = inBoundary;
        this.oldBoundaryWithPrefix = this.boundaryWithPrefix;
    }

    @NotNull
    public StreamingMultipartFormPartIterator iterator() {
        return this.iterator;
    }

    private final byte[] addPrefixToBoundary(byte[] boundary) {
        byte[] byArray;
        Intrinsics.checkNotNull((Object)boundary);
        byte[] $this$addPrefixToBoundary_u24lambda_u240 = byArray = new byte[boundary.length + FIELD_SEPARATOR.length];
        boolean bl = false;
        System.arraycopy(boundary, 0, $this$addPrefixToBoundary_u24lambda_u240, 2, boundary.length);
        System.arraycopy(FIELD_SEPARATOR, 0, $this$addPrefixToBoundary_u24lambda_u240, 0, FIELD_SEPARATOR.length);
        return byArray;
    }

    private final void findBoundary() {
        if (this.state == MultipartFormStreamState.FindPrefix) {
            if (!this.inputStream.matchInStream(FIELD_SEPARATOR)) {
                throw new TokenNotFoundException("Boundary must be proceeded by field separator, but didn't find it");
            }
            this.state = MultipartFormStreamState.FindBoundary;
        }
        if (this.state == MultipartFormStreamState.FindBoundary && !this.inputStream.matchInStream(this.boundary)) {
            throw new TokenNotFoundException("Boundary not found <<" + new String(this.boundary, this.encoding) + ">>");
        }
        this.state = MultipartFormStreamState.BoundaryFound;
        if (this.inputStream.matchInStream(STREAM_TERMINATOR)) {
            if (!this.inputStream.matchInStream(FIELD_SEPARATOR)) {
                throw new TokenNotFoundException("Stream terminator must be followed by field separator, but didn't find it");
            }
            if (this.mixedName != null) {
                this.boundary = this.oldBoundary;
                this.boundaryWithPrefix = this.oldBoundaryWithPrefix;
                this.mixedName = null;
                this.state = MultipartFormStreamState.FindBoundary;
                this.findBoundary();
            } else {
                this.state = MultipartFormStreamState.Eos;
            }
        } else {
            if (!this.inputStream.matchInStream(FIELD_SEPARATOR)) {
                throw new TokenNotFoundException("Boundary must be followed by field separator, but didn't find it");
            }
            this.state = MultipartFormStreamState.Header;
        }
    }

    private final StreamingPart parseNextPart() {
        this.findBoundary();
        Unit $this$parseNextPart_u24lambda_u241 = Unit.INSTANCE;
        boolean bl = false;
        return this.state == MultipartFormStreamState.Header ? this.parsePart() : null;
    }

    private final StreamingPart parsePart() {
        StreamingPart streamingPart;
        Map<String, String> headers = this.parseHeaderLines();
        String contentType = headers.get("Content-Type");
        if (contentType != null && StringsKt.startsWith$default((String)contentType, (String)"multipart/mixed", (boolean)false, (int)2, null)) {
            Map<String, String> contentDisposition = new ParameterParser().parse(headers.get("Content-Disposition"), ';');
            Map<String, String> contentTypeParams = new ParameterParser().parse(contentType, ';');
            this.mixedName = this.trim(contentDisposition.get("name"));
            this.oldBoundary = this.boundary;
            this.oldBoundaryWithPrefix = this.boundaryWithPrefix;
            String string = new String(STREAM_TERMINATOR, this.encoding);
            String string2 = this.trim(contentTypeParams.get("boundary"));
            Intrinsics.checkNotNull((Object)string2);
            byte[] byArray = (string + string2).getBytes(this.encoding);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.boundary = byArray;
            this.boundaryWithPrefix = this.addPrefixToBoundary(this.boundary);
            this.state = MultipartFormStreamState.FindBoundary;
            streamingPart = this.parseNextPart();
        } else {
            Map<String, String> contentDisposition = new ParameterParser().parse(headers.get("Content-Disposition"), ';');
            String string = contentDisposition.containsKey("attachment") ? this.mixedName : this.trim(contentDisposition.get("name"));
            if (string == null) {
                throw new ParseError("no name for part");
            }
            String fieldName = string;
            boolean bl = !contentDisposition.containsKey("filename");
            Intrinsics.checkNotNull(contentDisposition);
            streamingPart = new StreamingPart(fieldName, bl, contentType, this.filenameFromMap(contentDisposition), new BoundedInputStream(), headers);
        }
        return streamingPart;
    }

    private final String filenameFromMap(Map<String, String> contentDisposition) {
        String string;
        if (contentDisposition.containsKey("filename")) {
            String string2 = contentDisposition.get("filename");
            if (string2 == null) {
                string2 = "";
            }
            string = this.trim(string2);
        } else {
            string = null;
        }
        return string;
    }

    private final String trim(String string) {
        String string2;
        String string3 = string;
        if (string3 != null) {
            String $this$trim$iv = string3;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseHeaderLines() {
        if (MultipartFormStreamState.Header != this.state) {
            throw new IllegalStateException("Expected state " + MultipartFormStreamState.Header + " but got " + this.state);
        }
        TreeMap result = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        String previousHeaderName = null;
        long maxByteIndexForHeader = this.inputStream.currentByteIndex() + (long)10240;
        while (this.inputStream.currentByteIndex() < maxByteIndexForHeader) {
            void $this$trim$iv;
            Object object;
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            boolean startFound$iv$iv;
            int endIndex$iv$iv;
            int startIndex$iv$iv;
            boolean $i$f$trim;
            CharSequence $this$trim$iv$iv;
            String $this$trim$iv2;
            boolean $i$f$trim2;
            String string;
            String header = Companion.readStringFromStreamUntilMatched(this.inputStream, FIELD_SEPARATOR, (int)(maxByteIndexForHeader - this.inputStream.currentByteIndex()), this.encoding);
            if (Intrinsics.areEqual((Object)header, (Object)"")) {
                this.state = MultipartFormStreamState.Contents;
                return result;
            }
            Object object2 = header;
            if (new Regex("\\s+.*").matches((CharSequence)object2)) {
                object2 = result;
                Intrinsics.checkNotNull(previousHeaderName);
                string = header;
                Object v = result.get(previousHeaderName);
                $i$f$trim2 = false;
                $this$trim$iv$iv = $this$trim$iv2;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                $this$trim$iv2 = v + "; " + ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                object2.put(object, $this$trim$iv2);
                continue;
            }
            int index = StringsKt.indexOf$default((CharSequence)header, (String)":", (int)0, (boolean)false, (int)6, null);
            if (index < 0) {
                throw new ParseError("Header didn't include a colon <<" + header + ">>");
            }
            String string2 = header.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            object = string2;
            boolean $i$f$trim3 = false;
            CharSequence $this$trim$iv$iv2 = (CharSequence)$this$trim$iv;
            boolean $i$f$trim4 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv2;
                int index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it2 = $this$trim$iv$iv2.charAt(index$iv$iv2);
                boolean bl = false;
                boolean bl3 = match$iv$iv2 = Intrinsics.compare((int)it2, (int)32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv2) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv2) break;
                --endIndex$iv$iv2;
            }
            previousHeaderName = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
            object = result;
            Intrinsics.checkNotNullExpressionValue((Object)header.substring(index + 1), (String)"substring(...)");
            $i$f$trim2 = false;
            $this$trim$iv$iv = $this$trim$iv2;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            object.put(previousHeaderName, string);
        }
        throw new TokenNotFoundException("Didn't find end of Header section within 10240 bytes");
    }

    public /* synthetic */ StreamingMultipartFormParts(byte[] inBoundary, Charset encoding, TokenBoundedInputStream inputStream, DefaultConstructorMarker $constructor_marker) {
        this(inBoundary, encoding, inputStream);
    }

    static {
        byte[] byArray = new byte[]{13, 10};
        FIELD_SEPARATOR = byArray;
        byArray = new byte[]{45, 45};
        STREAM_TERMINATOR = byArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/http4k/multipart/StreamingMultipartFormParts$BoundedInputStream;", "Ljava/io/InputStream;", "<init>", "(Lorg/http4k/multipart/StreamingMultipartFormParts;)V", "endOfStream", "", "closed", "read", "", "readNextByte", "close", "", "http4k-multipart"})
    private final class BoundedInputStream
    extends InputStream {
        private boolean endOfStream;
        private boolean closed;

        @Override
        public int read() {
            if (this.closed) {
                throw new AlreadyClosedException();
            }
            return this.endOfStream ? -1 : this.readNextByte();
        }

        private final int readNextByte() {
            int result = StreamingMultipartFormParts.this.inputStream.readByteFromStreamUnlessTokenMatched(StreamingMultipartFormParts.this.boundaryWithPrefix);
            return switch (result) {
                case -1 -> {
                    StreamingMultipartFormParts.this.state = MultipartFormStreamState.FindPrefix;
                    this.endOfStream = true;
                    yield -1;
                }
                case -2 -> {
                    StreamingMultipartFormParts.this.state = MultipartFormStreamState.BoundaryFound;
                    this.endOfStream = true;
                    yield -1;
                }
                default -> {
                    void var1_1;
                    yield var1_1;
                }
            };
        }

        @Override
        public void close() {
            this.closed = true;
            if (!this.endOfStream) {
                try {
                    while (this.readNextByte() >= 0) {
                    }
                }
                catch (IOException e) {
                    this.endOfStream = true;
                    throw new ParseError(e);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fJ&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/http4k/multipart/StreamingMultipartFormParts$Companion;", "", "<init>", "()V", "DEFAULT_BUFSIZE", "", "CR", "", "LF", "DASH", "HEADER_SIZE_MAX", "FIELD_SEPARATOR", "", "getFIELD_SEPARATOR", "()[B", "STREAM_TERMINATOR", "getSTREAM_TERMINATOR", "parse", "", "Lorg/http4k/multipart/StreamingPart;", "boundary", "inputStream", "Ljava/io/InputStream;", "encoding", "Ljava/nio/charset/Charset;", "maxStreamLength", "prependBoundaryWithStreamTerminator", "readStringFromStreamUntilMatched", "", "tokenBoundedInputStream", "Lorg/http4k/multipart/TokenBoundedInputStream;", "endOfToken", "maxStringSizeInBytes", "http4k-multipart"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getFIELD_SEPARATOR() {
            return FIELD_SEPARATOR;
        }

        @NotNull
        public final byte[] getSTREAM_TERMINATOR() {
            return STREAM_TERMINATOR;
        }

        @NotNull
        public final Iterable<StreamingPart> parse(@NotNull byte[] boundary, @NotNull InputStream inputStream, @NotNull Charset encoding) {
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            return new StreamingMultipartFormParts(boundary, encoding, new TokenBoundedInputStream(inputStream, 4096, 0, 4, null), null);
        }

        @NotNull
        public final Iterable<StreamingPart> parse(@NotNull byte[] boundary, @NotNull InputStream inputStream, @NotNull Charset encoding, int maxStreamLength) {
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            return new StreamingMultipartFormParts(boundary, encoding, new TokenBoundedInputStream(inputStream, 4096, maxStreamLength), null);
        }

        @NotNull
        public final byte[] prependBoundaryWithStreamTerminator(@NotNull byte[] boundary) {
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            byte[] actualBoundary = new byte[boundary.length + 2];
            System.arraycopy(this.getSTREAM_TERMINATOR(), 0, actualBoundary, 0, 2);
            System.arraycopy(boundary, 0, actualBoundary, 2, boundary.length);
            return actualBoundary;
        }

        @NotNull
        public final String readStringFromStreamUntilMatched(@NotNull TokenBoundedInputStream tokenBoundedInputStream, @NotNull byte[] endOfToken, int maxStringSizeInBytes, @NotNull Charset encoding) {
            Intrinsics.checkNotNullParameter((Object)tokenBoundedInputStream, (String)"tokenBoundedInputStream");
            Intrinsics.checkNotNullParameter((Object)endOfToken, (String)"endOfToken");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            byte[] buffer = new byte[maxStringSizeInBytes];
            int bytes = tokenBoundedInputStream.getBytesUntil(endOfToken, buffer, encoding);
            return new String(buffer, 0, bytes, encoding);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/http4k/multipart/StreamingMultipartFormParts$MultipartFormStreamState;", "", "<init>", "(Ljava/lang/String;I)V", "FindPrefix", "FindBoundary", "BoundaryFound", "Eos", "Header", "Contents", "http4k-multipart"})
    private static final class MultipartFormStreamState
    extends Enum<MultipartFormStreamState> {
        public static final /* enum */ MultipartFormStreamState FindPrefix = new MultipartFormStreamState();
        public static final /* enum */ MultipartFormStreamState FindBoundary = new MultipartFormStreamState();
        public static final /* enum */ MultipartFormStreamState BoundaryFound = new MultipartFormStreamState();
        public static final /* enum */ MultipartFormStreamState Eos = new MultipartFormStreamState();
        public static final /* enum */ MultipartFormStreamState Header = new MultipartFormStreamState();
        public static final /* enum */ MultipartFormStreamState Contents = new MultipartFormStreamState();
        private static final /* synthetic */ MultipartFormStreamState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MultipartFormStreamState[] values() {
            return (MultipartFormStreamState[])$VALUES.clone();
        }

        public static MultipartFormStreamState valueOf(String value) {
            return Enum.valueOf(MultipartFormStreamState.class, value);
        }

        @NotNull
        public static EnumEntries<MultipartFormStreamState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = multipartFormStreamStateArray = new MultipartFormStreamState[]{MultipartFormStreamState.FindPrefix, MultipartFormStreamState.FindBoundary, MultipartFormStreamState.BoundaryFound, MultipartFormStreamState.Eos, MultipartFormStreamState.Header, MultipartFormStreamState.Contents};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\t\u0010\b\u001a\u00020\u0006H\u0096\u0002J\t\u0010\t\u001a\u00020\u0002H\u0096\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0002J\b\u0010\u000b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/http4k/multipart/StreamingMultipartFormParts$StreamingMultipartFormPartIterator;", "", "Lorg/http4k/multipart/StreamingPart;", "<init>", "(Lorg/http4k/multipart/StreamingMultipartFormParts;)V", "nextIsKnown", "", "currentPart", "hasNext", "next", "safelyParseNextPart", "isEndOfStream", "http4k-multipart"})
    public final class StreamingMultipartFormPartIterator
    implements Iterator<StreamingPart>,
    KMappedMarker {
        private boolean nextIsKnown;
        @Nullable
        private StreamingPart currentPart;

        @Override
        public boolean hasNext() {
            if (!this.nextIsKnown) {
                this.nextIsKnown = true;
                if (StreamingMultipartFormParts.this.state == MultipartFormStreamState.Contents) {
                    StreamingPart streamingPart = this.currentPart;
                    Intrinsics.checkNotNull((Object)streamingPart);
                    streamingPart.getInputStream().close();
                }
                this.currentPart = this.safelyParseNextPart();
            }
            return !this.isEndOfStream();
        }

        @Override
        @NotNull
        public StreamingPart next() {
            if (this.nextIsKnown) {
                if (this.isEndOfStream()) {
                    throw new NoSuchElementException("No more parts in this MultipartForm");
                }
                this.nextIsKnown = false;
            } else {
                if (StreamingMultipartFormParts.this.state == MultipartFormStreamState.Contents) {
                    StreamingPart streamingPart = this.currentPart;
                    Intrinsics.checkNotNull((Object)streamingPart);
                    streamingPart.getInputStream().close();
                }
                this.currentPart = this.safelyParseNextPart();
                if (this.isEndOfStream()) {
                    throw new NoSuchElementException("No more parts in this MultipartForm");
                }
            }
            StreamingPart streamingPart = this.currentPart;
            Intrinsics.checkNotNull((Object)streamingPart);
            return streamingPart;
        }

        private final StreamingPart safelyParseNextPart() {
            StreamingPart streamingPart;
            try {
                streamingPart = StreamingMultipartFormParts.this.parseNextPart();
            }
            catch (IOException e) {
                this.nextIsKnown = true;
                this.currentPart = null;
                throw new ParseError(e);
            }
            return streamingPart;
        }

        private final boolean isEndOfStream() {
            return this.currentPart == null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

