/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.core;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.http4k.core.ContentType;
import org.http4k.core.HttpMessage;
import org.http4k.core.MultipartEntity;
import org.http4k.lens.Header;
import org.http4k.lens.MultipartFormFile;
import org.http4k.multipart.Part;
import org.http4k.multipart.StreamingMultipartFormParts;
import org.http4k.multipart.StreamingPart;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0000\u00a8\u0006\u0007"}, d2={"multipartIterator", "", "Lorg/http4k/core/MultipartEntity;", "Lorg/http4k/core/HttpMessage;", "string", "", "Lorg/http4k/multipart/Part;", "http4k-multipart"})
@SourceDebugExtension(value={"SMAP\nMultipartFormBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartFormBody.kt\norg/http4k/core/MultipartFormBodyKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public final class MultipartFormBodyKt {
    @NotNull
    public static final Iterator<MultipartEntity> multipartIterator(@NotNull HttpMessage $this$multipartIterator) {
        Object boundary;
        Intrinsics.checkNotNullParameter((Object)$this$multipartIterator, (String)"<this>");
        Object object = (ContentType)Header.INSTANCE.getCONTENT_TYPE().invoke((Object)$this$multipartIterator);
        if (object == null || (object = object.getDirectives()) == null || (object = (Pair)CollectionsKt.firstOrNull((List)object)) == null || (object = (String)object.getSecond()) == null) {
            object = "";
        }
        Object object2 = boundary = object;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = ((String)object2).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        InputStream inputStream = $this$multipartIterator.getBody().getStream();
        Charset charset2 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence(StreamingMultipartFormParts.Companion.parse(byArray, inputStream, charset2)), MultipartFormBodyKt::multipartIterator$lambda$0).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String string(@NotNull Part $this$string) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"<this>");
        Part part = $this$string;
        if (part instanceof Part.DiskBacked) {
            Closeable closeable = ((Part.DiskBacked)$this$string).getNewInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                InputStream inputStream = it;
                Charset charset = Charsets.UTF_8;
                String string2 = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
                string = string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else if (part instanceof Part.InMemory) {
            string = new String(((Part.InMemory)$this$string).getBytes(), ((Part.InMemory)$this$string).getEncoding$http4k_multipart());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final MultipartEntity multipartIterator$lambda$0(StreamingPart it) {
        MultipartEntity multipartEntity;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isFormField()) {
            String string = it.getFieldName();
            Intrinsics.checkNotNull((Object)string);
            multipartEntity = new MultipartEntity.Field(string, it.getContentsAsString(), MapsKt.toList(it.getHeaders()), null, 8, null);
        } else {
            String string = it.getFieldName();
            Intrinsics.checkNotNull((Object)string);
            String string2 = it.getFileName();
            Intrinsics.checkNotNull((Object)string2);
            String string3 = it.getContentType();
            Intrinsics.checkNotNull((Object)string3);
            multipartEntity = new MultipartEntity.File(string, new MultipartFormFile(string2, new ContentType(string3, ContentType.Companion.getTEXT_HTML().getDirectives()), it.getInputStream()), MapsKt.toList(it.getHeaders()));
        }
        return multipartEntity;
    }
}

