/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.multipart;

import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.multipart.CircularBufferedInputStream;
import org.http4k.multipart.StreamTooLongException;
import org.http4k.multipart.TokenNotFoundException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000bJ\b\u0010\u0018\u001a\u00020\u0005H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/http4k/multipart/TokenBoundedInputStream;", "Lorg/http4k/multipart/CircularBufferedInputStream;", "inputStream", "Ljava/io/InputStream;", "bufSize", "", "maxStreamLength", "<init>", "(Ljava/io/InputStream;II)V", "getBytesUntil", "endOfToken", "", "buffer", "encoding", "Ljava/nio/charset/Charset;", "getBytesRead", "", "bufferIndex", "matchToken", "", "token", "initialCharacter", "matchInStream", "readByteFromStreamUnlessTokenMatched", "readFromStream", "currentByteIndex", "", "http4k-multipart"})
public final class TokenBoundedInputStream
extends CircularBufferedInputStream {
    private final int maxStreamLength;

    @JvmOverloads
    public TokenBoundedInputStream(@NotNull InputStream inputStream, int bufSize, int maxStreamLength) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        super(inputStream, bufSize);
        this.maxStreamLength = maxStreamLength;
    }

    public /* synthetic */ TokenBoundedInputStream(InputStream inputStream, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        this(inputStream, n, n2);
    }

    public final int getBytesUntil(@NotNull byte[] endOfToken, @NotNull byte[] buffer, @NotNull Charset encoding) {
        Intrinsics.checkNotNullParameter((Object)endOfToken, (String)"endOfToken");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        int bufferIndex = 0;
        int bufferLength = buffer.length;
        int b = 0;
        while (true) {
            if ((b = this.readFromStream()) < 0) {
                throw new TokenNotFoundException("Reached end of stream before finding Token <<" + new String(endOfToken, encoding) + ">>. Last " + endOfToken.length + " bytes read were <<" + this.getBytesRead(endOfToken, buffer, bufferIndex, encoding) + ">>");
            }
            if (bufferIndex >= bufferLength) {
                throw new TokenNotFoundException("Didn't find end of Token <<" + new String(endOfToken, encoding) + ">> within " + bufferLength + " bytes");
            }
            byte originalB = (byte)(b & 0xFF);
            if (originalB == endOfToken[0]) {
                this.mark(endOfToken.length);
                if (this.matchToken(endOfToken, b)) {
                    return bufferIndex;
                }
                this.reset();
            }
            buffer[bufferIndex++] = originalB;
        }
    }

    private final String getBytesRead(byte[] endOfToken, byte[] buffer, int bufferIndex, Charset encoding) {
        int index = 0;
        int length = 0;
        if (bufferIndex - endOfToken.length > 0) {
            index = bufferIndex - endOfToken.length;
            length = endOfToken.length;
        } else {
            index = 0;
            length = bufferIndex;
        }
        return new String(buffer, index, length, encoding);
    }

    private final boolean matchToken(byte[] token, int initialCharacter) {
        int initialChar = initialCharacter;
        int eotIndex = 0;
        while (initialChar > -1 && (byte)initialChar == token[eotIndex] && ++eotIndex < token.length) {
            initialChar = this.readFromStream();
        }
        return eotIndex == token.length;
    }

    public final boolean matchInStream(@NotNull byte[] token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.mark(token.length);
        if (this.matchToken(token, this.readFromStream())) {
            return true;
        }
        this.reset();
        return false;
    }

    public final int readByteFromStreamUnlessTokenMatched(@NotNull byte[] token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        int b = this.readFromStream();
        if ((byte)b == token[0]) {
            this.mark(token.length);
            if (this.matchToken(token, b)) {
                return -2;
            }
            this.reset();
        }
        return b;
    }

    private final int readFromStream() {
        if (this.maxStreamLength > -1 && this.getCursor() >= (long)this.maxStreamLength) {
            throw new StreamTooLongException("Form contents was longer than " + this.maxStreamLength + " bytes");
        }
        return this.read();
    }

    public final long currentByteIndex() {
        return this.getCursor();
    }

    @JvmOverloads
    public TokenBoundedInputStream(@NotNull InputStream inputStream, int bufSize) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this(inputStream, bufSize, 0, 4, null);
    }
}

