/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.multipart;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.multipart.MultipartFile;
import org.http4k.multipart.PartMetaData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0019\u001aBK\b\u0004\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u0082\u0001\u0002\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lorg/http4k/multipart/Part;", "Lorg/http4k/multipart/PartMetaData;", "Ljava/io/Closeable;", "fieldName", "", "formField", "", "contentType", "fileName", "headers", "", "length", "", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/util/Map;I)V", "getLength", "()I", "newInputStream", "Ljava/io/InputStream;", "getNewInputStream", "()Ljava/io/InputStream;", "bytes", "", "getBytes", "()[B", "DiskBacked", "InMemory", "Lorg/http4k/multipart/Part$DiskBacked;", "Lorg/http4k/multipart/Part$InMemory;", "http4k-multipart"})
public abstract sealed class Part
extends PartMetaData
implements Closeable {
    private final int length;

    private Part(String fieldName, boolean formField, String contentType, String fileName, Map<String, String> headers, int length) {
        super(fieldName, formField, contentType, fileName, headers);
        this.length = length;
    }

    public final int getLength() {
        return this.length;
    }

    @NotNull
    public abstract InputStream getNewInputStream();

    @NotNull
    public abstract byte[] getBytes();

    public /* synthetic */ Part(String fieldName, boolean formField, String contentType, String fileName, Map headers, int length, DefaultConstructorMarker $constructor_marker) {
        this(fieldName, formField, contentType, fileName, headers, length);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/http4k/multipart/Part$DiskBacked;", "Lorg/http4k/multipart/Part;", "part", "Lorg/http4k/multipart/PartMetaData;", "multipartFile", "Lorg/http4k/multipart/MultipartFile;", "<init>", "(Lorg/http4k/multipart/PartMetaData;Lorg/http4k/multipart/MultipartFile;)V", "newInputStream", "Ljava/io/InputStream;", "getNewInputStream", "()Ljava/io/InputStream;", "bytes", "", "getBytes", "()Ljava/lang/Void;", "close", "", "http4k-multipart"})
    public static final class DiskBacked
    extends Part {
        @NotNull
        private final MultipartFile multipartFile;

        public DiskBacked(@NotNull PartMetaData part, @NotNull MultipartFile multipartFile) {
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            Intrinsics.checkNotNullParameter((Object)multipartFile, (String)"multipartFile");
            super(part.getFieldName(), part.isFormField(), part.getContentType(), part.getFileName(), part.getHeaders(), (int)multipartFile.file().length(), null);
            this.multipartFile = multipartFile;
        }

        @Override
        @NotNull
        public InputStream getNewInputStream() {
            return new FileInputStream(this.multipartFile.file());
        }

        @NotNull
        public Void getBytes() {
            throw new IllegalStateException("Cannot get bytes from a DiskBacked Part");
        }

        @Override
        public void close() {
            this.multipartFile.close();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/http4k/multipart/Part$InMemory;", "Lorg/http4k/multipart/Part;", "original", "Lorg/http4k/multipart/PartMetaData;", "bytes", "", "encoding", "Ljava/nio/charset/Charset;", "<init>", "(Lorg/http4k/multipart/PartMetaData;[BLjava/nio/charset/Charset;)V", "getBytes", "()[B", "getEncoding$http4k_multipart", "()Ljava/nio/charset/Charset;", "newInputStream", "Ljava/io/InputStream;", "getNewInputStream", "()Ljava/io/InputStream;", "close", "", "http4k-multipart"})
    public static final class InMemory
    extends Part {
        @NotNull
        private final byte[] bytes;
        @NotNull
        private final Charset encoding;

        public InMemory(@NotNull PartMetaData original, @NotNull byte[] bytes, @NotNull Charset encoding) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            super(original.getFieldName(), original.isFormField(), original.getContentType(), original.getFileName(), original.getHeaders(), bytes.length, null);
            this.bytes = bytes;
            this.encoding = encoding;
        }

        @Override
        @NotNull
        public byte[] getBytes() {
            return this.bytes;
        }

        @NotNull
        public final Charset getEncoding$http4k_multipart() {
            return this.encoding;
        }

        @Override
        @NotNull
        public InputStream getNewInputStream() {
            return new ByteArrayInputStream(this.getBytes());
        }

        @Override
        public void close() {
        }
    }
}

