/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.NetworkAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.http4k.core.HttpTransaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBC\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\u0019\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\fH\u00c6\u0003JI\u0010\u0018\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0018\b\u0002\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\fH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/http4k/metrics/OpenTelemetryMetricsDefaults;", "", "metricsDescription", "Lkotlin/Pair;", "", "bucketBoundaryAdvice", "", "", "metricsLabeler", "Lkotlin/Function1;", "Lorg/http4k/core/HttpTransaction;", "Lio/opentelemetry/api/common/Attributes;", "Lorg/http4k/metrics/MetricsLabeler;", "<init>", "(Lkotlin/Pair;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "getMetricsDescription", "()Lkotlin/Pair;", "getBucketBoundaryAdvice", "()Ljava/util/List;", "getMetricsLabeler", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "http4k-ops-opentelemetry"})
public final class OpenTelemetryMetricsDefaults {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Pair<String, String> metricsDescription;
    @NotNull
    private final List<Double> bucketBoundaryAdvice;
    @NotNull
    private final Function1<HttpTransaction, Attributes> metricsLabeler;
    @NotNull
    private static final List<Double> DEFAULT_BUCKET_BOUNDARY_ADVICE;
    @NotNull
    private static final Regex urlTemplates;
    @NotNull
    private static final OpenTelemetryMetricsDefaults server;
    @NotNull
    private static final OpenTelemetryMetricsDefaults client;

    public OpenTelemetryMetricsDefaults(@NotNull Pair<String, String> metricsDescription, @NotNull List<Double> bucketBoundaryAdvice, @NotNull Function1<? super HttpTransaction, ? extends Attributes> metricsLabeler) {
        Intrinsics.checkNotNullParameter(metricsDescription, (String)"metricsDescription");
        Intrinsics.checkNotNullParameter(bucketBoundaryAdvice, (String)"bucketBoundaryAdvice");
        Intrinsics.checkNotNullParameter(metricsLabeler, (String)"metricsLabeler");
        this.metricsDescription = metricsDescription;
        this.bucketBoundaryAdvice = bucketBoundaryAdvice;
        this.metricsLabeler = metricsLabeler;
    }

    public /* synthetic */ OpenTelemetryMetricsDefaults(Pair pair, List list, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = DEFAULT_BUCKET_BOUNDARY_ADVICE;
        }
        this((Pair<String, String>)pair, list, (Function1<? super HttpTransaction, ? extends Attributes>)function1);
    }

    @NotNull
    public final Pair<String, String> getMetricsDescription() {
        return this.metricsDescription;
    }

    @NotNull
    public final List<Double> getBucketBoundaryAdvice() {
        return this.bucketBoundaryAdvice;
    }

    @NotNull
    public final Function1<HttpTransaction, Attributes> getMetricsLabeler() {
        return this.metricsLabeler;
    }

    @NotNull
    public final Pair<String, String> component1() {
        return this.metricsDescription;
    }

    @NotNull
    public final List<Double> component2() {
        return this.bucketBoundaryAdvice;
    }

    @NotNull
    public final Function1<HttpTransaction, Attributes> component3() {
        return this.metricsLabeler;
    }

    @NotNull
    public final OpenTelemetryMetricsDefaults copy(@NotNull Pair<String, String> metricsDescription, @NotNull List<Double> bucketBoundaryAdvice, @NotNull Function1<? super HttpTransaction, ? extends Attributes> metricsLabeler) {
        Intrinsics.checkNotNullParameter(metricsDescription, (String)"metricsDescription");
        Intrinsics.checkNotNullParameter(bucketBoundaryAdvice, (String)"bucketBoundaryAdvice");
        Intrinsics.checkNotNullParameter(metricsLabeler, (String)"metricsLabeler");
        return new OpenTelemetryMetricsDefaults(metricsDescription, bucketBoundaryAdvice, metricsLabeler);
    }

    public static /* synthetic */ OpenTelemetryMetricsDefaults copy$default(OpenTelemetryMetricsDefaults openTelemetryMetricsDefaults, Pair pair, List list, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            pair = openTelemetryMetricsDefaults.metricsDescription;
        }
        if ((n & 2) != 0) {
            list = openTelemetryMetricsDefaults.bucketBoundaryAdvice;
        }
        if ((n & 4) != 0) {
            function1 = openTelemetryMetricsDefaults.metricsLabeler;
        }
        return openTelemetryMetricsDefaults.copy(pair, list, function1);
    }

    @NotNull
    public String toString() {
        return "OpenTelemetryMetricsDefaults(metricsDescription=" + this.metricsDescription + ", bucketBoundaryAdvice=" + this.bucketBoundaryAdvice + ", metricsLabeler=" + this.metricsLabeler + ")";
    }

    public int hashCode() {
        int result = this.metricsDescription.hashCode();
        result = result * 31 + ((Object)this.bucketBoundaryAdvice).hashCode();
        result = result * 31 + this.metricsLabeler.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OpenTelemetryMetricsDefaults)) {
            return false;
        }
        OpenTelemetryMetricsDefaults openTelemetryMetricsDefaults = (OpenTelemetryMetricsDefaults)other;
        if (!Intrinsics.areEqual(this.metricsDescription, openTelemetryMetricsDefaults.metricsDescription)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.bucketBoundaryAdvice, openTelemetryMetricsDefaults.bucketBoundaryAdvice)) {
            return false;
        }
        return Intrinsics.areEqual(this.metricsLabeler, openTelemetryMetricsDefaults.metricsLabeler);
    }

    private static final Attributes server$lambda$0(HttpTransaction tx) {
        AttributesBuilder attributesBuilder;
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        AttributesBuilder attributesBuilder2 = Attributes.builder();
        Intrinsics.checkNotNullExpressionValue((Object)attributesBuilder2, (String)"builder(...)");
        AttributesBuilder $this$server_u24lambda_u240_u240 = attributesBuilder = OpenTelemetryMetricsDefaults.Companion.putBaseHttpInformationFrom(attributesBuilder2, tx);
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)tx.getRequest().getUri().getScheme())) {
            String string = tx.getRequest().getUri().getScheme().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            $this$server_u24lambda_u240_u240.put(UrlAttributes.URL_SCHEME, (Object)string);
        }
        $this$server_u24lambda_u240_u240.put(HttpAttributes.HTTP_ROUTE, !Intrinsics.areEqual((Object)tx.getRoutingGroup(), (Object)"UNMAPPED") ? "/" + OpenTelemetryMetricsDefaults.Companion.replaceRegexes(tx.getRoutingGroup()) : tx.getRoutingGroup());
        Attributes attributes = attributesBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"build(...)");
        return attributes;
    }

    private static final Attributes client$lambda$0(HttpTransaction tx) {
        AttributesBuilder attributesBuilder;
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        AttributesBuilder attributesBuilder2 = Attributes.builder();
        Intrinsics.checkNotNullExpressionValue((Object)attributesBuilder2, (String)"builder(...)");
        AttributesBuilder $this$client_u24lambda_u240_u240 = attributesBuilder = OpenTelemetryMetricsDefaults.Companion.putBaseHttpInformationFrom(attributesBuilder2, tx);
        boolean bl = false;
        String string = tx.getRequest().getUri().getHost().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        $this$client_u24lambda_u240_u240.put(ServerAttributes.SERVER_ADDRESS, (Object)string);
        Integer n = tx.getRequest().getUri().getPort();
        $this$client_u24lambda_u240_u240.put(ServerAttributes.SERVER_PORT, (Object)(n != null ? Long.valueOf(n.intValue()) : Long.valueOf(Intrinsics.areEqual((Object)tx.getRequest().getUri().getScheme(), (Object)"https") ? 443L : 80L)));
        Attributes attributes = attributesBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"build(...)");
        return attributes;
    }

    static {
        Object[] objectArray = new Double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0};
        DEFAULT_BUCKET_BOUNDARY_ADVICE = CollectionsKt.listOf((Object[])objectArray);
        urlTemplates = new Regex("\\{(.+):.+}");
        server = new OpenTelemetryMetricsDefaults((Pair<String, String>)TuplesKt.to((Object)"http.server.request.duration", (Object)"Duration of HTTP server requests."), DEFAULT_BUCKET_BOUNDARY_ADVICE, (Function1<? super HttpTransaction, ? extends Attributes>)((Function1)OpenTelemetryMetricsDefaults::server$lambda$0));
        client = new OpenTelemetryMetricsDefaults(TuplesKt.to((Object)"http.client.request.duration", (Object)"Duration of HTTP client requests."), null, OpenTelemetryMetricsDefaults::client$lambda$0, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000b\u001a\u00020\f*\u00020\fH\u0002J\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/http4k/metrics/OpenTelemetryMetricsDefaults$Companion;", "", "<init>", "()V", "DEFAULT_BUCKET_BOUNDARY_ADVICE", "", "", "getDEFAULT_BUCKET_BOUNDARY_ADVICE", "()Ljava/util/List;", "urlTemplates", "Lkotlin/text/Regex;", "replaceRegexes", "", "server", "Lorg/http4k/metrics/OpenTelemetryMetricsDefaults;", "getServer", "()Lorg/http4k/metrics/OpenTelemetryMetricsDefaults;", "client", "getClient", "putBaseHttpInformationFrom", "Lio/opentelemetry/api/common/AttributesBuilder;", "tx", "Lorg/http4k/core/HttpTransaction;", "http4k-ops-opentelemetry"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Double> getDEFAULT_BUCKET_BOUNDARY_ADVICE() {
            return DEFAULT_BUCKET_BOUNDARY_ADVICE;
        }

        private final String replaceRegexes(String $this$replaceRegexes) {
            CharSequence charSequence = $this$replaceRegexes;
            Regex regex = urlTemplates;
            String string = ":$1";
            return regex.replace(charSequence, string);
        }

        @NotNull
        public final OpenTelemetryMetricsDefaults getServer() {
            return server;
        }

        @NotNull
        public final OpenTelemetryMetricsDefaults getClient() {
            return client;
        }

        private final AttributesBuilder putBaseHttpInformationFrom(AttributesBuilder $this$putBaseHttpInformationFrom, HttpTransaction tx) {
            AttributesBuilder attributesBuilder;
            AttributesBuilder $this$putBaseHttpInformationFrom_u24lambda_u240 = attributesBuilder = $this$putBaseHttpInformationFrom;
            boolean bl = false;
            String string = tx.getRequest().getMethod().toString().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            $this$putBaseHttpInformationFrom_u24lambda_u240.put(HttpAttributes.HTTP_REQUEST_METHOD, (Object)string);
            $this$putBaseHttpInformationFrom_u24lambda_u240.put(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, (Object)tx.getResponse().getStatus().getCode());
            if (!tx.getResponse().getStatus().getSuccessful()) {
                $this$putBaseHttpInformationFrom_u24lambda_u240.put(ErrorAttributes.ERROR_TYPE, (Object)tx.getResponse().getStatus().getDescription());
            }
            $this$putBaseHttpInformationFrom_u24lambda_u240.put(NetworkAttributes.NETWORK_PROTOCOL_VERSION, (Object)StringsKt.removePrefix((String)tx.getRequest().getVersion(), (CharSequence)"HTTP/"));
            return attributesBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

