/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.aws;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.aws.AwsCanonicalRequest;
import org.http4k.aws.AwsCanonicalRequestKt;
import org.http4k.aws.AwsCredentialScope;
import org.http4k.aws.AwsCredentials;
import org.http4k.aws.AwsPreRequestSigner;
import org.http4k.aws.AwsPreSignedRequest;
import org.http4k.aws.AwsRequestDate;
import org.http4k.aws.AwsSignatureV4Signer;
import org.http4k.aws.RequestExtensionsKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.filter.CanonicalPayload;
import org.http4k.filter.Payload;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"AwsRequestPreSigner", "Lorg/http4k/aws/AwsPreRequestSigner;", "scope", "Lorg/http4k/aws/AwsCredentialScope;", "credentials", "Lorg/http4k/aws/AwsCredentials;", "clock", "Ljava/time/Clock;", "payloadMode", "Lorg/http4k/filter/Payload$Mode;", "credentialsProvider", "Lkotlin/Function0;", "http4k-platform-aws"})
@SourceDebugExtension(value={"SMAP\nAwsRequestPreSigner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsRequestPreSigner.kt\norg/http4k/aws/AwsRequestPreSignerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class AwsRequestPreSignerKt {
    @NotNull
    public static final AwsPreRequestSigner AwsRequestPreSigner(@NotNull AwsCredentialScope scope, @NotNull AwsCredentials credentials, @NotNull Clock clock, @NotNull Payload.Mode payloadMode) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)payloadMode, (String)"payloadMode");
        return AwsRequestPreSignerKt.AwsRequestPreSigner(scope, (Function0<AwsCredentials>)((Function0)() -> AwsRequestPreSignerKt.AwsRequestPreSigner$lambda$0(credentials)), clock, payloadMode);
    }

    public static /* synthetic */ AwsPreRequestSigner AwsRequestPreSigner$default(AwsCredentialScope awsCredentialScope, AwsCredentials awsCredentials, Clock clock, Payload.Mode mode, int n, Object object) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        if ((n & 8) != 0) {
            mode = Payload.Mode.Unsigned.INSTANCE;
        }
        return AwsRequestPreSignerKt.AwsRequestPreSigner(awsCredentialScope, awsCredentials, clock, mode);
    }

    @NotNull
    public static final AwsPreRequestSigner AwsRequestPreSigner(@NotNull AwsCredentialScope scope, @NotNull Function0<AwsCredentials> credentialsProvider, @NotNull Clock clock, @NotNull Payload.Mode payloadMode) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)payloadMode, (String)"payloadMode");
        return (arg_0, arg_1) -> AwsRequestPreSignerKt.AwsRequestPreSigner$lambda$1(clock, credentialsProvider, scope, payloadMode, arg_0, arg_1);
    }

    public static /* synthetic */ AwsPreRequestSigner AwsRequestPreSigner$default(AwsCredentialScope awsCredentialScope, Function0 function0, Clock clock, Payload.Mode mode, int n, Object object) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        if ((n & 8) != 0) {
            mode = Payload.Mode.Unsigned.INSTANCE;
        }
        return AwsRequestPreSignerKt.AwsRequestPreSigner(awsCredentialScope, (Function0<AwsCredentials>)function0, clock, mode);
    }

    private static final AwsCredentials AwsRequestPreSigner$lambda$0(AwsCredentials $credentials) {
        return $credentials;
    }

    /*
     * WARNING - void declaration
     */
    private static final AwsPreSignedRequest AwsRequestPreSigner$lambda$1(Clock $clock, Function0 $credentialsProvider, AwsCredentialScope $scope, Payload.Mode $payloadMode, Request request, Duration expires) {
        Object object;
        String string;
        String string2;
        Request request2;
        AwsCredentials credentials;
        AwsRequestDate awsDate;
        block4: {
            block3: {
                void port;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
                Instant instant = $clock.instant();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
                awsDate = AwsRequestDate.Companion.of(instant);
                credentials = (AwsCredentials)$credentialsProvider.invoke();
                request2 = RequestExtensionsKt.encodeUri(request);
                string2 = "Host";
                string = request.getUri().getHost();
                object = request.getUri().getPort();
                if (object == null) break block3;
                int n = ((Number)object).intValue();
                String string3 = string;
                String string4 = string2;
                Request request3 = request2;
                boolean bl = false;
                String string5 = ":" + (int)port;
                request2 = request3;
                string2 = string4;
                string = string3;
                String string6 = string5;
                object = string6;
                if (string6 != null) break block4;
            }
            object = "";
        }
        Request it = request2.replaceHeader(string2, string + (String)object);
        boolean bl = false;
        it = it.query("X-Amz-SignedHeaders", AwsCanonicalRequestKt.signedHeaders(it)).query("X-Amz-Algorithm", "AWS4-HMAC-SHA256").query("X-Amz-Date", awsDate.getFull()).query("X-Amz-Credential", credentials.getAccessKey() + "/" + $scope.datedScope$http4k_platform_aws(awsDate)).query("X-Amz-Expires", String.valueOf(expires.getSeconds()));
        boolean bl2 = false;
        Request fullRequest = credentials.getSessionToken() != null ? it.query("X-Amz-Security-Token", credentials.getSessionToken()) : it;
        AwsCanonicalRequest canonicalRequest = AwsCanonicalRequest.Companion.of(fullRequest, (CanonicalPayload)$payloadMode.invoke(request));
        String signature = AwsSignatureV4Signer.INSTANCE.sign(canonicalRequest, $scope, credentials, awsDate);
        Method method = fullRequest.getMethod();
        Uri uri = fullRequest.query("X-Amz-Signature", signature).getUri();
        List list = fullRequest.getHeaders();
        Instant instant = $clock.instant().plus(expires);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
        return new AwsPreSignedRequest(method, uri, list, instant);
    }
}

