/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.filter;

import java.time.Clock;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.aws.AwsCanonicalRequest;
import org.http4k.aws.AwsCredentialScope;
import org.http4k.aws.AwsCredentials;
import org.http4k.aws.AwsRequestDate;
import org.http4k.aws.AwsSignatureV4Signer;
import org.http4k.aws.RequestExtensionsKt;
import org.http4k.core.Body;
import org.http4k.core.Filter;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.filter.CanonicalPayload;
import org.http4k.filter.ClientFilters;
import org.http4k.filter.Payload;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a.\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u001a4\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u001a(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u001a\u0010\u0018\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013\"\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"AwsAuth", "Lorg/http4k/core/Filter;", "Lorg/http4k/filter/ClientFilters;", "scope", "Lorg/http4k/aws/AwsCredentialScope;", "credentials", "Lorg/http4k/aws/AwsCredentials;", "clock", "Ljava/time/Clock;", "payloadMode", "Lorg/http4k/filter/Payload$Mode;", "credentialsProvider", "Lkotlin/Function0;", "allowsContent", "", "Lorg/http4k/core/Method;", "getAllowsContent", "(Lorg/http4k/core/Method;)Z", "buildAuthHeader", "", "canonicalRequest", "Lorg/http4k/aws/AwsCanonicalRequest;", "date", "Lorg/http4k/aws/AwsRequestDate;", "SetAwsServiceUrl", "serviceName", "region", "http4k-platform-aws"})
@SourceDebugExtension(value={"SMAP\nawsExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 awsExtensions.kt\norg/http4k/filter/AwsExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class AwsExtensionsKt {
    @NotNull
    public static final Filter AwsAuth(@NotNull ClientFilters $this$AwsAuth, @NotNull AwsCredentialScope scope, @NotNull AwsCredentials credentials, @NotNull Clock clock, @NotNull Payload.Mode payloadMode) {
        Intrinsics.checkNotNullParameter((Object)$this$AwsAuth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)payloadMode, (String)"payloadMode");
        return AwsExtensionsKt.AwsAuth(ClientFilters.INSTANCE, scope, (Function0<AwsCredentials>)((Function0)() -> AwsExtensionsKt.AwsAuth$lambda$0(credentials)), clock, payloadMode);
    }

    public static /* synthetic */ Filter AwsAuth$default(ClientFilters clientFilters, AwsCredentialScope awsCredentialScope, AwsCredentials awsCredentials, Clock clock, Payload.Mode mode, int n, Object object) {
        if ((n & 4) != 0) {
            clock = Clock.systemDefaultZone();
        }
        if ((n & 8) != 0) {
            mode = Payload.Mode.Signed.INSTANCE;
        }
        return AwsExtensionsKt.AwsAuth(clientFilters, awsCredentialScope, awsCredentials, clock, mode);
    }

    @NotNull
    public static final Filter AwsAuth(@NotNull ClientFilters $this$AwsAuth, @NotNull AwsCredentialScope scope, @NotNull Function0<AwsCredentials> credentialsProvider, @NotNull Clock clock, @NotNull Payload.Mode payloadMode) {
        Intrinsics.checkNotNullParameter((Object)$this$AwsAuth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)payloadMode, (String)"payloadMode");
        return arg_0 -> AwsExtensionsKt.AwsAuth$lambda$6(payloadMode, credentialsProvider, clock, scope, arg_0);
    }

    public static /* synthetic */ Filter AwsAuth$default(ClientFilters clientFilters, AwsCredentialScope awsCredentialScope, Function0 function0, Clock clock, Payload.Mode mode, int n, Object object) {
        if ((n & 4) != 0) {
            clock = Clock.systemDefaultZone();
        }
        if ((n & 8) != 0) {
            mode = Payload.Mode.Signed.INSTANCE;
        }
        return AwsExtensionsKt.AwsAuth(clientFilters, awsCredentialScope, (Function0<AwsCredentials>)function0, clock, mode);
    }

    private static final boolean getAllowsContent(Method $this$allowsContent) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$allowsContent.ordinal()]) {
            case 1 -> false;
            case 2 -> false;
            case 3 -> false;
            case 4 -> false;
            case 5 -> false;
            default -> true;
        };
    }

    private static final String buildAuthHeader(AwsCredentialScope scope, AwsCredentials credentials, AwsCanonicalRequest canonicalRequest, AwsRequestDate date) {
        return "AWS4-HMAC-SHA256 Credential=" + credentials.getAccessKey() + "/" + scope.datedScope$http4k_platform_aws(date) + ", SignedHeaders=" + canonicalRequest.getSignedHeaders() + ", Signature=" + AwsSignatureV4Signer.INSTANCE.sign(canonicalRequest, scope, credentials, date);
    }

    @NotNull
    public static final Filter SetAwsServiceUrl(@NotNull ClientFilters $this$SetAwsServiceUrl, @NotNull String serviceName, @NotNull String region) {
        Intrinsics.checkNotNullParameter((Object)$this$SetAwsServiceUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        return $this$SetAwsServiceUrl.SetHostFrom(Uri.Companion.of("https://" + serviceName + "." + region + ".amazonaws.com"));
    }

    private static final AwsCredentials AwsAuth$lambda$0(AwsCredentials $credentials) {
        return $credentials;
    }

    /*
     * WARNING - void declaration
     */
    private static final Response AwsAuth$lambda$6$lambda$5(Payload.Mode $payloadMode, Function0 $credentialsProvider, Clock $clock, AwsCredentialScope $scope, Function1 $next, Request it) {
        String string;
        AwsRequestDate date;
        AwsCredentials credentials;
        CanonicalPayload payload;
        block9: {
            Request $this$AwsAuth_u24lambda_u246_u24lambda_u245_u24lambda_u244;
            block8: {
                Object object;
                String string2;
                String string3;
                Request request;
                block7: {
                    block6: {
                        void port;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        payload = (CanonicalPayload)$payloadMode.invoke(it);
                        credentials = (AwsCredentials)$credentialsProvider.invoke();
                        Instant instant = $clock.instant();
                        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
                        date = AwsRequestDate.Companion.of(instant);
                        request = RequestExtensionsKt.encodeUri(it);
                        string3 = "host";
                        string2 = it.getUri().getHost();
                        object = it.getUri().getPort();
                        if (object == null) break block6;
                        int n = ((Number)object).intValue();
                        String string4 = string2;
                        String string5 = string3;
                        Request request2 = request;
                        boolean bl = false;
                        String string6 = ":" + (int)port;
                        request = request2;
                        string3 = string5;
                        string2 = string4;
                        String string7 = string6;
                        object = string7;
                        if (string7 != null) break block7;
                    }
                    object = "";
                }
                Request it2 = request.replaceHeader(string3, string2 + (String)object).replaceHeader("x-amz-content-sha256", payload.getHash()).replaceHeader("x-amz-date", date.getFull());
                boolean bl = false;
                $this$AwsAuth_u24lambda_u246_u24lambda_u245_u24lambda_u244 = AwsExtensionsKt.getAllowsContent(it2.getMethod()) ? it2.replaceHeader("content-length", String.valueOf(payload.getLength())) : it2;
                boolean bl2 = false;
                string = credentials.getSessionToken();
                if (string == null) break block8;
                String it3 = string;
                boolean bl3 = false;
                Request request3 = $this$AwsAuth_u24lambda_u246_u24lambda_u245_u24lambda_u244.replaceHeader("x-amz-security-token", credentials.getSessionToken());
                string = request3;
                if (request3 != null) break block9;
            }
            string = $this$AwsAuth_u24lambda_u246_u24lambda_u245_u24lambda_u244;
        }
        String fullRequest = string;
        AwsCanonicalRequest canonicalRequest = AwsCanonicalRequest.Companion.of((Request)fullRequest, payload);
        Request signedRequest = fullRequest.replaceHeader("Authorization", AwsExtensionsKt.buildAuthHeader($scope, credentials, canonicalRequest, date));
        return (Response)$next.invoke((Object)signedRequest.body(Body.Companion.create(it.getBody().getPayload())));
    }

    private static final Function1 AwsAuth$lambda$6(Payload.Mode $payloadMode, Function0 $credentialsProvider, Clock $clock, AwsCredentialScope $scope, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return arg_0 -> AwsExtensionsKt.AwsAuth$lambda$6$lambda$5($payloadMode, $credentialsProvider, $clock, $scope, next, arg_0);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Method.values().length];
            try {
                nArray[Method.HEAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.GET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.OPTIONS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.TRACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.DELETE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

