/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.aws;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.aws.AwsCanonicalRequest;
import org.http4k.aws.AwsCredentialScope;
import org.http4k.aws.AwsCredentials;
import org.http4k.aws.AwsRequestDate;
import org.http4k.security.HmacSha256;
import org.http4k.util.Hex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u001c\u0010\u0014\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/http4k/aws/AwsSignatureV4Signer;", "", "<init>", "()V", "sign", "", "request", "Lorg/http4k/aws/AwsCanonicalRequest;", "scope", "Lorg/http4k/aws/AwsCredentialScope;", "awsCredentials", "Lorg/http4k/aws/AwsCredentials;", "date", "Lorg/http4k/aws/AwsRequestDate;", "getSignatureKey", "", "key", "dateStamp", "regionName", "serviceName", "stringToSign", "requestScope", "http4k-platform-aws"})
public final class AwsSignatureV4Signer {
    @NotNull
    public static final AwsSignatureV4Signer INSTANCE = new AwsSignatureV4Signer();

    private AwsSignatureV4Signer() {
    }

    @NotNull
    public final String sign(@NotNull AwsCanonicalRequest request, @NotNull AwsCredentialScope scope, @NotNull AwsCredentials awsCredentials, @NotNull AwsRequestDate date) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)awsCredentials, (String)"awsCredentials");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        byte[] signatureKey = this.getSignatureKey(awsCredentials.getSecretKey(), date.getBasic(), scope.getRegion(), scope.getService());
        byte[] signature = HmacSha256.INSTANCE.hmacSHA256(signatureKey, this.stringToSign(request, scope, date));
        return Hex.INSTANCE.hex(signature);
    }

    private final byte[] getSignatureKey(String key, String dateStamp, String regionName, String serviceName) {
        String string = "AWS4" + key;
        Charset charset = Charset.forName("UTF8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] kSecret = byArray;
        byte[] kDate = HmacSha256.INSTANCE.hmacSHA256(kSecret, dateStamp);
        byte[] kRegion = HmacSha256.INSTANCE.hmacSHA256(kDate, regionName);
        byte[] kService = HmacSha256.INSTANCE.hmacSHA256(kRegion, serviceName);
        return HmacSha256.INSTANCE.hmacSHA256(kService, "aws4_request");
    }

    private final String stringToSign(AwsCanonicalRequest $this$stringToSign, AwsCredentialScope requestScope, AwsRequestDate date) {
        return "AWS4-HMAC-SHA256\n" + date.getFull() + "\n" + requestScope.datedScope$http4k_platform_aws(date) + "\n" + HmacSha256.INSTANCE.hash($this$stringToSign.getValue());
    }
}

