/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.websocket;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/http4k/websocket/WsStatus;", "", "code", "", "description", "", "(ILjava/lang/String;)V", "getCode", "()I", "getDescription", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "http4k-realtime-core"})
public final class WsStatus {
    private final int code;
    @NotNull
    private final String description;
    @NotNull
    private static final WsStatus NORMAL;
    @NotNull
    private static final WsStatus GOING_AWAY;
    @NotNull
    private static final WsStatus PROTOCOL_ERROR;
    @NotNull
    private static final WsStatus REFUSE;
    @NotNull
    private static final WsStatus NOCODE;
    @NotNull
    private static final WsStatus ABNORMAL_CLOSE;
    @NotNull
    private static final WsStatus NO_UTF8;
    @NotNull
    private static final WsStatus POLICY_VALIDATION;
    @NotNull
    private static final WsStatus TOOBIG;
    @NotNull
    private static final WsStatus EXTENSION;
    @NotNull
    private static final WsStatus UNEXPECTED_CONDITION;
    @NotNull
    private static final WsStatus TLS_ERROR;
    @NotNull
    private static final WsStatus NEVER_CONNECTED;
    @NotNull
    private static final WsStatus BUGGYCLOSE;
    @NotNull
    private static final WsStatus FLASHPOLICY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final WsStatus description(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return WsStatus.copy$default(this, 0, description, 1, null);
    }

    public boolean equals(@Nullable Object other) {
        return other != null && other instanceof WsStatus && ((WsStatus)other).code == this.code;
    }

    public int hashCode() {
        return Integer.hashCode(this.code);
    }

    @NotNull
    public String toString() {
        return "" + this.code + ' ' + this.description;
    }

    public final int getCode() {
        return this.code;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public WsStatus(int code, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.code = code;
        this.description = description;
    }

    static {
        Companion = new Companion(null);
        NORMAL = new WsStatus(1000, "Normal");
        GOING_AWAY = new WsStatus(1001, "Going away");
        PROTOCOL_ERROR = new WsStatus(1002, "Protocol error");
        REFUSE = new WsStatus(1003, "Refuse");
        NOCODE = new WsStatus(1005, "No code");
        ABNORMAL_CLOSE = new WsStatus(1006, "Abnormal close");
        NO_UTF8 = new WsStatus(1007, "No UTF8");
        POLICY_VALIDATION = new WsStatus(1008, "Policy validation");
        TOOBIG = new WsStatus(1009, "Too big");
        EXTENSION = new WsStatus(1010, "Extension");
        UNEXPECTED_CONDITION = new WsStatus(1011, "Unexpected condition");
        TLS_ERROR = new WsStatus(1015, "TLS error");
        NEVER_CONNECTED = new WsStatus(-1, "Never connected");
        BUGGYCLOSE = new WsStatus(-2, "Buggy close");
        FLASHPOLICY = new WsStatus(-3, "Flash policy");
    }

    public final int component1() {
        return this.code;
    }

    @NotNull
    public final String component2() {
        return this.description;
    }

    @NotNull
    public final WsStatus copy(int code, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return new WsStatus(code, description);
    }

    public static /* synthetic */ WsStatus copy$default(WsStatus wsStatus, int n, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = wsStatus.code;
        }
        if ((n2 & 2) != 0) {
            string2 = wsStatus.description;
        }
        return wsStatus.copy(n, string2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006\u00a8\u0006#"}, d2={"Lorg/http4k/websocket/WsStatus$Companion;", "", "()V", "ABNORMAL_CLOSE", "Lorg/http4k/websocket/WsStatus;", "getABNORMAL_CLOSE", "()Lorg/http4k/websocket/WsStatus;", "BUGGYCLOSE", "getBUGGYCLOSE", "EXTENSION", "getEXTENSION", "FLASHPOLICY", "getFLASHPOLICY", "GOING_AWAY", "getGOING_AWAY", "NEVER_CONNECTED", "getNEVER_CONNECTED", "NOCODE", "getNOCODE", "NORMAL", "getNORMAL", "NO_UTF8", "getNO_UTF8", "POLICY_VALIDATION", "getPOLICY_VALIDATION", "PROTOCOL_ERROR", "getPROTOCOL_ERROR", "REFUSE", "getREFUSE", "TLS_ERROR", "getTLS_ERROR", "TOOBIG", "getTOOBIG", "UNEXPECTED_CONDITION", "getUNEXPECTED_CONDITION", "http4k-realtime-core"})
    public static final class Companion {
        @NotNull
        public final WsStatus getNORMAL() {
            return NORMAL;
        }

        @NotNull
        public final WsStatus getGOING_AWAY() {
            return GOING_AWAY;
        }

        @NotNull
        public final WsStatus getPROTOCOL_ERROR() {
            return PROTOCOL_ERROR;
        }

        @NotNull
        public final WsStatus getREFUSE() {
            return REFUSE;
        }

        @NotNull
        public final WsStatus getNOCODE() {
            return NOCODE;
        }

        @NotNull
        public final WsStatus getABNORMAL_CLOSE() {
            return ABNORMAL_CLOSE;
        }

        @NotNull
        public final WsStatus getNO_UTF8() {
            return NO_UTF8;
        }

        @NotNull
        public final WsStatus getPOLICY_VALIDATION() {
            return POLICY_VALIDATION;
        }

        @NotNull
        public final WsStatus getTOOBIG() {
            return TOOBIG;
        }

        @NotNull
        public final WsStatus getEXTENSION() {
            return EXTENSION;
        }

        @NotNull
        public final WsStatus getUNEXPECTED_CONDITION() {
            return UNEXPECTED_CONDITION;
        }

        @NotNull
        public final WsStatus getTLS_ERROR() {
            return TLS_ERROR;
        }

        @NotNull
        public final WsStatus getNEVER_CONNECTED() {
            return NEVER_CONNECTED;
        }

        @NotNull
        public final WsStatus getBUGGYCLOSE() {
            return BUGGYCLOSE;
        }

        @NotNull
        public final WsStatus getFLASHPOLICY() {
            return FLASHPOLICY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

