/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import java.time.Clock;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.lens.BiDiLens;
import org.http4k.lens.BiDiLensSpec;
import org.http4k.lens.LensSpec;
import org.http4k.lens.LensSpecKt;
import org.http4k.lens.Query;
import org.http4k.routing.RoutingHttpHandler;
import org.http4k.routing.RoutingKt;
import org.http4k.security.oauth.server.AccessTokens;
import org.http4k.security.oauth.server.AuthRequestPersistence;
import org.http4k.security.oauth.server.AuthRequestPersistenceFilter;
import org.http4k.security.oauth.server.AuthenticationCompleteFilter;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.ClientValidationFilter;
import org.http4k.security.oauth.server.ClientValidator;
import org.http4k.security.oauth.server.GenerateAccessToken;
import org.http4k.security.oauth.server.OAuthServer;
import org.http4k.security.oauth.server.OAuthServer$Companion$clientId$2;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lorg/http4k/security/oauth/server/OAuthServer;", "", "tokenPath", "", "authRequestPersistence", "Lorg/http4k/security/oauth/server/AuthRequestPersistence;", "clientValidator", "Lorg/http4k/security/oauth/server/ClientValidator;", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "accessTokens", "Lorg/http4k/security/oauth/server/AccessTokens;", "clock", "Ljava/time/Clock;", "(Ljava/lang/String;Lorg/http4k/security/oauth/server/AuthRequestPersistence;Lorg/http4k/security/oauth/server/ClientValidator;Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Ljava/time/Clock;)V", "authenticationComplete", "Lorg/http4k/security/oauth/server/AuthenticationCompleteFilter;", "getAuthenticationComplete", "()Lorg/http4k/security/oauth/server/AuthenticationCompleteFilter;", "authenticationStart", "Lorg/http4k/core/Filter;", "getAuthenticationStart", "()Lorg/http4k/core/Filter;", "tokenRoute", "Lorg/http4k/routing/RoutingHttpHandler;", "getTokenRoute", "()Lorg/http4k/routing/RoutingHttpHandler;", "Companion", "http4k-security-oauth"})
public final class OAuthServer {
    @NotNull
    private final RoutingHttpHandler tokenRoute;
    @NotNull
    private final Filter authenticationStart;
    @NotNull
    private final AuthenticationCompleteFilter authenticationComplete;
    @NotNull
    private static final BiDiLens<Request, ClientId> clientId;
    @NotNull
    private static final BiDiLens<Request, List<String>> scopes;
    @NotNull
    private static final BiDiLens<Request, Uri> redirectUri;
    @NotNull
    private static final BiDiLens<Request, String> state;
    public static final Companion Companion;

    @NotNull
    public final RoutingHttpHandler getTokenRoute() {
        return this.tokenRoute;
    }

    @NotNull
    public final Filter getAuthenticationStart() {
        return this.authenticationStart;
    }

    @NotNull
    public final AuthenticationCompleteFilter getAuthenticationComplete() {
        return this.authenticationComplete;
    }

    public OAuthServer(@NotNull String tokenPath, @NotNull AuthRequestPersistence authRequestPersistence, @NotNull ClientValidator clientValidator, @NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull Clock clock) {
        Intrinsics.checkParameterIsNotNull((Object)tokenPath, (String)"tokenPath");
        Intrinsics.checkParameterIsNotNull((Object)authRequestPersistence, (String)"authRequestPersistence");
        Intrinsics.checkParameterIsNotNull((Object)clientValidator, (String)"clientValidator");
        Intrinsics.checkParameterIsNotNull((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkParameterIsNotNull((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        this.tokenRoute = RoutingKt.routes((RoutingHttpHandler[])new RoutingHttpHandler[]{RoutingKt.bind((String)tokenPath, (Method)Method.POST).to((Function1)new GenerateAccessToken(clientValidator, authorizationCodes, accessTokens, clock))});
        this.authenticationStart = Http4kKt.then((Filter)new ClientValidationFilter(clientValidator), (Filter)new AuthRequestPersistenceFilter(authRequestPersistence));
        this.authenticationComplete = new AuthenticationCompleteFilter(authorizationCodes, authRequestPersistence);
    }

    static {
        Companion = new Companion(null);
        clientId = (BiDiLens)LensSpec.required$default((LensSpec)Query.INSTANCE.map((Function1)Companion.clientId.1.INSTANCE, (Function1)OAuthServer$Companion$clientId$2.INSTANCE), (String)"client_id", null, (int)2, null);
        scopes = (BiDiLens)LensSpec.optional$default((LensSpec)Query.INSTANCE.map((Function1)Companion.scopes.1.INSTANCE, (Function1)Companion.scopes.2.INSTANCE), (String)"scope", null, (int)2, null);
        redirectUri = (BiDiLens)LensSpec.required$default((LensSpec)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)Query.INSTANCE)), (String)"redirect_uri", null, (int)2, null);
        state = (BiDiLens)LensSpec.optional$default((LensSpec)Query.INSTANCE, (String)"state", null, (int)2, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR%\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u001f\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/http4k/security/oauth/server/OAuthServer$Companion;", "", "()V", "clientId", "Lorg/http4k/lens/BiDiLens;", "Lorg/http4k/core/Request;", "Lorg/http4k/security/oauth/server/ClientId;", "getClientId", "()Lorg/http4k/lens/BiDiLens;", "redirectUri", "Lorg/http4k/core/Uri;", "getRedirectUri", "scopes", "", "", "getScopes", "state", "getState", "http4k-security-oauth"})
    public static final class Companion {
        @NotNull
        public final BiDiLens<Request, ClientId> getClientId() {
            return clientId;
        }

        @NotNull
        public final BiDiLens<Request, List<String>> getScopes() {
            return scopes;
        }

        @NotNull
        public final BiDiLens<Request, Uri> getRedirectUri() {
            return redirectUri;
        }

        @NotNull
        public final BiDiLens<Request, String> getState() {
            return state;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

