/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import java.time.Clock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Body;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.lens.BiDiBodyLens;
import org.http4k.lens.BiDiLens;
import org.http4k.lens.BiDiLensSpec;
import org.http4k.lens.FormField;
import org.http4k.lens.Lens;
import org.http4k.lens.LensSpec;
import org.http4k.lens.LensSpecKt;
import org.http4k.lens.Validator;
import org.http4k.lens.WebForm;
import org.http4k.lens.WebFormKt;
import org.http4k.security.AccessTokenContainer;
import org.http4k.security.AccessTokenContainerKt;
import org.http4k.security.AccessTokenResponse;
import org.http4k.security.oauth.server.AccessTokenRequest;
import org.http4k.security.oauth.server.AccessTokens;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.oauth.server.AuthorizationCodeDetails;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.ClientValidator;
import org.http4k.security.oauth.server.GenerateAccessToken;
import org.http4k.security.oauth.server.GenerateAccessToken$Companion$authorizationCode$2;
import org.http4k.security.oauth.server.GenerateAccessToken$Companion$clientId$2;
import org.http4k.security.oauth.server.GenerateAccessToken$WhenMappings;
import org.http4k.security.oauth.server.GenerateAccessTokenKt;
import org.http4k.security.oauth.server.IdTokens;
import org.http4k.security.openid.IdTokenContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004:\u0001\u0012B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/http4k/security/oauth/server/GenerateAccessToken;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "clientValidator", "Lorg/http4k/security/oauth/server/ClientValidator;", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "accessTokens", "Lorg/http4k/security/oauth/server/AccessTokens;", "clock", "Ljava/time/Clock;", "idTokens", "Lorg/http4k/security/oauth/server/IdTokens;", "(Lorg/http4k/security/oauth/server/ClientValidator;Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Ljava/time/Clock;Lorg/http4k/security/oauth/server/IdTokens;)V", "invoke", "request", "Companion", "http4k-security-oauth"})
public final class GenerateAccessToken
implements Function1<Request, Response> {
    private final ClientValidator clientValidator;
    private final AuthorizationCodes authorizationCodes;
    private final AccessTokens accessTokens;
    private final Clock clock;
    private final IdTokens idTokens;
    @NotNull
    private static final BiDiLens<WebForm, AuthorizationCode> authorizationCode;
    @NotNull
    private static final BiDiLens<WebForm, Uri> redirectUri;
    private static final BiDiLens<WebForm, String> grantType;
    @NotNull
    private static final BiDiLens<WebForm, String> clientSecret;
    @NotNull
    private static final BiDiLens<WebForm, ClientId> clientId;
    @NotNull
    private static final BiDiBodyLens<WebForm> accessTokenForm;
    public static final Companion Companion;

    @NotNull
    public Response invoke(@NotNull Request request) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        WebForm form = (WebForm)accessTokenForm.invoke((HttpMessage)request);
        AccessTokenRequest accessTokenRequest = GenerateAccessTokenKt.access$accessTokenRequest(form);
        if (Intrinsics.areEqual((Object)((String)grantType.invoke((Object)form)), (Object)"authorization_code") ^ true) {
            return Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)Status.Companion.getBAD_REQUEST(), null, (int)2, null).body("Invalid grant type");
        }
        if (!this.clientValidator.validateCredentials(accessTokenRequest.getClientId(), accessTokenRequest.getClientSecret())) {
            return Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)Status.Companion.getUNAUTHORIZED(), null, (int)2, null).body("Invalid client credentials");
        }
        AuthorizationCode code = accessTokenRequest.getAuthorizationCode();
        AuthorizationCodeDetails codeDetails = this.authorizationCodes.detailsFor(code);
        if (codeDetails.getExpiresAt().isBefore(this.clock.instant())) {
            return Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)Status.Companion.getBAD_REQUEST(), null, (int)2, null).body("Authorization code has expired");
        }
        if (Intrinsics.areEqual((Object)codeDetails.getClientId(), (Object)accessTokenRequest.getClientId()) ^ true) {
            return Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)Status.Companion.getBAD_REQUEST(), null, (int)2, null).body("Invalid client_id");
        }
        if (Intrinsics.areEqual((Object)codeDetails.getRedirectUri(), (Object)accessTokenRequest.getRedirectUri()) ^ true) {
            return Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)Status.Companion.getBAD_REQUEST(), null, (int)2, null).body("Invalid redirect_uri");
        }
        AccessTokenContainer accessToken = this.accessTokens.create(code);
        Response response2 = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)Status.Companion.getOK(), null, (int)2, null);
        boolean bl = false;
        boolean bl2 = false;
        Response it = response2;
        boolean bl3 = false;
        switch (GenerateAccessToken$WhenMappings.$EnumSwitchMapping$0[codeDetails.getResponseType().ordinal()]) {
            case 1: {
                response = it.body(accessToken.getValue());
                break;
            }
            case 2: {
                IdTokenContainer idToken = this.idTokens.createForAccessToken(code);
                response = (Response)HttpKt.with((Object)it, (Function1[])new Function1[]{AccessTokenContainerKt.getAccessTokenResponseBody().of((Object)new AccessTokenResponse(accessToken.getValue(), idToken.getValue()))});
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        response2 = response;
        bl = false;
        bl2 = false;
        it = response2;
        boolean bl4 = false;
        this.authorizationCodes.destroy(code);
        return response2;
    }

    public GenerateAccessToken(@NotNull ClientValidator clientValidator, @NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull Clock clock, @NotNull IdTokens idTokens) {
        Intrinsics.checkParameterIsNotNull((Object)clientValidator, (String)"clientValidator");
        Intrinsics.checkParameterIsNotNull((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkParameterIsNotNull((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)idTokens, (String)"idTokens");
        this.clientValidator = clientValidator;
        this.authorizationCodes = authorizationCodes;
        this.accessTokens = accessTokens;
        this.clock = clock;
        this.idTokens = idTokens;
    }

    static {
        Companion = new Companion(null);
        authorizationCode = (BiDiLens)LensSpec.required$default((LensSpec)FormField.INSTANCE.map((Function1)Companion.authorizationCode.1.INSTANCE, (Function1)GenerateAccessToken$Companion$authorizationCode$2.INSTANCE), (String)"code", null, (int)2, null);
        redirectUri = (BiDiLens)LensSpec.required$default((LensSpec)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)FormField.INSTANCE)), (String)"redirect_uri", null, (int)2, null);
        grantType = (BiDiLens)LensSpec.required$default((LensSpec)FormField.INSTANCE, (String)"grant_type", null, (int)2, null);
        clientSecret = (BiDiLens)LensSpec.required$default((LensSpec)FormField.INSTANCE, (String)"client_secret", null, (int)2, null);
        clientId = (BiDiLens)LensSpec.required$default((LensSpec)FormField.INSTANCE.map((Function1)Companion.clientId.1.INSTANCE, (Function1)GenerateAccessToken$Companion$clientId$2.INSTANCE), (String)"client_id", null, (int)2, null);
        accessTokenForm = WebFormKt.webForm((Body.Companion)Body.Companion, (Validator)Validator.Strict, (Lens[])new Lens[]{(Lens)authorizationCode, (Lens)redirectUri, (Lens)grantType, (Lens)clientId, (Lens)clientSecret}).toLens();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/http4k/security/oauth/server/GenerateAccessToken$Companion;", "", "()V", "accessTokenForm", "Lorg/http4k/lens/BiDiBodyLens;", "Lorg/http4k/lens/WebForm;", "getAccessTokenForm", "()Lorg/http4k/lens/BiDiBodyLens;", "authorizationCode", "Lorg/http4k/lens/BiDiLens;", "Lorg/http4k/security/oauth/server/AuthorizationCode;", "getAuthorizationCode$http4k_security_oauth", "()Lorg/http4k/lens/BiDiLens;", "clientId", "Lorg/http4k/security/oauth/server/ClientId;", "getClientId$http4k_security_oauth", "clientSecret", "", "getClientSecret$http4k_security_oauth", "grantType", "redirectUri", "Lorg/http4k/core/Uri;", "getRedirectUri$http4k_security_oauth", "http4k-security-oauth"})
    public static final class Companion {
        @NotNull
        public final BiDiLens<WebForm, AuthorizationCode> getAuthorizationCode$http4k_security_oauth() {
            return authorizationCode;
        }

        @NotNull
        public final BiDiLens<WebForm, Uri> getRedirectUri$http4k_security_oauth() {
            return redirectUri;
        }

        @NotNull
        public final BiDiLens<WebForm, String> getClientSecret$http4k_security_oauth() {
            return clientSecret;
        }

        @NotNull
        public final BiDiLens<WebForm, ClientId> getClientId$http4k_security_oauth() {
            return clientId;
        }

        @NotNull
        public final BiDiBodyLens<WebForm> getAccessTokenForm() {
            return accessTokenForm;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

