/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security;

import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.cookie.Cookie;
import org.http4k.core.cookie.CookieExtensionsKt;
import org.http4k.security.AccessTokenContainer;
import org.http4k.security.CrossSiteRequestForgeryToken;
import org.http4k.security.OAuthPersistence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\fH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/http4k/security/InsecureCookieBasedOAuthPersistence;", "Lorg/http4k/security/OAuthPersistence;", "cookieNamePrefix", "", "cookieValidity", "Ljava/time/Duration;", "clock", "Ljava/time/Clock;", "(Ljava/lang/String;Ljava/time/Duration;Ljava/time/Clock;)V", "accessTokenCookieName", "csrfName", "assignCsrf", "Lorg/http4k/core/Response;", "redirect", "csrf", "Lorg/http4k/security/CrossSiteRequestForgeryToken;", "assignToken", "request", "Lorg/http4k/core/Request;", "accessToken", "Lorg/http4k/security/AccessTokenContainer;", "authFailureResponse", "expiring", "Lorg/http4k/core/cookie/Cookie;", "name", "value", "retrieveCsrf", "retrieveToken", "http4k-security-oauth"})
public final class InsecureCookieBasedOAuthPersistence
implements OAuthPersistence {
    private final String csrfName;
    private final String accessTokenCookieName;
    private final Duration cookieValidity;
    private final Clock clock;

    @Override
    @Nullable
    public CrossSiteRequestForgeryToken retrieveCsrf(@NotNull Request request) {
        CrossSiteRequestForgeryToken crossSiteRequestForgeryToken;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request, (String)this.csrfName);
        if (object != null && (object = object.getValue()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object p1 = object2;
            boolean bl3 = false;
            crossSiteRequestForgeryToken = new CrossSiteRequestForgeryToken((String)p1);
        } else {
            crossSiteRequestForgeryToken = null;
        }
        return crossSiteRequestForgeryToken;
    }

    @Override
    @Nullable
    public AccessTokenContainer retrieveToken(@NotNull Request request) {
        AccessTokenContainer accessTokenContainer;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request, (String)this.accessTokenCookieName);
        if (object != null && (object = object.getValue()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object p1 = object2;
            boolean bl3 = false;
            accessTokenContainer = new AccessTokenContainer((String)p1);
        } else {
            accessTokenContainer = null;
        }
        return accessTokenContainer;
    }

    @Override
    @NotNull
    public Response assignCsrf(@NotNull Response redirect, @NotNull CrossSiteRequestForgeryToken csrf) {
        Intrinsics.checkParameterIsNotNull((Object)redirect, (String)"redirect");
        Intrinsics.checkParameterIsNotNull((Object)csrf, (String)"csrf");
        return CookieExtensionsKt.cookie((Response)redirect, (Cookie)this.expiring(this.csrfName, csrf.getValue()));
    }

    @Override
    @NotNull
    public Response assignToken(@NotNull Request request, @NotNull Response redirect, @NotNull AccessTokenContainer accessToken) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)redirect, (String)"redirect");
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        return CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.cookie((Response)redirect, (Cookie)this.expiring(this.accessTokenCookieName, accessToken.getValue())), (String)this.csrfName, null, (int)2, null);
    }

    @Override
    @NotNull
    public Response authFailureResponse() {
        return CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)Status.Companion.getFORBIDDEN(), null, (int)2, null), (String)this.csrfName, null, (int)2, null), (String)this.accessTokenCookieName, null, (int)2, null);
    }

    private final Cookie expiring(String name, String value) {
        return new Cookie(name, value, null, LocalDateTime.ofInstant(this.clock.instant().plus(this.cookieValidity), ZoneId.of("GMT")), null, null, false, false, 244, null);
    }

    public InsecureCookieBasedOAuthPersistence(@NotNull String cookieNamePrefix, @NotNull Duration cookieValidity, @NotNull Clock clock) {
        Intrinsics.checkParameterIsNotNull((Object)cookieNamePrefix, (String)"cookieNamePrefix");
        Intrinsics.checkParameterIsNotNull((Object)cookieValidity, (String)"cookieValidity");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        this.cookieValidity = cookieValidity;
        this.clock = clock;
        this.csrfName = cookieNamePrefix + "Csrf";
        this.accessTokenCookieName = cookieNamePrefix + "AccessToken";
    }

    public /* synthetic */ InsecureCookieBasedOAuthPersistence(String string, Duration duration, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofHours(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofHours(1)");
            duration = duration2;
        }
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkExpressionValueIsNotNull((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        this(string, duration, clock);
    }
}

