/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import com.natpryce.Failure;
import com.natpryce.Result;
import com.natpryce.ResultKt;
import com.natpryce.Success;
import java.time.Clock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.HttpKt;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.security.AccessTokenContainer;
import org.http4k.security.AccessTokenContainerKt;
import org.http4k.security.AccessTokenDetails;
import org.http4k.security.AccessTokenResponse;
import org.http4k.security.oauth.server.AccessTokenError;
import org.http4k.security.oauth.server.AccessTokenRequest;
import org.http4k.security.oauth.server.AccessTokenRequestKt;
import org.http4k.security.oauth.server.AccessTokens;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.oauth.server.AuthorizationCodeAlreadyUsed;
import org.http4k.security.oauth.server.AuthorizationCodeDetails;
import org.http4k.security.oauth.server.AuthorizationCodeExpired;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientIdMismatch;
import org.http4k.security.oauth.server.ClientValidator;
import org.http4k.security.oauth.server.ErrorRenderer;
import org.http4k.security.oauth.server.GenerateAccessToken$WhenMappings;
import org.http4k.security.oauth.server.IdTokens;
import org.http4k.security.oauth.server.InvalidClientCredentials;
import org.http4k.security.oauth.server.OAuthError;
import org.http4k.security.oauth.server.RedirectUriMismatch;
import org.http4k.security.oauth.server.UnsupportedGrantType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004B5\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0011\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/http4k/security/oauth/server/GenerateAccessToken;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "clientValidator", "Lorg/http4k/security/oauth/server/ClientValidator;", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "accessTokens", "Lorg/http4k/security/oauth/server/AccessTokens;", "clock", "Ljava/time/Clock;", "idTokens", "Lorg/http4k/security/oauth/server/IdTokens;", "errorRenderer", "Lorg/http4k/security/oauth/server/ErrorRenderer;", "(Lorg/http4k/security/oauth/server/ClientValidator;Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Ljava/time/Clock;Lorg/http4k/security/oauth/server/IdTokens;Lorg/http4k/security/oauth/server/ErrorRenderer;)V", "generateAccessToken", "Lcom/natpryce/Result;", "Lorg/http4k/security/AccessTokenDetails;", "Lorg/http4k/security/oauth/server/AccessTokenError;", "accessTokenRequest", "Lorg/http4k/security/oauth/server/AccessTokenRequest;", "invoke", "request", "http4k-security-oauth"})
public final class GenerateAccessToken
implements Function1<Request, Response> {
    private final ClientValidator clientValidator;
    private final AuthorizationCodes authorizationCodes;
    private final AccessTokens accessTokens;
    private final Clock clock;
    private final IdTokens idTokens;
    private final ErrorRenderer errorRenderer;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Response invoke(@NotNull Request request) {
        Result result;
        Result result2;
        Response response;
        void $receiver$iv;
        Result<AccessTokenDetails, AccessTokenError> accessTokenResult;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        AccessTokenRequest accessTokenRequest = AccessTokenRequestKt.accessTokenRequest(request);
        Result<AccessTokenDetails, AccessTokenError> result3 = accessTokenResult = this.generateAccessToken(accessTokenRequest);
        ErrorRenderer errorRenderer = $receiver$iv;
        if (errorRenderer instanceof Success) {
            AccessTokenDetails token = (AccessTokenDetails)((Success)$receiver$iv).getValue();
            boolean bl = false;
            Response response2 = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)Status.Companion.getOK(), null, (int)2, null);
            boolean bl2 = false;
            boolean bl3 = false;
            Response it = response2;
            boolean bl4 = false;
            Response response3 = response = token.getIdToken() == null ? it.body(token.getAccessToken().getValue()) : (Response)HttpKt.with((Object)it, (Function1[])new Function1[]{AccessTokenContainerKt.getAccessTokenResponseBody().of((Object)new AccessTokenResponse(token.getAccessToken().getValue(), token.getIdToken().getValue()))});
            result2 = (Result)new Success((Object)response3);
        } else if (errorRenderer instanceof Failure) {
            result2 = $receiver$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $receiver$iv = result2;
        errorRenderer = this.errorRenderer;
        void var6_6 = $receiver$iv;
        if (var6_6 instanceof Success) {
            result = $receiver$iv;
        } else if (var6_6 instanceof Failure) {
            OAuthError p1 = (OAuthError)((Failure)$receiver$iv).getReason();
            boolean bl = false;
            Response response4 = response = errorRenderer.response(p1);
            result = (Result)new Failure((Object)response4);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (Response)ResultKt.get((Result)result);
    }

    /*
     * WARNING - void declaration
     */
    private final Result<AccessTokenDetails, AccessTokenError> generateAccessToken(AccessTokenRequest accessTokenRequest) {
        Result result;
        if (Intrinsics.areEqual((Object)accessTokenRequest.getGrantType(), (Object)"authorization_code") ^ true) {
            result = (Result)new Failure((Object)new UnsupportedGrantType(accessTokenRequest.getGrantType()));
        } else if (!this.clientValidator.validateCredentials(accessTokenRequest.getClientId(), accessTokenRequest.getClientSecret())) {
            result = (Result)new Failure((Object)InvalidClientCredentials.INSTANCE);
        } else {
            AuthorizationCode code = accessTokenRequest.getAuthorizationCode();
            AuthorizationCodeDetails codeDetails = this.authorizationCodes.detailsFor(code);
            if (codeDetails.getExpiresAt().isBefore(this.clock.instant())) {
                result = (Result)new Failure((Object)AuthorizationCodeExpired.INSTANCE);
            } else if (Intrinsics.areEqual((Object)codeDetails.getClientId(), (Object)accessTokenRequest.getClientId()) ^ true) {
                result = (Result)new Failure((Object)ClientIdMismatch.INSTANCE);
            } else if (Intrinsics.areEqual((Object)codeDetails.getRedirectUri(), (Object)accessTokenRequest.getRedirectUri()) ^ true) {
                result = (Result)new Failure((Object)RedirectUriMismatch.INSTANCE);
            } else {
                void $receiver$iv;
                Result<AccessTokenContainer, AuthorizationCodeAlreadyUsed> result2 = this.accessTokens.create(code);
                void var5_5 = $receiver$iv;
                if (var5_5 instanceof Success) {
                    AccessTokenDetails accessTokenDetails;
                    AccessTokenDetails accessTokenDetails2;
                    AccessTokenContainer token = (AccessTokenContainer)((Success)$receiver$iv).getValue();
                    boolean bl = false;
                    switch (GenerateAccessToken$WhenMappings.$EnumSwitchMapping$0[codeDetails.getResponseType().ordinal()]) {
                        case 1: {
                            accessTokenDetails2 = new AccessTokenDetails(token, null, 2, null);
                            break;
                        }
                        case 2: {
                            accessTokenDetails2 = new AccessTokenDetails(token, this.idTokens.createForAccessToken(code));
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    AccessTokenDetails accessTokenDetails3 = accessTokenDetails = accessTokenDetails2;
                    result = (Result)new Success((Object)accessTokenDetails3);
                } else if (var5_5 instanceof Failure) {
                    result = $receiver$iv;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return result;
    }

    public GenerateAccessToken(@NotNull ClientValidator clientValidator, @NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull Clock clock, @NotNull IdTokens idTokens, @NotNull ErrorRenderer errorRenderer) {
        Intrinsics.checkParameterIsNotNull((Object)clientValidator, (String)"clientValidator");
        Intrinsics.checkParameterIsNotNull((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkParameterIsNotNull((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)idTokens, (String)"idTokens");
        Intrinsics.checkParameterIsNotNull((Object)errorRenderer, (String)"errorRenderer");
        this.clientValidator = clientValidator;
        this.authorizationCodes = authorizationCodes;
        this.accessTokens = accessTokens;
        this.clock = clock;
        this.idTokens = idTokens;
        this.errorRenderer = errorRenderer;
    }
}

