package org.http4k.security.oauth.server.accesstoken

import org.http4k.security.oauth.server.ClientValidator

enum class GrantType(val rfcValue: String) {
    AuthorizationCode("authorization_code"),
    ClientCredentials("client_credentials")
}

data class GrantTypesConfiguration(val supportedGrantTypes: Map<GrantType, AccessTokenRequestAuthentication>) {
    companion object {
        fun default(clientValidator: ClientValidator): GrantTypesConfiguration {
            val requestAuthentication = ClientSecretAccessTokenRequestAuthentication(clientValidator)
            return GrantTypesConfiguration(mapOf(
                GrantType.AuthorizationCode to requestAuthentication,
                GrantType.ClientCredentials to requestAuthentication
            ))
        }
    }
}