/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import com.natpryce.Failure;
import com.natpryce.Result;
import com.natpryce.Success;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthoriseRequestValidator;
import org.http4k.security.oauth.server.ClientValidator;
import org.http4k.security.oauth.server.InvalidClientId;
import org.http4k.security.oauth.server.InvalidRedirectUri;
import org.http4k.security.oauth.server.InvalidScopes;
import org.http4k.security.oauth.server.OAuthError;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/http4k/security/oauth/server/SimpleAuthoriseRequestValidator;", "Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;", "clientValidator", "Lorg/http4k/security/oauth/server/ClientValidator;", "(Lorg/http4k/security/oauth/server/ClientValidator;)V", "validate", "Lcom/natpryce/Result;", "Lorg/http4k/core/Request;", "Lorg/http4k/security/oauth/server/OAuthError;", "request", "authorizationRequest", "Lorg/http4k/security/oauth/server/AuthRequest;", "http4k-security-oauth"})
public final class SimpleAuthoriseRequestValidator
implements AuthoriseRequestValidator {
    private final ClientValidator clientValidator;

    @Override
    @NotNull
    public Result<Request, OAuthError> validate(@NotNull Request request2, @NotNull AuthRequest authorizationRequest) {
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authorizationRequest, (String)"authorizationRequest");
        return !this.clientValidator.validateClientId(request2, authorizationRequest.getClient()) ? (Result)new Failure((Object)InvalidClientId.INSTANCE) : (!this.clientValidator.validateRedirection(request2, authorizationRequest.getClient(), authorizationRequest.getRedirectUri()) ? (Result)new Failure((Object)InvalidRedirectUri.INSTANCE) : (!this.clientValidator.validateScopes(request2, authorizationRequest.getClient(), authorizationRequest.getScopes()) ? (Result)new Failure((Object)InvalidScopes.INSTANCE) : (Result)new Success((Object)request2)));
    }

    public SimpleAuthoriseRequestValidator(@NotNull ClientValidator clientValidator) {
        Intrinsics.checkParameterIsNotNull((Object)clientValidator, (String)"clientValidator");
        this.clientValidator = clientValidator;
    }
}

