/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.lens.LensFailure;
import org.http4k.security.ResponseMode;
import org.http4k.security.ResponseType;
import org.http4k.security.oauth.server.AuthoriseRequestErrorRender;
import org.http4k.security.oauth.server.AuthoriseRequestValidator;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.JsonResponseErrorRenderer;
import org.http4k.security.oauth.server.OAuthError;
import org.http4k.security.oauth.server.ResponseRender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ3\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u0001H\u00100\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/http4k/security/oauth/server/AuthoriseRequestErrorRender;", "", "authoriseRequestValidator", "Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;", "fallBack", "Lorg/http4k/security/oauth/server/JsonResponseErrorRenderer;", "documentationUri", "", "(Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;Lorg/http4k/security/oauth/server/JsonResponseErrorRenderer;Ljava/lang/String;)V", "errorFor", "Lorg/http4k/core/Response;", "request", "Lorg/http4k/core/Request;", "error", "Lorg/http4k/security/oauth/server/OAuthError;", "extractValueOrNull", "T", "callback", "Lkotlin/Function1;", "(Lorg/http4k/core/Request;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "http4k-security-oauth"})
public final class AuthoriseRequestErrorRender {
    private final AuthoriseRequestValidator authoriseRequestValidator;
    private final JsonResponseErrorRenderer fallBack;
    private final String documentationUri;

    @NotNull
    public final Response errorFor(@NotNull Request request2, @NotNull OAuthError error) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        ClientId clientId2 = (ClientId)this.extractValueOrNull(request2, errorFor.clientId.1.INSTANCE);
        Uri redirectUri2 = (Uri)this.extractValueOrNull(request2, errorFor.redirectUri.1.INSTANCE);
        ResponseMode responseMode2 = (ResponseMode)((Object)this.extractValueOrNull(request2, errorFor.responseMode.1.INSTANCE));
        ResponseType responseType2 = (ResponseType)((Object)this.extractValueOrNull(request2, errorFor.responseType.1.INSTANCE));
        if (responseType2 == null) {
            responseType2 = ResponseType.Code;
        }
        ResponseType responseType3 = responseType2;
        String state2 = (String)this.extractValueOrNull(request2, errorFor.state.1.INSTANCE);
        if (clientId2 == null || redirectUri2 == null || !this.authoriseRequestValidator.isValidClientAndRedirectUriInCaseOfError(request2, clientId2, redirectUri2)) {
            response = this.fallBack.response(error);
        } else {
            ResponseRender responseRender = ResponseRender.Companion.forAuthRequest(responseMode2, responseType3, redirectUri2).withState(state2).addParameter("error", error.getRfcError().getRfcValue()).addParameter("error_description", error.getDescription());
            response = this.documentationUri != null ? responseRender.addParameter("error_uri", this.documentationUri).complete() : responseRender.complete();
        }
        return response;
    }

    private final <T> T extractValueOrNull(Request request2, Function1<? super Request, ? extends T> callback) {
        Object object;
        try {
            object = callback.invoke((Object)request2);
        }
        catch (LensFailure e) {
            object = null;
        }
        return (T)object;
    }

    public AuthoriseRequestErrorRender(@NotNull AuthoriseRequestValidator authoriseRequestValidator, @NotNull JsonResponseErrorRenderer fallBack, @Nullable String documentationUri) {
        Intrinsics.checkParameterIsNotNull((Object)authoriseRequestValidator, (String)"authoriseRequestValidator");
        Intrinsics.checkParameterIsNotNull((Object)fallBack, (String)"fallBack");
        this.authoriseRequestValidator = authoriseRequestValidator;
        this.fallBack = fallBack;
        this.documentationUri = documentationUri;
    }

    public /* synthetic */ AuthoriseRequestErrorRender(AuthoriseRequestValidator authoriseRequestValidator, JsonResponseErrorRenderer jsonResponseErrorRenderer, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(authoriseRequestValidator, jsonResponseErrorRenderer, string);
    }
}

