/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import java.time.Clock;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.http4k.core.Body;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.format.AutoMarshallingJson;
import org.http4k.lens.BiDiBodyLens;
import org.http4k.lens.BiDiLens;
import org.http4k.lens.BiDiLensSpec;
import org.http4k.lens.FormField;
import org.http4k.lens.Lens;
import org.http4k.lens.LensSpec;
import org.http4k.lens.LensSpecKt;
import org.http4k.lens.Query;
import org.http4k.lens.Validator;
import org.http4k.lens.WebForm;
import org.http4k.lens.WebFormKt;
import org.http4k.routing.RoutingHttpHandler;
import org.http4k.routing.RoutingKt;
import org.http4k.security.ResponseMode;
import org.http4k.security.ResponseType;
import org.http4k.security.oauth.server.AccessTokens;
import org.http4k.security.oauth.server.AuthRequestExtractor;
import org.http4k.security.oauth.server.AuthRequestFromQueryParameters;
import org.http4k.security.oauth.server.AuthRequestTracking;
import org.http4k.security.oauth.server.AuthRequestTrackingFilter;
import org.http4k.security.oauth.server.AuthenticationComplete;
import org.http4k.security.oauth.server.AuthoriseRequestErrorRender;
import org.http4k.security.oauth.server.AuthoriseRequestValidator;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.ClientValidationFilter;
import org.http4k.security.oauth.server.ClientValidator;
import org.http4k.security.oauth.server.GenerateAccessToken;
import org.http4k.security.oauth.server.IdTokens;
import org.http4k.security.oauth.server.JsonResponseErrorRenderer;
import org.http4k.security.oauth.server.OAuthServer;
import org.http4k.security.oauth.server.OAuthServer$Companion$clientIdForm$2;
import org.http4k.security.oauth.server.OAuthServer$Companion$clientIdQueryParameter$2;
import org.http4k.security.oauth.server.OAuthServer$Companion$nonce$2;
import org.http4k.security.oauth.server.OAuthServer$Companion$request$2;
import org.http4k.security.oauth.server.OAuthServer$Companion$responseMode$2;
import org.http4k.security.oauth.server.OAuthServer$Companion$responseType$2;
import org.http4k.security.oauth.server.SimpleAuthoriseRequestValidator;
import org.http4k.security.oauth.server.accesstoken.AccessTokenRequestAuthentication;
import org.http4k.security.oauth.server.accesstoken.ClientSecretAccessTokenRequestAuthentication;
import org.http4k.security.oauth.server.accesstoken.GrantTypesConfiguration;
import org.http4k.security.openid.Nonce;
import org.http4k.security.openid.RequestJwtContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0001-Bi\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0017Bo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lorg/http4k/security/oauth/server/OAuthServer;", "", "tokenPath", "", "authRequestTracking", "Lorg/http4k/security/oauth/server/AuthRequestTracking;", "clientValidator", "Lorg/http4k/security/oauth/server/ClientValidator;", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "accessTokens", "Lorg/http4k/security/oauth/server/AccessTokens;", "json", "Lorg/http4k/format/AutoMarshallingJson;", "clock", "Ljava/time/Clock;", "authRequestExtractor", "Lorg/http4k/security/oauth/server/AuthRequestExtractor;", "grantTypes", "Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;", "idTokens", "Lorg/http4k/security/oauth/server/IdTokens;", "documentationUri", "(Ljava/lang/String;Lorg/http4k/security/oauth/server/AuthRequestTracking;Lorg/http4k/security/oauth/server/ClientValidator;Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Lorg/http4k/format/AutoMarshallingJson;Ljava/time/Clock;Lorg/http4k/security/oauth/server/AuthRequestExtractor;Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;Lorg/http4k/security/oauth/server/IdTokens;Ljava/lang/String;)V", "authoriseRequestValidator", "Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;", "accessTokenRequestAuthentication", "Lorg/http4k/security/oauth/server/accesstoken/AccessTokenRequestAuthentication;", "(Ljava/lang/String;Lorg/http4k/security/oauth/server/AuthRequestTracking;Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;Lorg/http4k/security/oauth/server/accesstoken/AccessTokenRequestAuthentication;Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Lorg/http4k/format/AutoMarshallingJson;Ljava/time/Clock;Lorg/http4k/security/oauth/server/AuthRequestExtractor;Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;Lorg/http4k/security/oauth/server/IdTokens;Ljava/lang/String;)V", "authenticationComplete", "Lorg/http4k/security/oauth/server/AuthenticationComplete;", "getAuthenticationComplete", "()Lorg/http4k/security/oauth/server/AuthenticationComplete;", "authenticationStart", "Lorg/http4k/core/Filter;", "getAuthenticationStart", "()Lorg/http4k/core/Filter;", "authoriseRequestErrorRender", "Lorg/http4k/security/oauth/server/AuthoriseRequestErrorRender;", "errorRenderer", "Lorg/http4k/security/oauth/server/JsonResponseErrorRenderer;", "tokenRoute", "Lorg/http4k/routing/RoutingHttpHandler;", "getTokenRoute", "()Lorg/http4k/routing/RoutingHttpHandler;", "Companion", "http4k-security-oauth"})
public final class OAuthServer {
    private final JsonResponseErrorRenderer errorRenderer;
    private final AuthoriseRequestErrorRender authoriseRequestErrorRender;
    @NotNull
    private final RoutingHttpHandler tokenRoute;
    @NotNull
    private final Filter authenticationStart;
    @NotNull
    private final AuthenticationComplete authenticationComplete;
    @NotNull
    private static final BiDiLens<Request, ClientId> clientIdQueryParameter;
    @NotNull
    private static final BiDiLens<Request, List<String>> scopesQueryParameter;
    @NotNull
    private static final BiDiLens<Request, Uri> redirectUriQueryParameter;
    @NotNull
    private static final BiDiLens<Request, String> state;
    @NotNull
    private static final BiDiLens<Request, ResponseType> responseType;
    @NotNull
    private static final BiDiLens<Request, ResponseMode> responseMode;
    @NotNull
    private static final BiDiLens<Request, Nonce> nonce;
    @NotNull
    private static final BiDiLens<Request, RequestJwtContainer> request;
    @NotNull
    private static final BiDiLens<WebForm, ClientId> clientIdForm;
    @NotNull
    private static final BiDiLens<WebForm, String> clientSecret;
    @NotNull
    private static final BiDiLens<WebForm, String> code;
    @NotNull
    private static final BiDiLens<WebForm, Uri> redirectUriForm;
    @NotNull
    private static final BiDiLens<WebForm, List<String>> scopesForm;
    @NotNull
    private static final BiDiLens<WebForm, Uri> clientAssertionType;
    @NotNull
    private static final BiDiLens<WebForm, String> clientAssertion;
    @NotNull
    private static final BiDiBodyLens<WebForm> tokenRequestWebForm;
    public static final Companion Companion;

    @NotNull
    public final RoutingHttpHandler getTokenRoute() {
        return this.tokenRoute;
    }

    @NotNull
    public final Filter getAuthenticationStart() {
        return this.authenticationStart;
    }

    @NotNull
    public final AuthenticationComplete getAuthenticationComplete() {
        return this.authenticationComplete;
    }

    public OAuthServer(@NotNull String tokenPath, @NotNull AuthRequestTracking authRequestTracking, @NotNull AuthoriseRequestValidator authoriseRequestValidator, @NotNull AccessTokenRequestAuthentication accessTokenRequestAuthentication, @NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull AutoMarshallingJson json, @NotNull Clock clock, @NotNull AuthRequestExtractor authRequestExtractor, @NotNull GrantTypesConfiguration grantTypes, @NotNull IdTokens idTokens, @Nullable String documentationUri) {
        Intrinsics.checkParameterIsNotNull((Object)tokenPath, (String)"tokenPath");
        Intrinsics.checkParameterIsNotNull((Object)authRequestTracking, (String)"authRequestTracking");
        Intrinsics.checkParameterIsNotNull((Object)authoriseRequestValidator, (String)"authoriseRequestValidator");
        Intrinsics.checkParameterIsNotNull((Object)accessTokenRequestAuthentication, (String)"accessTokenRequestAuthentication");
        Intrinsics.checkParameterIsNotNull((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkParameterIsNotNull((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)authRequestExtractor, (String)"authRequestExtractor");
        Intrinsics.checkParameterIsNotNull((Object)grantTypes, (String)"grantTypes");
        Intrinsics.checkParameterIsNotNull((Object)idTokens, (String)"idTokens");
        this.errorRenderer = new JsonResponseErrorRenderer(json, documentationUri);
        this.authoriseRequestErrorRender = new AuthoriseRequestErrorRender(authoriseRequestValidator, this.errorRenderer, documentationUri);
        this.tokenRoute = RoutingKt.routes((RoutingHttpHandler[])new RoutingHttpHandler[]{RoutingKt.bind((String)tokenPath, (Method)Method.POST).to((Function1)new GenerateAccessToken(authorizationCodes, accessTokens, clock, idTokens, this.errorRenderer, grantTypes))});
        this.authenticationStart = Http4kKt.then((Filter)new ClientValidationFilter(authoriseRequestValidator, this.authoriseRequestErrorRender, authRequestExtractor), (Filter)new AuthRequestTrackingFilter(authRequestTracking, authRequestExtractor, this.authoriseRequestErrorRender));
        this.authenticationComplete = new AuthenticationComplete(authorizationCodes, authRequestTracking, idTokens, documentationUri);
    }

    public /* synthetic */ OAuthServer(String string, AuthRequestTracking authRequestTracking, AuthoriseRequestValidator authoriseRequestValidator, AccessTokenRequestAuthentication accessTokenRequestAuthentication, AuthorizationCodes authorizationCodes, AccessTokens accessTokens, AutoMarshallingJson autoMarshallingJson, Clock clock, AuthRequestExtractor authRequestExtractor, GrantTypesConfiguration grantTypesConfiguration, IdTokens idTokens, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            authRequestExtractor = AuthRequestFromQueryParameters.INSTANCE;
        }
        if ((n & 0x200) != 0) {
            grantTypesConfiguration = GrantTypesConfiguration.Companion.default(accessTokenRequestAuthentication);
        }
        if ((n & 0x400) != 0) {
            idTokens = IdTokens.Companion.getUnsupported();
        }
        if ((n & 0x800) != 0) {
            string2 = null;
        }
        this(string, authRequestTracking, authoriseRequestValidator, accessTokenRequestAuthentication, authorizationCodes, accessTokens, autoMarshallingJson, clock, authRequestExtractor, grantTypesConfiguration, idTokens, string2);
    }

    public OAuthServer(@NotNull String tokenPath, @NotNull AuthRequestTracking authRequestTracking, @NotNull ClientValidator clientValidator, @NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull AutoMarshallingJson json, @NotNull Clock clock, @NotNull AuthRequestExtractor authRequestExtractor, @NotNull GrantTypesConfiguration grantTypes, @NotNull IdTokens idTokens, @Nullable String documentationUri) {
        Intrinsics.checkParameterIsNotNull((Object)tokenPath, (String)"tokenPath");
        Intrinsics.checkParameterIsNotNull((Object)authRequestTracking, (String)"authRequestTracking");
        Intrinsics.checkParameterIsNotNull((Object)clientValidator, (String)"clientValidator");
        Intrinsics.checkParameterIsNotNull((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkParameterIsNotNull((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)authRequestExtractor, (String)"authRequestExtractor");
        Intrinsics.checkParameterIsNotNull((Object)grantTypes, (String)"grantTypes");
        Intrinsics.checkParameterIsNotNull((Object)idTokens, (String)"idTokens");
        this(tokenPath, authRequestTracking, new SimpleAuthoriseRequestValidator(clientValidator), new ClientSecretAccessTokenRequestAuthentication(clientValidator), authorizationCodes, accessTokens, json, clock, authRequestExtractor, grantTypes, idTokens, documentationUri);
    }

    public /* synthetic */ OAuthServer(String string, AuthRequestTracking authRequestTracking, ClientValidator clientValidator, AuthorizationCodes authorizationCodes, AccessTokens accessTokens, AutoMarshallingJson autoMarshallingJson, Clock clock, AuthRequestExtractor authRequestExtractor, GrantTypesConfiguration grantTypesConfiguration, IdTokens idTokens, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            authRequestExtractor = AuthRequestFromQueryParameters.INSTANCE;
        }
        if ((n & 0x100) != 0) {
            grantTypesConfiguration = GrantTypesConfiguration.Companion.default(new ClientSecretAccessTokenRequestAuthentication(clientValidator));
        }
        if ((n & 0x200) != 0) {
            idTokens = IdTokens.Companion.getUnsupported();
        }
        if ((n & 0x400) != 0) {
            string2 = null;
        }
        this(string, authRequestTracking, clientValidator, authorizationCodes, accessTokens, autoMarshallingJson, clock, authRequestExtractor, grantTypesConfiguration, idTokens, string2);
    }

    static {
        Companion = new Companion(null);
        clientIdQueryParameter = (BiDiLens)LensSpec.required$default((LensSpec)Query.INSTANCE.map((Function1)Companion.clientIdQueryParameter.1.INSTANCE, (Function1)OAuthServer$Companion$clientIdQueryParameter$2.INSTANCE), (String)"client_id", null, (int)2, null);
        scopesQueryParameter = (BiDiLens)LensSpec.optional$default((LensSpec)Query.INSTANCE.map((Function1)Companion.scopesQueryParameter.1.INSTANCE, (Function1)Companion.scopesQueryParameter.2.INSTANCE), (String)"scope", null, (int)2, null);
        redirectUriQueryParameter = (BiDiLens)LensSpec.required$default((LensSpec)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)Query.INSTANCE)), (String)"redirect_uri", null, (int)2, null);
        state = (BiDiLens)LensSpec.optional$default((LensSpec)Query.INSTANCE, (String)"state", null, (int)2, null);
        responseType = (BiDiLens)LensSpec.required$default((LensSpec)Query.INSTANCE.map((Function1)new Function1<String, ResponseType>(ResponseType.Companion){

            @NotNull
            public final ResponseType invoke(@NotNull String p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((ResponseType.Companion)this.receiver).fromQueryParameterValue(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ResponseType.Companion.class);
            }

            public final String getName() {
                return "fromQueryParameterValue";
            }

            public final String getSignature() {
                return "fromQueryParameterValue(Ljava/lang/String;)Lorg/http4k/security/ResponseType;";
            }
        }, (Function1)OAuthServer$Companion$responseType$2.INSTANCE), (String)"response_type", null, (int)2, null);
        responseMode = (BiDiLens)LensSpec.optional$default((LensSpec)Query.INSTANCE.map((Function1)new Function1<String, ResponseMode>(ResponseMode.Companion){

            @NotNull
            public final ResponseMode invoke(@NotNull String p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((ResponseMode.Companion)this.receiver).fromQueryParameterValue(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ResponseMode.Companion.class);
            }

            public final String getName() {
                return "fromQueryParameterValue";
            }

            public final String getSignature() {
                return "fromQueryParameterValue(Ljava/lang/String;)Lorg/http4k/security/ResponseMode;";
            }
        }, (Function1)OAuthServer$Companion$responseMode$2.INSTANCE), (String)"response_mode", null, (int)2, null);
        nonce = (BiDiLens)LensSpec.optional$default((LensSpec)Query.INSTANCE.map((Function1)Companion.nonce.1.INSTANCE, (Function1)OAuthServer$Companion$nonce$2.INSTANCE), (String)"nonce", null, (int)2, null);
        request = (BiDiLens)LensSpec.optional$default((LensSpec)Query.INSTANCE.map((Function1)Companion.request.1.INSTANCE, (Function1)OAuthServer$Companion$request$2.INSTANCE), (String)"request", null, (int)2, null);
        clientIdForm = (BiDiLens)LensSpec.optional$default((LensSpec)FormField.INSTANCE.map((Function1)Companion.clientIdForm.1.INSTANCE, (Function1)OAuthServer$Companion$clientIdForm$2.INSTANCE), (String)"client_id", null, (int)2, null);
        clientSecret = (BiDiLens)LensSpec.optional$default((LensSpec)FormField.INSTANCE, (String)"client_secret", null, (int)2, null);
        code = (BiDiLens)LensSpec.optional$default((LensSpec)FormField.INSTANCE, (String)"code", null, (int)2, null);
        redirectUriForm = (BiDiLens)LensSpec.optional$default((LensSpec)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)FormField.INSTANCE)), (String)"redirect_uri", null, (int)2, null);
        scopesForm = (BiDiLens)LensSpec.optional$default((LensSpec)FormField.INSTANCE.map((Function1)Companion.scopesForm.1.INSTANCE, (Function1)Companion.scopesForm.2.INSTANCE), (String)"scope", null, (int)2, null);
        clientAssertionType = (BiDiLens)LensSpec.optional$default((LensSpec)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)FormField.INSTANCE)), (String)"client_assertion_type", null, (int)2, null);
        clientAssertion = (BiDiLens)LensSpec.optional$default((LensSpec)FormField.INSTANCE, (String)"client_assertion", null, (int)2, null);
        tokenRequestWebForm = WebFormKt.webForm((Body.Companion)Body.Companion, (Validator)Validator.Strict, (Lens[])new Lens[]{(Lens)clientIdForm, (Lens)clientSecret, (Lens)code, (Lens)redirectUriForm, (Lens)scopesForm, (Lens)clientAssertionType, (Lens)clientAssertion}).toLens();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u001f\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u001f\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR\u001f\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR\u001f\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR\u001f\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\bR\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u001f\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\bR\u001f\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010!0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\bR\u001d\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020$0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\bR%\u0010&\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010'0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\bR%\u0010)\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010'0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\bR\u001f\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\bR\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Lorg/http4k/security/oauth/server/OAuthServer$Companion;", "", "()V", "clientAssertion", "Lorg/http4k/lens/BiDiLens;", "Lorg/http4k/lens/WebForm;", "", "getClientAssertion", "()Lorg/http4k/lens/BiDiLens;", "clientAssertionType", "Lorg/http4k/core/Uri;", "getClientAssertionType", "clientIdForm", "Lorg/http4k/security/oauth/server/ClientId;", "getClientIdForm", "clientIdQueryParameter", "Lorg/http4k/core/Request;", "getClientIdQueryParameter", "clientSecret", "getClientSecret", "code", "getCode", "nonce", "Lorg/http4k/security/openid/Nonce;", "getNonce", "redirectUriForm", "getRedirectUriForm", "redirectUriQueryParameter", "getRedirectUriQueryParameter", "request", "Lorg/http4k/security/openid/RequestJwtContainer;", "getRequest", "responseMode", "Lorg/http4k/security/ResponseMode;", "getResponseMode", "responseType", "Lorg/http4k/security/ResponseType;", "getResponseType", "scopesForm", "", "getScopesForm", "scopesQueryParameter", "getScopesQueryParameter", "state", "getState", "tokenRequestWebForm", "Lorg/http4k/lens/BiDiBodyLens;", "getTokenRequestWebForm", "()Lorg/http4k/lens/BiDiBodyLens;", "http4k-security-oauth"})
    public static final class Companion {
        @NotNull
        public final BiDiLens<Request, ClientId> getClientIdQueryParameter() {
            return clientIdQueryParameter;
        }

        @NotNull
        public final BiDiLens<Request, List<String>> getScopesQueryParameter() {
            return scopesQueryParameter;
        }

        @NotNull
        public final BiDiLens<Request, Uri> getRedirectUriQueryParameter() {
            return redirectUriQueryParameter;
        }

        @NotNull
        public final BiDiLens<Request, String> getState() {
            return state;
        }

        @NotNull
        public final BiDiLens<Request, ResponseType> getResponseType() {
            return responseType;
        }

        @NotNull
        public final BiDiLens<Request, ResponseMode> getResponseMode() {
            return responseMode;
        }

        @NotNull
        public final BiDiLens<Request, Nonce> getNonce() {
            return nonce;
        }

        @NotNull
        public final BiDiLens<Request, RequestJwtContainer> getRequest() {
            return request;
        }

        @NotNull
        public final BiDiLens<WebForm, ClientId> getClientIdForm() {
            return clientIdForm;
        }

        @NotNull
        public final BiDiLens<WebForm, String> getClientSecret() {
            return clientSecret;
        }

        @NotNull
        public final BiDiLens<WebForm, String> getCode() {
            return code;
        }

        @NotNull
        public final BiDiLens<WebForm, Uri> getRedirectUriForm() {
            return redirectUriForm;
        }

        @NotNull
        public final BiDiLens<WebForm, List<String>> getScopesForm() {
            return scopesForm;
        }

        @NotNull
        public final BiDiLens<WebForm, Uri> getClientAssertionType() {
            return clientAssertionType;
        }

        @NotNull
        public final BiDiLens<WebForm, String> getClientAssertion() {
            return clientAssertion;
        }

        @NotNull
        public final BiDiBodyLens<WebForm> getTokenRequestWebForm() {
            return tokenRequestWebForm;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

