/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server.accesstoken;

import com.natpryce.Failure;
import com.natpryce.Result;
import com.natpryce.Success;
import java.time.Clock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.security.AccessToken;
import org.http4k.security.AccessTokenDetails;
import org.http4k.security.oauth.server.AccessTokenError;
import org.http4k.security.oauth.server.AccessTokens;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.oauth.server.AuthorizationCodeAlreadyUsed;
import org.http4k.security.oauth.server.AuthorizationCodeDetails;
import org.http4k.security.oauth.server.AuthorizationCodeExpired;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.ClientIdMismatch;
import org.http4k.security.oauth.server.IdTokens;
import org.http4k.security.oauth.server.MissingAuthorizationCode;
import org.http4k.security.oauth.server.MissingRedirectUri;
import org.http4k.security.oauth.server.RedirectUriMismatch;
import org.http4k.security.oauth.server.TokenRequest;
import org.http4k.security.oauth.server.accesstoken.AccessTokenGenerator;
import org.http4k.security.oauth.server.accesstoken.AuthorizationCodeAccessTokenRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ,\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/http4k/security/oauth/server/accesstoken/AuthorizationCodeAccessTokenGenerator;", "Lorg/http4k/security/oauth/server/accesstoken/AccessTokenGenerator;", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "accessTokens", "Lorg/http4k/security/oauth/server/AccessTokens;", "clock", "Ljava/time/Clock;", "idTokens", "Lorg/http4k/security/oauth/server/IdTokens;", "(Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Ljava/time/Clock;Lorg/http4k/security/oauth/server/IdTokens;)V", "generate", "Lcom/natpryce/Result;", "Lorg/http4k/security/AccessTokenDetails;", "Lorg/http4k/security/oauth/server/AccessTokenError;", "request", "Lorg/http4k/core/Request;", "clientId", "Lorg/http4k/security/oauth/server/ClientId;", "tokenRequest", "Lorg/http4k/security/oauth/server/TokenRequest;", "Lorg/http4k/security/oauth/server/accesstoken/AuthorizationCodeAccessTokenRequest;", "Companion", "http4k-security-oauth"})
public final class AuthorizationCodeAccessTokenGenerator
implements AccessTokenGenerator {
    private final AuthorizationCodes authorizationCodes;
    private final AccessTokens accessTokens;
    private final Clock clock;
    private final IdTokens idTokens;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Result<AccessTokenDetails, AccessTokenError> generate(@NotNull Request request2, @NotNull ClientId clientId2, @NotNull TokenRequest tokenRequest) {
        Object object;
        Result<AuthorizationCodeAccessTokenRequest, AccessTokenError> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)clientId2, (String)"clientId");
        Intrinsics.checkParameterIsNotNull((Object)tokenRequest, (String)"tokenRequest");
        Result<AuthorizationCodeAccessTokenRequest, AccessTokenError> result = $receiver$iv = Companion.extract(clientId2, tokenRequest);
        if (result instanceof Success) {
            AuthorizationCodeAccessTokenRequest it = (AuthorizationCodeAccessTokenRequest)((Success)$receiver$iv).getValue();
            boolean bl = false;
            object = this.generate(it);
        } else if (result instanceof Failure) {
            object = $receiver$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result<AccessTokenDetails, AccessTokenError> generate(@NotNull AuthorizationCodeAccessTokenRequest request2) {
        Result result;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        AuthorizationCode code = request2.getAuthorizationCode();
        AuthorizationCodeDetails codeDetails = this.authorizationCodes.detailsFor(code);
        if (codeDetails.getExpiresAt().isBefore(this.clock.instant())) {
            result = (Result)new Failure((Object)AuthorizationCodeExpired.INSTANCE);
        } else if (Intrinsics.areEqual((Object)codeDetails.getClientId(), (Object)request2.getClientId()) ^ true) {
            result = (Result)new Failure((Object)ClientIdMismatch.INSTANCE);
        } else if (Intrinsics.areEqual((Object)codeDetails.getRedirectUri(), (Object)request2.getRedirectUri()) ^ true) {
            result = (Result)new Failure((Object)RedirectUriMismatch.INSTANCE);
        } else {
            void $receiver$iv;
            Result<AccessToken, AuthorizationCodeAlreadyUsed> result2 = this.accessTokens.create(code);
            void var5_5 = $receiver$iv;
            if (var5_5 instanceof Success) {
                AccessTokenDetails accessTokenDetails;
                AccessToken token = (AccessToken)((Success)$receiver$iv).getValue();
                boolean bl = false;
                AccessTokenDetails accessTokenDetails2 = accessTokenDetails = codeDetails.isOIDC() ? new AccessTokenDetails(token, this.idTokens.createForAccessToken(codeDetails, code, token)) : new AccessTokenDetails(token, null, 2, null);
                result = (Result)new Success((Object)accessTokenDetails2);
            } else if (var5_5 instanceof Failure) {
                result = $receiver$iv;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return result;
    }

    public AuthorizationCodeAccessTokenGenerator(@NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull Clock clock, @NotNull IdTokens idTokens) {
        Intrinsics.checkParameterIsNotNull((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkParameterIsNotNull((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)idTokens, (String)"idTokens");
        this.authorizationCodes = authorizationCodes;
        this.accessTokens = accessTokens;
        this.clock = clock;
        this.idTokens = idTokens;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/http4k/security/oauth/server/accesstoken/AuthorizationCodeAccessTokenGenerator$Companion;", "", "()V", "extract", "Lcom/natpryce/Result;", "Lorg/http4k/security/oauth/server/accesstoken/AuthorizationCodeAccessTokenRequest;", "Lorg/http4k/security/oauth/server/AccessTokenError;", "clientId", "Lorg/http4k/security/oauth/server/ClientId;", "tokenRequest", "Lorg/http4k/security/oauth/server/TokenRequest;", "http4k-security-oauth"})
    public static final class Companion {
        @NotNull
        public final Result<AuthorizationCodeAccessTokenRequest, AccessTokenError> extract(@NotNull ClientId clientId2, @NotNull TokenRequest tokenRequest) {
            Intrinsics.checkParameterIsNotNull((Object)clientId2, (String)"clientId");
            Intrinsics.checkParameterIsNotNull((Object)tokenRequest, (String)"tokenRequest");
            String string = tokenRequest.getClientSecret();
            if (string == null) {
                string = "";
            }
            Uri uri = tokenRequest.getRedirectUri();
            if (uri == null) {
                return (Result)new Failure((Object)MissingRedirectUri.INSTANCE);
            }
            String string2 = tokenRequest.getCode();
            if (string2 == null) {
                return (Result)new Failure((Object)MissingAuthorizationCode.INSTANCE);
            }
            return (Result)new Success((Object)new AuthorizationCodeAccessTokenRequest(clientId2, string, uri, tokenRequest.getScopes(), new AuthorizationCode(string2)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

