/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import com.natpryce.Failure;
import com.natpryce.Result;
import com.natpryce.Success;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.security.ResponseMode;
import org.http4k.security.ResponseType;
import org.http4k.security.State;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthRequestExtractor;
import org.http4k.security.oauth.server.AuthRequestFromQueryParameters;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.InvalidAuthorizationRequest;
import org.http4k.security.oauth.server.InvalidRequestObject;
import org.http4k.security.oauth.server.request.RequestJWTValidator;
import org.http4k.security.oauth.server.request.RequestObject;
import org.http4k.security.oauth.server.request.RequestObjectExtractor;
import org.http4k.security.openid.Nonce;
import org.http4k.security.openid.RequestJwtContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J6\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0004\u0012\u00020\b0\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J5\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0015\u0012\u0004\u0012\u00020\b0\u0006\"\u0004\b\u0000\u0010\u00152\b\u0010\u0012\u001a\u0004\u0018\u0001H\u00152\b\u0010\u0013\u001a\u0004\u0018\u0001H\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor;", "Lorg/http4k/security/oauth/server/AuthRequestExtractor;", "requestJWTValidator", "Lorg/http4k/security/oauth/server/request/RequestJWTValidator;", "(Lorg/http4k/security/oauth/server/request/RequestJWTValidator;)V", "combineAuthRequestAndRequestObject", "Lcom/natpryce/Result;", "Lorg/http4k/security/oauth/server/AuthRequest;", "Lorg/http4k/security/oauth/server/InvalidAuthorizationRequest;", "authRequest", "requestObject", "Lorg/http4k/security/oauth/server/request/RequestObject;", "extract", "request", "Lorg/http4k/core/Request;", "nonEmptyScopeIfExistsOrErrorIfNotEqual", "", "", "authRequestValue", "requestObjectValue", "nonNullValueIfExistsOrErrorIfNotEqual", "T", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/natpryce/Result;", "http4k-security-oauth"})
public final class AuthRequestWithRequestAuthRequestExtractor
implements AuthRequestExtractor {
    private final RequestJWTValidator requestJWTValidator;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Result<AuthRequest, InvalidAuthorizationRequest> extract(@NotNull Request request2) {
        Result<AuthRequest, InvalidAuthorizationRequest> result;
        Result<AuthRequest, InvalidAuthorizationRequest> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Result<AuthRequest, InvalidAuthorizationRequest> result2 = $receiver$iv = AuthRequestFromQueryParameters.INSTANCE.extract(request2);
        if (result2 instanceof Success) {
            AuthRequest authRequest = (AuthRequest)((Success)$receiver$iv).getValue();
            boolean bl = false;
            RequestJwtContainer requestJwtContainer = authRequest.getRequest();
            if (requestJwtContainer != null) {
                InvalidAuthorizationRequest requestJwtValidationError = this.requestJWTValidator.validate(authRequest.getClient(), requestJwtContainer);
                if (requestJwtValidationError != null) {
                    result = (Result)new Failure((Object)requestJwtValidationError);
                    return result;
                } else {
                    Result result3;
                    void $receiver$iv2;
                    Result<RequestObject, InvalidRequestObject> result4 = RequestObjectExtractor.INSTANCE.extractRequestObjectFromJwt$http4k_security_oauth(requestJwtContainer.getValue());
                    void var9_9 = $receiver$iv2;
                    if (var9_9 instanceof Success) {
                        result3 = $receiver$iv2;
                    } else {
                        InvalidAuthorizationRequest invalidAuthorizationRequest;
                        if (!(var9_9 instanceof Failure)) throw new NoWhenBranchMatchedException();
                        InvalidRequestObject it = (InvalidRequestObject)((Failure)$receiver$iv2).getReason();
                        boolean bl2 = false;
                        InvalidAuthorizationRequest invalidAuthorizationRequest2 = invalidAuthorizationRequest = new InvalidAuthorizationRequest("Query 'request' is invalid");
                        result3 = (Result)new Failure((Object)invalidAuthorizationRequest2);
                    }
                    $receiver$iv2 = result3;
                    var9_9 = $receiver$iv2;
                    if (var9_9 instanceof Success) {
                        RequestObject requestObject = (RequestObject)((Success)$receiver$iv2).getValue();
                        boolean bl3 = false;
                        result = this.combineAuthRequestAndRequestObject(authRequest, requestObject);
                        return result;
                    } else {
                        if (!(var9_9 instanceof Failure)) throw new NoWhenBranchMatchedException();
                        result = $receiver$iv2;
                    }
                }
                return result;
            } else {
                result = (Result<AuthRequest, InvalidAuthorizationRequest>)new Success((Object)authRequest);
            }
            return result;
        } else {
            if (!(result2 instanceof Failure)) throw new NoWhenBranchMatchedException();
            result = $receiver$iv;
        }
        return result;
    }

    private final Result<AuthRequest, InvalidAuthorizationRequest> combineAuthRequestAndRequestObject(AuthRequest authRequest, RequestObject requestObject) {
        Object $receiver$iv;
        if (requestObject.getClient() != null && Intrinsics.areEqual((Object)authRequest.getClient(), (Object)requestObject.getClient()) ^ true) {
            return (Result)new Failure((Object)new InvalidAuthorizationRequest("'client_id' is invalid"));
        }
        Result<Uri, InvalidAuthorizationRequest> result = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getRedirectUri(), requestObject.getRedirectUri());
        RequestObject requestObject2 = requestObject;
        ClientId clientId = null;
        AuthRequest authRequest2 = authRequest;
        Object object = $receiver$iv;
        if (!(object instanceof Success)) {
            if (object instanceof Failure) {
                Failure it = (Failure)$receiver$iv;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object2 = ((Success)$receiver$iv).getValue();
        $receiver$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getState(), requestObject.getState());
        object2 = (Uri)object2;
        object = $receiver$iv;
        if (!(object instanceof Success)) {
            if (object instanceof Failure) {
                Failure it = (Failure)$receiver$iv;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object3 = ((Success)$receiver$iv).getValue();
        $receiver$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getNonce(), requestObject.getNonce());
        object3 = (State)object3;
        object = $receiver$iv;
        if (!(object instanceof Success)) {
            if (object instanceof Failure) {
                Failure it = (Failure)$receiver$iv;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object4 = ((Success)$receiver$iv).getValue();
        $receiver$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getResponseType(), requestObject.getResponseType());
        object4 = (Nonce)object4;
        object = $receiver$iv;
        if (!(object instanceof Success)) {
            if (object instanceof Failure) {
                Failure it = (Failure)$receiver$iv;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object5 = ((Success)$receiver$iv).getValue();
        ResponseType responseType2 = (ResponseType)((Object)object5);
        if (responseType2 == null) {
            responseType2 = ResponseType.Code;
        }
        $receiver$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getResponseMode(), requestObject.getResponseMode());
        object5 = responseType2;
        object = $receiver$iv;
        if (!(object instanceof Success)) {
            if (object instanceof Failure) {
                Failure it = (Failure)$receiver$iv;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object6 = ((Success)$receiver$iv).getValue();
        $receiver$iv = this.nonEmptyScopeIfExistsOrErrorIfNotEqual(authRequest.getScopes(), requestObject.scopes());
        RequestJwtContainer requestJwtContainer = null;
        object6 = (ResponseMode)((Object)object6);
        object = $receiver$iv;
        if (!(object instanceof Success)) {
            if (object instanceof Failure) {
                Failure it = (Failure)$receiver$iv;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object7 = ((Success)$receiver$iv).getValue();
        List list = (List)object7;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        result = null;
        object = list;
        RequestJwtContainer requestJwtContainer2 = requestJwtContainer;
        Object object8 = object6;
        Object object9 = object5;
        Object object10 = object4;
        Object object11 = object3;
        Object object12 = object2;
        RequestObject requestObject3 = requestObject2;
        AuthRequest authRequest3 = AuthRequest.copy$default(authRequest2, clientId, object, (Uri)object12, (State)object11, (ResponseType)((Object)object9), (Nonce)object10, (ResponseMode)((Object)object8), requestJwtContainer2, requestObject3, result, 641, null);
        return (Result)new Success((Object)authRequest3);
    }

    private final <T> Result<T, InvalidAuthorizationRequest> nonNullValueIfExistsOrErrorIfNotEqual(T authRequestValue, T requestObjectValue) {
        if (authRequestValue != null && requestObjectValue != null && Intrinsics.areEqual(authRequestValue, requestObjectValue) ^ true) {
            return (Result)new Failure((Object)new InvalidAuthorizationRequest("request object is invalid"));
        }
        T t = authRequestValue;
        if (t == null) {
            t = requestObjectValue;
        }
        return (Result)new Success(t);
    }

    private final Result<List<String>, InvalidAuthorizationRequest> nonEmptyScopeIfExistsOrErrorIfNotEqual(List<String> authRequestValue, List<String> requestObjectValue) {
        Collection collection = authRequestValue;
        boolean bl = false;
        if (!collection.isEmpty()) {
            collection = requestObjectValue;
            bl = false;
            if (!collection.isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)authRequestValue), (Object)CollectionsKt.toSet((Iterable)requestObjectValue)) ^ true) {
                return (Result)new Failure((Object)new InvalidAuthorizationRequest("request object is invalid"));
            }
        }
        collection = authRequestValue;
        bl = false;
        boolean bl2 = !collection.isEmpty();
        List<String> list = bl2 ? authRequestValue : requestObjectValue;
        return (Result)new Success(list);
    }

    public AuthRequestWithRequestAuthRequestExtractor(@NotNull RequestJWTValidator requestJWTValidator) {
        Intrinsics.checkParameterIsNotNull((Object)requestJWTValidator, (String)"requestJWTValidator");
        this.requestJWTValidator = requestJWTValidator;
    }
}

