/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.natpryce.Failure;
import com.natpryce.Result;
import com.natpryce.Success;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.http4k.core.Uri;
import org.http4k.format.ConfigurableJackson;
import org.http4k.format.ConfigurableJacksonKt;
import org.http4k.lens.BiDiMapping;
import org.http4k.security.ResponseMode;
import org.http4k.security.ResponseType;
import org.http4k.security.State;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.InvalidRequestObject;
import org.http4k.security.oauth.server.request.RequestObject;
import org.http4k.security.openid.Nonce;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ!\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\fJ4\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u00060\u0004\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/http4k/security/oauth/server/request/RequestObjectExtractor;", "", "()V", "extractRequestJwtClaimsAsMap", "Lcom/natpryce/Result;", "", "Lorg/http4k/security/oauth/server/InvalidRequestObject;", "value", "", "extractRequestJwtClaimsAsMap$http4k_security_oauth", "extractRequestObjectFromJwt", "Lorg/http4k/security/oauth/server/request/RequestObject;", "extractRequestObjectFromJwt$http4k_security_oauth", "parseJsonFromJWT", "T", "target", "Lkotlin/reflect/KClass;", "RequestObjectExtractorJson", "http4k-security-oauth"})
public final class RequestObjectExtractor {
    public static final RequestObjectExtractor INSTANCE;

    @NotNull
    public final Result<Map<?, ?>, InvalidRequestObject> extractRequestJwtClaimsAsMap$http4k_security_oauth(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.parseJsonFromJWT(value, Reflection.getOrCreateKotlinClass(Map.class));
    }

    @NotNull
    public final Result<RequestObject, InvalidRequestObject> extractRequestObjectFromJwt$http4k_security_oauth(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.parseJsonFromJWT(value, Reflection.getOrCreateKotlinClass(RequestObject.class));
    }

    private final <T> Result<T, InvalidRequestObject> parseJsonFromJWT(String value, KClass<T> target) {
        try {
            List jwtParts = StringsKt.split$default((CharSequence)value, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            if (jwtParts.size() != 3) {
                return (Result)new Failure((Object)InvalidRequestObject.INSTANCE);
            }
            byte[] byArray = Base64.getUrlDecoder().decode((String)jwtParts.get(1));
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getUrlDecoder().decode(jwtParts[1])");
            byte[] byArray2 = byArray;
            RequestObjectExtractorJson requestObjectExtractorJson = RequestObjectExtractorJson.INSTANCE;
            boolean bl = false;
            String string = new String(byArray2, Charsets.UTF_8);
            Object object = requestObjectExtractorJson.asA(string, target);
            return (Result)new Success(object);
        }
        catch (IllegalArgumentException e) {
            return (Result)new Failure((Object)InvalidRequestObject.INSTANCE);
        }
        catch (JsonParseException e) {
            return (Result)new Failure((Object)InvalidRequestObject.INSTANCE);
        }
    }

    private RequestObjectExtractor() {
    }

    static {
        RequestObjectExtractor requestObjectExtractor;
        INSTANCE = requestObjectExtractor = new RequestObjectExtractor();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/http4k/security/oauth/server/request/RequestObjectExtractor$RequestObjectExtractorJson;", "Lorg/http4k/format/ConfigurableJackson;", "()V", "http4k-security-oauth"})
    public static final class RequestObjectExtractorJson
    extends ConfigurableJackson {
        public static final RequestObjectExtractorJson INSTANCE;

        private RequestObjectExtractorJson() {
            ObjectMapper objectMapper = ((ObjectMapper)ConfigurableJacksonKt.asConfigurable((KotlinModule)new KotlinModule(0, false, false, false, 15, null)).text(new BiDiMapping(ResponseMode.class, (Function1)1.INSTANCE, (Function1)2.INSTANCE)).text(new BiDiMapping(ResponseType.class, (Function1)3.INSTANCE, (Function1)4.INSTANCE)).text(new BiDiMapping(ClientId.class, (Function1)5.INSTANCE, (Function1)6.INSTANCE)).text(new BiDiMapping(Uri.class, (Function1)7.INSTANCE, (Function1)8.INSTANCE)).text(new BiDiMapping(State.class, (Function1)9.INSTANCE, (Function1)10.INSTANCE)).text(new BiDiMapping(Nonce.class, (Function1)11.INSTANCE, (Function1)12.INSTANCE)).done()).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).configure(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS, true).configure(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"KotlinModule()\n         \u2026_TYPE_ID_PROPERTY, false)");
            super(objectMapper);
        }

        static {
            RequestObjectExtractorJson requestObjectExtractorJson;
            INSTANCE = requestObjectExtractorJson = new RequestObjectExtractorJson();
        }
    }
}

