/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import com.natpryce.Failure;
import com.natpryce.Result;
import com.natpryce.Success;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.security.ResponseMode;
import org.http4k.security.ResponseType;
import org.http4k.security.State;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthRequestExtractor;
import org.http4k.security.oauth.server.AuthRequestFromQueryParameters;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.InvalidAuthorizationRequest;
import org.http4k.security.oauth.server.InvalidRequestObject;
import org.http4k.security.oauth.server.request.RequestJWTValidator;
import org.http4k.security.oauth.server.request.RequestObject;
import org.http4k.security.oauth.server.request.RequestObjectExtractor;
import org.http4k.security.openid.Nonce;
import org.http4k.security.openid.RequestJwtContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J6\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J5\u0010\u0016\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0017\u0012\u0004\u0012\u00020\n0\b\"\u0004\b\u0000\u0010\u00172\b\u0010\u0014\u001a\u0004\u0018\u0001H\u00172\b\u0010\u0015\u001a\u0004\u0018\u0001H\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor;", "Lorg/http4k/security/oauth/server/AuthRequestExtractor;", "requestJWTValidator", "Lorg/http4k/security/oauth/server/request/RequestJWTValidator;", "combineAuthRequestRequestStrategy", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "(Lorg/http4k/security/oauth/server/request/RequestJWTValidator;Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;)V", "combineAuthRequestAndRequestObject", "Lcom/natpryce/Result;", "Lorg/http4k/security/oauth/server/AuthRequest;", "Lorg/http4k/security/oauth/server/InvalidAuthorizationRequest;", "authRequest", "requestObject", "Lorg/http4k/security/oauth/server/request/RequestObject;", "extract", "request", "Lorg/http4k/core/Request;", "nonEmptyScopeIfExistsOrErrorIfNotEqual", "", "", "authRequestValue", "requestObjectValue", "nonNullValueIfExistsOrErrorIfNotEqual", "T", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/natpryce/Result;", "CombineAuthRequestRequestStrategy", "http4k-security-oauth"})
public final class AuthRequestWithRequestAuthRequestExtractor
implements AuthRequestExtractor {
    private final RequestJWTValidator requestJWTValidator;
    private final CombineAuthRequestRequestStrategy combineAuthRequestRequestStrategy;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Result<AuthRequest, InvalidAuthorizationRequest> extract(@NotNull Request request2) {
        Result<AuthRequest, InvalidAuthorizationRequest> result;
        Result<AuthRequest, InvalidAuthorizationRequest> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Result<AuthRequest, InvalidAuthorizationRequest> result2 = $receiver$iv = AuthRequestFromQueryParameters.INSTANCE.extract(request2);
        if (result2 instanceof Success) {
            AuthRequest authRequest = (AuthRequest)((Success)$receiver$iv).getValue();
            boolean bl = false;
            RequestJwtContainer requestJwtContainer = authRequest.getRequest();
            if (requestJwtContainer != null) {
                InvalidAuthorizationRequest requestJwtValidationError = this.requestJWTValidator.validate(authRequest.getClient(), requestJwtContainer);
                if (requestJwtValidationError != null) {
                    result = (Result)new Failure((Object)requestJwtValidationError);
                    return result;
                } else {
                    Result result3;
                    void $receiver$iv2;
                    Result<RequestObject, InvalidRequestObject> result4 = RequestObjectExtractor.INSTANCE.extractRequestObjectFromJwt$http4k_security_oauth(requestJwtContainer.getValue());
                    void var9_9 = $receiver$iv2;
                    if (var9_9 instanceof Success) {
                        result3 = $receiver$iv2;
                    } else {
                        InvalidAuthorizationRequest invalidAuthorizationRequest;
                        if (!(var9_9 instanceof Failure)) throw new NoWhenBranchMatchedException();
                        InvalidRequestObject it = (InvalidRequestObject)((Failure)$receiver$iv2).getReason();
                        boolean bl2 = false;
                        InvalidAuthorizationRequest invalidAuthorizationRequest2 = invalidAuthorizationRequest = new InvalidAuthorizationRequest("Query 'request' is invalid");
                        result3 = (Result)new Failure((Object)invalidAuthorizationRequest2);
                    }
                    $receiver$iv2 = result3;
                    var9_9 = $receiver$iv2;
                    if (var9_9 instanceof Success) {
                        RequestObject requestObject = (RequestObject)((Success)$receiver$iv2).getValue();
                        boolean bl3 = false;
                        result = this.combineAuthRequestAndRequestObject(authRequest, requestObject);
                        return result;
                    } else {
                        if (!(var9_9 instanceof Failure)) throw new NoWhenBranchMatchedException();
                        result = $receiver$iv2;
                    }
                }
                return result;
            } else {
                result = (Result<AuthRequest, InvalidAuthorizationRequest>)new Success((Object)authRequest);
            }
            return result;
        } else {
            if (!(result2 instanceof Failure)) throw new NoWhenBranchMatchedException();
            result = $receiver$iv;
        }
        return result;
    }

    private final Result<AuthRequest, InvalidAuthorizationRequest> combineAuthRequestAndRequestObject(AuthRequest authRequest, RequestObject requestObject) {
        Object $receiver$iv;
        if (requestObject.getClient() != null && Intrinsics.areEqual((Object)authRequest.getClient(), (Object)requestObject.getClient()) ^ true) {
            return (Result)new Failure((Object)new InvalidAuthorizationRequest("'client_id' is invalid"));
        }
        Result<Uri, InvalidAuthorizationRequest> result = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getRedirectUri(), requestObject.getRedirectUri());
        RequestObject requestObject2 = requestObject;
        ClientId clientId = null;
        AuthRequest authRequest2 = authRequest;
        Object object = $receiver$iv;
        if (!(object instanceof Success)) {
            if (object instanceof Failure) {
                Failure it = (Failure)$receiver$iv;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object2 = ((Success)$receiver$iv).getValue();
        $receiver$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getState(), requestObject.getState());
        object2 = (Uri)object2;
        object = $receiver$iv;
        if (!(object instanceof Success)) {
            if (object instanceof Failure) {
                Failure it = (Failure)$receiver$iv;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object3 = ((Success)$receiver$iv).getValue();
        $receiver$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getNonce(), requestObject.getNonce());
        object3 = (State)object3;
        object = $receiver$iv;
        if (!(object instanceof Success)) {
            if (object instanceof Failure) {
                Failure it = (Failure)$receiver$iv;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object4 = ((Success)$receiver$iv).getValue();
        $receiver$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getResponseType(), requestObject.getResponseType());
        object4 = (Nonce)object4;
        object = $receiver$iv;
        if (!(object instanceof Success)) {
            if (object instanceof Failure) {
                Failure it = (Failure)$receiver$iv;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object5 = ((Success)$receiver$iv).getValue();
        ResponseType responseType2 = (ResponseType)((Object)object5);
        if (responseType2 == null) {
            responseType2 = ResponseType.Code;
        }
        $receiver$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getResponseMode(), requestObject.getResponseMode());
        object5 = responseType2;
        object = $receiver$iv;
        if (!(object instanceof Success)) {
            if (object instanceof Failure) {
                Failure it = (Failure)$receiver$iv;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object6 = ((Success)$receiver$iv).getValue();
        $receiver$iv = this.nonEmptyScopeIfExistsOrErrorIfNotEqual(authRequest.getScopes(), requestObject.getScope());
        RequestJwtContainer requestJwtContainer = null;
        object6 = (ResponseMode)((Object)object6);
        object = $receiver$iv;
        if (!(object instanceof Success)) {
            if (object instanceof Failure) {
                Failure it = (Failure)$receiver$iv;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object7 = ((Success)$receiver$iv).getValue();
        result = null;
        object = (List)object7;
        RequestJwtContainer requestJwtContainer2 = requestJwtContainer;
        Object object8 = object6;
        Object object9 = object5;
        Object object10 = object4;
        Object object11 = object3;
        Object object12 = object2;
        RequestObject requestObject3 = requestObject2;
        AuthRequest authRequest3 = AuthRequest.copy$default(authRequest2, clientId, object, (Uri)object12, (State)object11, (ResponseType)((Object)object9), (Nonce)object10, (ResponseMode)((Object)object8), requestJwtContainer2, requestObject3, result, 641, null);
        return (Result)new Success((Object)authRequest3);
    }

    private final <T> Result<T, InvalidAuthorizationRequest> nonNullValueIfExistsOrErrorIfNotEqual(T authRequestValue, T requestObjectValue) {
        if (authRequestValue != null && requestObjectValue != null && Intrinsics.areEqual(authRequestValue, requestObjectValue) ^ true) {
            return (Result)new Failure((Object)new InvalidAuthorizationRequest("request object is invalid"));
        }
        return (Result)new Success(this.combineAuthRequestRequestStrategy.combine(authRequestValue, requestObjectValue));
    }

    private final Result<List<String>, InvalidAuthorizationRequest> nonEmptyScopeIfExistsOrErrorIfNotEqual(List<String> authRequestValue, List<String> requestObjectValue) {
        Collection collection = authRequestValue;
        boolean bl = false;
        if (!collection.isEmpty()) {
            collection = requestObjectValue;
            bl = false;
            if (!collection.isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)authRequestValue), (Object)CollectionsKt.toSet((Iterable)requestObjectValue)) ^ true) {
                return (Result)new Failure((Object)new InvalidAuthorizationRequest("request object is invalid"));
            }
        }
        return (Result)new Success(this.combineAuthRequestRequestStrategy.combine(authRequestValue, requestObjectValue));
    }

    public AuthRequestWithRequestAuthRequestExtractor(@NotNull RequestJWTValidator requestJWTValidator, @NotNull CombineAuthRequestRequestStrategy combineAuthRequestRequestStrategy) {
        Intrinsics.checkParameterIsNotNull((Object)requestJWTValidator, (String)"requestJWTValidator");
        Intrinsics.checkParameterIsNotNull((Object)combineAuthRequestRequestStrategy, (String)"combineAuthRequestRequestStrategy");
        this.requestJWTValidator = requestJWTValidator;
        this.combineAuthRequestRequestStrategy = combineAuthRequestRequestStrategy;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00042\b\u0010\u0006\u001a\u0004\u0018\u0001H\u0004H&\u00a2\u0006\u0002\u0010\u0007J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00040\b\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH&\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "", "()V", "combine", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "AuthRequestOnly", "Combine", "RequestObjectOnly", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$Combine;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$AuthRequestOnly;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$RequestObjectOnly;", "http4k-security-oauth"})
    public static abstract class CombineAuthRequestRequestStrategy {
        @Nullable
        public abstract <T> T combine(@Nullable T var1, @Nullable T var2);

        @NotNull
        public abstract <T> List<T> combine(@NotNull List<? extends T> var1, @NotNull List<? extends T> var2);

        private CombineAuthRequestRequestStrategy() {
        }

        public /* synthetic */ CombineAuthRequestRequestStrategy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00042\b\u0010\u0006\u001a\u0004\u0018\u0001H\u0004H\u0016\u00a2\u0006\u0002\u0010\u0007J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00040\b\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$Combine;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "()V", "combine", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "http4k-security-oauth"})
        public static final class Combine
        extends CombineAuthRequestRequestStrategy {
            public static final Combine INSTANCE;

            @Override
            @Nullable
            public <T> T combine(@Nullable T authRequestValue, @Nullable T requestObjectValue) {
                T t = authRequestValue;
                if (t == null) {
                    t = requestObjectValue;
                }
                return t;
            }

            @Override
            @NotNull
            public <T> List<T> combine(@NotNull List<? extends T> authRequestValue, @NotNull List<? extends T> requestObjectValue) {
                Intrinsics.checkParameterIsNotNull(authRequestValue, (String)"authRequestValue");
                Intrinsics.checkParameterIsNotNull(requestObjectValue, (String)"requestObjectValue");
                Collection collection = authRequestValue;
                boolean bl = false;
                return !collection.isEmpty() ? authRequestValue : requestObjectValue;
            }

            private Combine() {
                super(null);
            }

            static {
                Combine combine;
                INSTANCE = combine = new Combine();
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00042\b\u0010\u0006\u001a\u0004\u0018\u0001H\u0004H\u0016\u00a2\u0006\u0002\u0010\u0007J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00040\b\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$AuthRequestOnly;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "()V", "combine", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "http4k-security-oauth"})
        public static final class AuthRequestOnly
        extends CombineAuthRequestRequestStrategy {
            public static final AuthRequestOnly INSTANCE;

            @Override
            @Nullable
            public <T> T combine(@Nullable T authRequestValue, @Nullable T requestObjectValue) {
                return authRequestValue;
            }

            @Override
            @NotNull
            public <T> List<T> combine(@NotNull List<? extends T> authRequestValue, @NotNull List<? extends T> requestObjectValue) {
                Intrinsics.checkParameterIsNotNull(authRequestValue, (String)"authRequestValue");
                Intrinsics.checkParameterIsNotNull(requestObjectValue, (String)"requestObjectValue");
                return authRequestValue;
            }

            private AuthRequestOnly() {
                super(null);
            }

            static {
                AuthRequestOnly authRequestOnly;
                INSTANCE = authRequestOnly = new AuthRequestOnly();
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00042\b\u0010\u0006\u001a\u0004\u0018\u0001H\u0004H\u0016\u00a2\u0006\u0002\u0010\u0007J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00040\b\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$RequestObjectOnly;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "()V", "combine", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "http4k-security-oauth"})
        public static final class RequestObjectOnly
        extends CombineAuthRequestRequestStrategy {
            public static final RequestObjectOnly INSTANCE;

            @Override
            @Nullable
            public <T> T combine(@Nullable T authRequestValue, @Nullable T requestObjectValue) {
                return requestObjectValue;
            }

            @Override
            @NotNull
            public <T> List<T> combine(@NotNull List<? extends T> authRequestValue, @NotNull List<? extends T> requestObjectValue) {
                Intrinsics.checkParameterIsNotNull(authRequestValue, (String)"authRequestValue");
                Intrinsics.checkParameterIsNotNull(requestObjectValue, (String)"requestObjectValue");
                return requestObjectValue;
            }

            private RequestObjectOnly() {
                super(null);
            }

            static {
                RequestObjectOnly requestObjectOnly;
                INSTANCE = requestObjectOnly = new RequestObjectOnly();
            }
        }
    }
}

