/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security;

import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.cookie.Cookie;
import org.http4k.core.cookie.CookieExtensionsKt;
import org.http4k.security.AccessToken;
import org.http4k.security.CrossSiteRequestForgeryToken;
import org.http4k.security.OAuthPersistence;
import org.http4k.security.openid.Nonce;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/http4k/security/InsecureCookieBasedOAuthPersistence;", "Lorg/http4k/security/OAuthPersistence;", "cookieNamePrefix", "", "cookieValidity", "Ljava/time/Duration;", "clock", "Ljava/time/Clock;", "(Ljava/lang/String;Ljava/time/Duration;Ljava/time/Clock;)V", "accessTokenCookieName", "csrfName", "nonceName", "assignCsrf", "Lorg/http4k/core/Response;", "redirect", "csrf", "Lorg/http4k/security/CrossSiteRequestForgeryToken;", "assignNonce", "nonce", "Lorg/http4k/security/openid/Nonce;", "assignToken", "request", "Lorg/http4k/core/Request;", "accessToken", "Lorg/http4k/security/AccessToken;", "authFailureResponse", "expiring", "Lorg/http4k/core/cookie/Cookie;", "name", "value", "retrieveCsrf", "retrieveNonce", "retrieveToken", "http4k-security-oauth"})
public final class InsecureCookieBasedOAuthPersistence
implements OAuthPersistence {
    private final String csrfName;
    private final String nonceName;
    private final String accessTokenCookieName;
    private final Duration cookieValidity;
    private final Clock clock;

    @Override
    @Nullable
    public CrossSiteRequestForgeryToken retrieveCsrf(@NotNull Request request2) {
        CrossSiteRequestForgeryToken crossSiteRequestForgeryToken;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request2, (String)this.csrfName);
        if (object != null && (object = object.getValue()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object p1 = object2;
            boolean bl3 = false;
            crossSiteRequestForgeryToken = new CrossSiteRequestForgeryToken((String)p1);
        } else {
            crossSiteRequestForgeryToken = null;
        }
        return crossSiteRequestForgeryToken;
    }

    @Override
    @Nullable
    public AccessToken retrieveToken(@NotNull Request request2) {
        AccessToken accessToken;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request2, (String)this.accessTokenCookieName);
        if (object != null && (object = object.getValue()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            accessToken = new AccessToken((String)it, null, null, null, null, 30, null);
        } else {
            accessToken = null;
        }
        return accessToken;
    }

    @Override
    @Nullable
    public Nonce retrieveNonce(@NotNull Request request2) {
        Nonce nonce2;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request2, (String)this.nonceName);
        if (object != null && (object = object.getValue()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            nonce2 = new Nonce((String)it);
        } else {
            nonce2 = null;
        }
        return nonce2;
    }

    @Override
    @NotNull
    public Response assignCsrf(@NotNull Response redirect, @NotNull CrossSiteRequestForgeryToken csrf) {
        Intrinsics.checkParameterIsNotNull((Object)redirect, (String)"redirect");
        Intrinsics.checkParameterIsNotNull((Object)csrf, (String)"csrf");
        return CookieExtensionsKt.cookie((Response)redirect, (Cookie)this.expiring(this.csrfName, csrf.getValue()));
    }

    @Override
    @NotNull
    public Response assignToken(@NotNull Request request2, @NotNull Response redirect, @NotNull AccessToken accessToken) {
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)redirect, (String)"redirect");
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        return CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.cookie((Response)redirect, (Cookie)this.expiring(this.accessTokenCookieName, accessToken.getValue())), (String)this.csrfName, null, (int)2, null), (String)this.nonceName, null, (int)2, null);
    }

    @Override
    @NotNull
    public Response assignNonce(@NotNull Response redirect, @NotNull Nonce nonce2) {
        Intrinsics.checkParameterIsNotNull((Object)redirect, (String)"redirect");
        Intrinsics.checkParameterIsNotNull((Object)nonce2, (String)"nonce");
        return CookieExtensionsKt.cookie((Response)redirect, (Cookie)this.expiring(this.nonceName, nonce2.getValue()));
    }

    @Override
    @NotNull
    public Response authFailureResponse() {
        return CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)Status.Companion.getFORBIDDEN(), null, (int)2, null), (String)this.csrfName, null, (int)2, null), (String)this.accessTokenCookieName, null, (int)2, null), (String)this.nonceName, null, (int)2, null);
    }

    private final Cookie expiring(String name, String value) {
        return new Cookie(name, value, null, LocalDateTime.ofInstant(this.clock.instant().plus(this.cookieValidity), this.clock.getZone()), null, "/", false, false, null, 468, null);
    }

    public InsecureCookieBasedOAuthPersistence(@NotNull String cookieNamePrefix, @NotNull Duration cookieValidity, @NotNull Clock clock) {
        Intrinsics.checkParameterIsNotNull((Object)cookieNamePrefix, (String)"cookieNamePrefix");
        Intrinsics.checkParameterIsNotNull((Object)cookieValidity, (String)"cookieValidity");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        this.cookieValidity = cookieValidity;
        this.clock = clock;
        this.csrfName = cookieNamePrefix + "Csrf";
        this.nonceName = cookieNamePrefix + "Nonce";
        this.accessTokenCookieName = cookieNamePrefix + "AccessToken";
    }

    public /* synthetic */ InsecureCookieBasedOAuthPersistence(String string, Duration duration, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofHours(3L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofHours(3)");
            duration = duration2;
        }
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemDefaultZone();
            Intrinsics.checkExpressionValueIsNotNull((Object)clock2, (String)"Clock.systemDefaultZone()");
            clock = clock2;
        }
        this(string, duration, clock);
    }
}

