/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.http4k.core.Uri;
import org.http4k.format.ConfigurableJackson;
import org.http4k.format.ConfigurableJacksonKt;
import org.http4k.lens.BiDiMapping;
import org.http4k.security.ResponseMode;
import org.http4k.security.ResponseType;
import org.http4k.security.State;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.InvalidRequestObject;
import org.http4k.security.oauth.server.request.Claims;
import org.http4k.security.oauth.server.request.RequestObject;
import org.http4k.security.openid.Nonce;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ!\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\fJ4\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u00060\u0004\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/http4k/security/oauth/server/request/RequestObjectExtractor;", "", "()V", "extractRequestJwtClaimsAsMap", "Ldev/forkhandles/result4k/Result;", "", "Lorg/http4k/security/oauth/server/InvalidRequestObject;", "value", "", "extractRequestJwtClaimsAsMap$http4k_security_oauth", "extractRequestObjectFromJwt", "Lorg/http4k/security/oauth/server/request/RequestObject;", "extractRequestObjectFromJwt$http4k_security_oauth", "parseJsonFromJWT", "T", "target", "Lkotlin/reflect/KClass;", "toAudience", "", "jsonValue", "Lcom/fasterxml/jackson/databind/JsonNode;", "RequestObjectExtractorJson", "RequestObjectJson", "http4k-security-oauth"})
public final class RequestObjectExtractor {
    public static final RequestObjectExtractor INSTANCE;

    @NotNull
    public final Result<Map<?, ?>, InvalidRequestObject> extractRequestJwtClaimsAsMap$http4k_security_oauth(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.parseJsonFromJWT(value, Reflection.getOrCreateKotlinClass(Map.class));
    }

    @NotNull
    public final Result<RequestObject, InvalidRequestObject> extractRequestObjectFromJwt$http4k_security_oauth(@NotNull String value) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Result $this$map$iv = this.parseJsonFromJWT(value, Reflection.getOrCreateKotlinClass(RequestObjectJson.class));
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = $this$map$iv;
        boolean $i$f$flatMap = false;
        Result result2 = $this$flatMap$iv$iv;
        if (result2 instanceof Success) {
            RequestObject requestObject;
            Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            RequestObjectJson jsonFromJWT = (RequestObjectJson)value$iv;
            boolean bl2 = false;
            ClientId clientId = jsonFromJWT.getClient();
            Uri uri = jsonFromJWT.getRedirectUri();
            List<String> list = INSTANCE.toAudience(jsonFromJWT.getAudience());
            String string = jsonFromJWT.getIssuer();
            Object object = jsonFromJWT.getScope();
            if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)) == null) {
                object = CollectionsKt.emptyList();
            }
            RequestObject requestObject2 = requestObject = new RequestObject(clientId, uri, list, string, (List<String>)object, jsonFromJWT.getResponseMode(), jsonFromJWT.getResponseType(), jsonFromJWT.getState(), jsonFromJWT.getNonce(), jsonFromJWT.getMagAge(), jsonFromJWT.getExpiry(), jsonFromJWT.getClaims());
            result = (Result)new Success((Object)requestObject2);
        } else if (result2 instanceof Failure) {
            result = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> toAudience(JsonNode jsonValue) {
        List list;
        JsonNode jsonNode = jsonValue;
        if (jsonNode instanceof ArrayNode) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)jsonValue;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.textValue();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            list = jsonNode instanceof TextNode ? CollectionsKt.listOf((Object)jsonValue.textValue()) : CollectionsKt.emptyList();
        }
        return list;
    }

    private final <T> Result<T, InvalidRequestObject> parseJsonFromJWT(String value, KClass<T> target) {
        try {
            List jwtParts = StringsKt.split$default((CharSequence)value, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            if (jwtParts.size() != 3) {
                return (Result)new Failure((Object)InvalidRequestObject.INSTANCE);
            }
            byte[] byArray = Base64.getUrlDecoder().decode((String)jwtParts.get(1));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.getUrlDecoder().decode(jwtParts[1])");
            byte[] byArray2 = byArray;
            boolean bl = false;
            return (Result)new Success(RequestObjectExtractorJson.INSTANCE.asA(new String(byArray2, Charsets.UTF_8), target));
        }
        catch (IllegalArgumentException e) {
            return (Result)new Failure((Object)InvalidRequestObject.INSTANCE);
        }
        catch (JsonParseException e) {
            return (Result)new Failure((Object)InvalidRequestObject.INSTANCE);
        }
    }

    private RequestObjectExtractor() {
    }

    static {
        RequestObjectExtractor requestObjectExtractor;
        INSTANCE = requestObjectExtractor = new RequestObjectExtractor();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/http4k/security/oauth/server/request/RequestObjectExtractor$RequestObjectExtractorJson;", "Lorg/http4k/format/ConfigurableJackson;", "()V", "http4k-security-oauth"})
    public static final class RequestObjectExtractorJson
    extends ConfigurableJackson {
        public static final RequestObjectExtractorJson INSTANCE;

        private RequestObjectExtractorJson() {
            ObjectMapper objectMapper = ((ObjectMapper)ConfigurableJacksonKt.asConfigurable((KotlinModule)new KotlinModule(0, false, false, false, null, 31, null)).text(new BiDiMapping(ResponseMode.class, (Function1)1.INSTANCE, (Function1)2.INSTANCE)).text(new BiDiMapping(ResponseType.class, (Function1)3.INSTANCE, (Function1)4.INSTANCE)).text(new BiDiMapping(ClientId.class, (Function1)5.INSTANCE, (Function1)6.INSTANCE)).text(new BiDiMapping(Uri.class, (Function1)7.INSTANCE, (Function1)8.INSTANCE)).text(new BiDiMapping(State.class, (Function1)9.INSTANCE, (Function1)10.INSTANCE)).text(new BiDiMapping(Nonce.class, (Function1)11.INSTANCE, (Function1)12.INSTANCE)).done()).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).configure(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS, true).configure(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY, false);
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"KotlinModule()\n         \u2026_TYPE_ID_PROPERTY, false)");
            super(objectMapper);
        }

        static {
            RequestObjectExtractorJson requestObjectExtractorJson;
            INSTANCE = requestObjectExtractorJson = new RequestObjectExtractorJson();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0091\u0001\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\t\u0012\n\b\u0003\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0003\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0003\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0003\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\n\b\u0003\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\n\b\u0003\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u0012\b\b\u0003\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u000b\u00100\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u00101\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003\u00a2\u0006\u0002\u0010 J\u0010\u00102\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003\u00a2\u0006\u0002\u0010 J\t\u00103\u001a\u00020\u0017H\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u00105\u001a\u00020\u0007H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u00107\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010:\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\u009a\u0001\u0010<\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0003\u0010\u0006\u001a\u00020\u00072\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0003\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0003\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0003\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0003\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0003\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0003\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\b\u0003\u0010\u0016\u001a\u00020\u0017H\u00c6\u0001\u00a2\u0006\u0002\u0010=J\u0013\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010A\u001a\u00020BH\u00d6\u0001J\t\u0010C\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b$\u0010 R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010#R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006D"}, d2={"Lorg/http4k/security/oauth/server/request/RequestObjectExtractor$RequestObjectJson;", "", "client", "Lorg/http4k/security/oauth/server/ClientId;", "redirectUri", "Lorg/http4k/core/Uri;", "audience", "Lcom/fasterxml/jackson/databind/JsonNode;", "issuer", "", "scope", "responseMode", "Lorg/http4k/security/ResponseMode;", "responseType", "Lorg/http4k/security/ResponseType;", "state", "Lorg/http4k/security/State;", "nonce", "Lorg/http4k/security/openid/Nonce;", "magAge", "", "expiry", "claims", "Lorg/http4k/security/oauth/server/request/Claims;", "(Lorg/http4k/security/oauth/server/ClientId;Lorg/http4k/core/Uri;Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/String;Ljava/lang/String;Lorg/http4k/security/ResponseMode;Lorg/http4k/security/ResponseType;Lorg/http4k/security/State;Lorg/http4k/security/openid/Nonce;Ljava/lang/Long;Ljava/lang/Long;Lorg/http4k/security/oauth/server/request/Claims;)V", "getAudience", "()Lcom/fasterxml/jackson/databind/JsonNode;", "getClaims", "()Lorg/http4k/security/oauth/server/request/Claims;", "getClient", "()Lorg/http4k/security/oauth/server/ClientId;", "getExpiry", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getIssuer", "()Ljava/lang/String;", "getMagAge", "getNonce", "()Lorg/http4k/security/openid/Nonce;", "getRedirectUri", "()Lorg/http4k/core/Uri;", "getResponseMode", "()Lorg/http4k/security/ResponseMode;", "getResponseType", "()Lorg/http4k/security/ResponseType;", "getScope", "getState", "()Lorg/http4k/security/State;", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Lorg/http4k/security/oauth/server/ClientId;Lorg/http4k/core/Uri;Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/String;Ljava/lang/String;Lorg/http4k/security/ResponseMode;Lorg/http4k/security/ResponseType;Lorg/http4k/security/State;Lorg/http4k/security/openid/Nonce;Ljava/lang/Long;Ljava/lang/Long;Lorg/http4k/security/oauth/server/request/Claims;)Lorg/http4k/security/oauth/server/request/RequestObjectExtractor$RequestObjectJson;", "equals", "", "other", "hashCode", "", "toString", "http4k-security-oauth"})
    public static final class RequestObjectJson {
        @Nullable
        private final ClientId client;
        @Nullable
        private final Uri redirectUri;
        @NotNull
        private final JsonNode audience;
        @Nullable
        private final String issuer;
        @Nullable
        private final String scope;
        @Nullable
        private final ResponseMode responseMode;
        @Nullable
        private final ResponseType responseType;
        @Nullable
        private final State state;
        @Nullable
        private final Nonce nonce;
        @Nullable
        private final Long magAge;
        @Nullable
        private final Long expiry;
        @NotNull
        private final Claims claims;

        @Nullable
        public final ClientId getClient() {
            return this.client;
        }

        @Nullable
        public final Uri getRedirectUri() {
            return this.redirectUri;
        }

        @NotNull
        public final JsonNode getAudience() {
            return this.audience;
        }

        @Nullable
        public final String getIssuer() {
            return this.issuer;
        }

        @Nullable
        public final String getScope() {
            return this.scope;
        }

        @Nullable
        public final ResponseMode getResponseMode() {
            return this.responseMode;
        }

        @Nullable
        public final ResponseType getResponseType() {
            return this.responseType;
        }

        @Nullable
        public final State getState() {
            return this.state;
        }

        @Nullable
        public final Nonce getNonce() {
            return this.nonce;
        }

        @Nullable
        public final Long getMagAge() {
            return this.magAge;
        }

        @Nullable
        public final Long getExpiry() {
            return this.expiry;
        }

        @NotNull
        public final Claims getClaims() {
            return this.claims;
        }

        public RequestObjectJson(@JsonProperty(value="client_id") @Nullable ClientId client, @JsonProperty(value="redirect_uri") @Nullable Uri redirectUri, @JsonProperty(value="aud") @NotNull JsonNode audience, @JsonProperty(value="iss") @Nullable String issuer, @JsonProperty(value="scope") @Nullable String scope, @JsonProperty(value="response_mode") @Nullable ResponseMode responseMode2, @JsonProperty(value="response_type") @Nullable ResponseType responseType2, @JsonProperty(value="state") @Nullable State state2, @JsonProperty(value="nonce") @Nullable Nonce nonce2, @JsonProperty(value="max_age") @Nullable Long magAge, @JsonProperty(value="exp") @Nullable Long expiry, @JsonProperty(value="claims") @NotNull Claims claims) {
            Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
            Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
            this.client = client;
            this.redirectUri = redirectUri;
            this.audience = audience;
            this.issuer = issuer;
            this.scope = scope;
            this.responseMode = responseMode2;
            this.responseType = responseType2;
            this.state = state2;
            this.nonce = nonce2;
            this.magAge = magAge;
            this.expiry = expiry;
            this.claims = claims;
        }

        public /* synthetic */ RequestObjectJson(ClientId clientId, Uri uri, JsonNode jsonNode, String string, String string2, ResponseMode responseMode2, ResponseType responseType2, State state2, Nonce nonce2, Long l, Long l2, Claims claims, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                clientId = null;
            }
            if ((n & 2) != 0) {
                uri = null;
            }
            if ((n & 8) != 0) {
                string = null;
            }
            if ((n & 0x20) != 0) {
                responseMode2 = null;
            }
            if ((n & 0x40) != 0) {
                responseType2 = null;
            }
            if ((n & 0x80) != 0) {
                state2 = null;
            }
            if ((n & 0x100) != 0) {
                nonce2 = null;
            }
            if ((n & 0x200) != 0) {
                l = null;
            }
            if ((n & 0x400) != 0) {
                l2 = null;
            }
            if ((n & 0x800) != 0) {
                claims = new Claims(null, null, 3, null);
            }
            this(clientId, uri, jsonNode, string, string2, responseMode2, responseType2, state2, nonce2, l, l2, claims);
        }

        @Nullable
        public final ClientId component1() {
            return this.client;
        }

        @Nullable
        public final Uri component2() {
            return this.redirectUri;
        }

        @NotNull
        public final JsonNode component3() {
            return this.audience;
        }

        @Nullable
        public final String component4() {
            return this.issuer;
        }

        @Nullable
        public final String component5() {
            return this.scope;
        }

        @Nullable
        public final ResponseMode component6() {
            return this.responseMode;
        }

        @Nullable
        public final ResponseType component7() {
            return this.responseType;
        }

        @Nullable
        public final State component8() {
            return this.state;
        }

        @Nullable
        public final Nonce component9() {
            return this.nonce;
        }

        @Nullable
        public final Long component10() {
            return this.magAge;
        }

        @Nullable
        public final Long component11() {
            return this.expiry;
        }

        @NotNull
        public final Claims component12() {
            return this.claims;
        }

        @NotNull
        public final RequestObjectJson copy(@JsonProperty(value="client_id") @Nullable ClientId client, @JsonProperty(value="redirect_uri") @Nullable Uri redirectUri, @JsonProperty(value="aud") @NotNull JsonNode audience, @JsonProperty(value="iss") @Nullable String issuer, @JsonProperty(value="scope") @Nullable String scope, @JsonProperty(value="response_mode") @Nullable ResponseMode responseMode2, @JsonProperty(value="response_type") @Nullable ResponseType responseType2, @JsonProperty(value="state") @Nullable State state2, @JsonProperty(value="nonce") @Nullable Nonce nonce2, @JsonProperty(value="max_age") @Nullable Long magAge, @JsonProperty(value="exp") @Nullable Long expiry, @JsonProperty(value="claims") @NotNull Claims claims) {
            Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
            Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
            return new RequestObjectJson(client, redirectUri, audience, issuer, scope, responseMode2, responseType2, state2, nonce2, magAge, expiry, claims);
        }

        public static /* synthetic */ RequestObjectJson copy$default(RequestObjectJson requestObjectJson, ClientId clientId, Uri uri, JsonNode jsonNode, String string, String string2, ResponseMode responseMode2, ResponseType responseType2, State state2, Nonce nonce2, Long l, Long l2, Claims claims, int n, Object object) {
            if ((n & 1) != 0) {
                clientId = requestObjectJson.client;
            }
            if ((n & 2) != 0) {
                uri = requestObjectJson.redirectUri;
            }
            if ((n & 4) != 0) {
                jsonNode = requestObjectJson.audience;
            }
            if ((n & 8) != 0) {
                string = requestObjectJson.issuer;
            }
            if ((n & 0x10) != 0) {
                string2 = requestObjectJson.scope;
            }
            if ((n & 0x20) != 0) {
                responseMode2 = requestObjectJson.responseMode;
            }
            if ((n & 0x40) != 0) {
                responseType2 = requestObjectJson.responseType;
            }
            if ((n & 0x80) != 0) {
                state2 = requestObjectJson.state;
            }
            if ((n & 0x100) != 0) {
                nonce2 = requestObjectJson.nonce;
            }
            if ((n & 0x200) != 0) {
                l = requestObjectJson.magAge;
            }
            if ((n & 0x400) != 0) {
                l2 = requestObjectJson.expiry;
            }
            if ((n & 0x800) != 0) {
                claims = requestObjectJson.claims;
            }
            return requestObjectJson.copy(clientId, uri, jsonNode, string, string2, responseMode2, responseType2, state2, nonce2, l, l2, claims);
        }

        @NotNull
        public String toString() {
            return "RequestObjectJson(client=" + this.client + ", redirectUri=" + this.redirectUri + ", audience=" + this.audience + ", issuer=" + this.issuer + ", scope=" + this.scope + ", responseMode=" + (Object)((Object)this.responseMode) + ", responseType=" + (Object)((Object)this.responseType) + ", state=" + this.state + ", nonce=" + this.nonce + ", magAge=" + this.magAge + ", expiry=" + this.expiry + ", claims=" + this.claims + ")";
        }

        public int hashCode() {
            ClientId clientId = this.client;
            Uri uri = this.redirectUri;
            JsonNode jsonNode = this.audience;
            String string = this.issuer;
            String string2 = this.scope;
            ResponseMode responseMode2 = this.responseMode;
            ResponseType responseType2 = this.responseType;
            State state2 = this.state;
            Nonce nonce2 = this.nonce;
            Long l = this.magAge;
            Long l2 = this.expiry;
            Claims claims = this.claims;
            return (((((((((((clientId != null ? ((Object)clientId).hashCode() : 0) * 31 + (uri != null ? uri.hashCode() : 0)) * 31 + (jsonNode != null ? jsonNode.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (responseMode2 != null ? ((Object)((Object)responseMode2)).hashCode() : 0)) * 31 + (responseType2 != null ? ((Object)((Object)responseType2)).hashCode() : 0)) * 31 + (state2 != null ? ((Object)state2).hashCode() : 0)) * 31 + (nonce2 != null ? ((Object)nonce2).hashCode() : 0)) * 31 + (l != null ? ((Object)l).hashCode() : 0)) * 31 + (l2 != null ? ((Object)l2).hashCode() : 0)) * 31 + (claims != null ? ((Object)claims).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RequestObjectJson)) break block3;
                    RequestObjectJson requestObjectJson = (RequestObjectJson)object;
                    if (!Intrinsics.areEqual((Object)this.client, (Object)requestObjectJson.client) || !Intrinsics.areEqual((Object)this.redirectUri, (Object)requestObjectJson.redirectUri) || !Intrinsics.areEqual((Object)this.audience, (Object)requestObjectJson.audience) || !Intrinsics.areEqual((Object)this.issuer, (Object)requestObjectJson.issuer) || !Intrinsics.areEqual((Object)this.scope, (Object)requestObjectJson.scope) || !Intrinsics.areEqual((Object)((Object)this.responseMode), (Object)((Object)requestObjectJson.responseMode)) || !Intrinsics.areEqual((Object)((Object)this.responseType), (Object)((Object)requestObjectJson.responseType)) || !Intrinsics.areEqual((Object)this.state, (Object)requestObjectJson.state) || !Intrinsics.areEqual((Object)this.nonce, (Object)requestObjectJson.nonce) || !Intrinsics.areEqual((Object)this.magAge, (Object)requestObjectJson.magAge) || !Intrinsics.areEqual((Object)this.expiry, (Object)requestObjectJson.expiry) || !Intrinsics.areEqual((Object)this.claims, (Object)requestObjectJson.claims)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

