/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.testing;

import dev.forkhandles.result4k.Success;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.oauth.server.AuthorizationCodeDetails;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/http4k/security/oauth/testing/InMemoryAuthorizationCodes;", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "clock", "Ljava/time/Clock;", "(Ljava/time/Clock;)V", "inFlightCodes", "", "Lorg/http4k/security/oauth/server/AuthorizationCode;", "Lorg/http4k/security/oauth/server/AuthorizationCodeDetails;", "create", "Ldev/forkhandles/result4k/Success;", "request", "Lorg/http4k/core/Request;", "authRequest", "Lorg/http4k/security/oauth/server/AuthRequest;", "response", "Lorg/http4k/core/Response;", "detailsFor", "code", "http4k-security-oauth"})
final class InMemoryAuthorizationCodes
implements AuthorizationCodes {
    private final Map<AuthorizationCode, AuthorizationCodeDetails> inFlightCodes;
    private final Clock clock;

    @Override
    @NotNull
    public AuthorizationCodeDetails detailsFor(@NotNull AuthorizationCode code) {
        Object object;
        block3: {
            boolean bl;
            Object object2;
            block2: {
                Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                object = this.inFlightCodes.get(code);
                if (object == null) break block2;
                object2 = object;
                bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                Map<AuthorizationCode, AuthorizationCodeDetails> map = this.inFlightCodes;
                AuthorizationCode authorizationCode = code;
                boolean bl4 = false;
                map.remove(authorizationCode);
                object = object2;
                if (object != null) break block3;
            }
            object2 = "code not stored";
            bl = false;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        return object;
    }

    @NotNull
    public Success<AuthorizationCode> create(@NotNull Request request2, @NotNull AuthRequest authRequest, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        AuthorizationCode authorizationCode = new AuthorizationCode(string);
        boolean bl = false;
        boolean bl2 = false;
        AuthorizationCode it = authorizationCode;
        boolean bl3 = false;
        ClientId clientId = authRequest.getClient();
        Uri uri = authRequest.getRedirectUri();
        Intrinsics.checkNotNull((Object)uri);
        Instant instant = this.clock.instant().plus(1L, ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant().plus(1, ChronoUnit.DAYS)");
        this.inFlightCodes.put(it, new AuthorizationCodeDetails(clientId, uri, instant, null, false, authRequest.getResponseType(), null, 64, null));
        Unit unit = Unit.INSTANCE;
        AuthorizationCode authorizationCode2 = authorizationCode;
        return new Success((Object)authorizationCode2);
    }

    public InMemoryAuthorizationCodes(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        boolean bl = false;
        this.inFlightCodes = new LinkedHashMap();
    }
}

