/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.security.Nonce;
import org.http4k.security.ResponseMode;
import org.http4k.security.ResponseType;
import org.http4k.security.State;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthRequestExtractor;
import org.http4k.security.oauth.server.AuthRequestFromQueryParameters;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.InvalidAuthorizationRequest;
import org.http4k.security.oauth.server.InvalidRequestObject;
import org.http4k.security.oauth.server.request.RequestJWTValidator;
import org.http4k.security.oauth.server.request.RequestObject;
import org.http4k.security.oauth.server.request.RequestObjectExtractor;
import org.http4k.security.openid.RequestJwtContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J6\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J5\u0010\u0016\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0017\u0012\u0004\u0012\u00020\n0\b\"\u0004\b\u0000\u0010\u00172\b\u0010\u0014\u001a\u0004\u0018\u0001H\u00172\b\u0010\u0015\u001a\u0004\u0018\u0001H\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor;", "Lorg/http4k/security/oauth/server/AuthRequestExtractor;", "requestJWTValidator", "Lorg/http4k/security/oauth/server/request/RequestJWTValidator;", "combineAuthRequestRequestStrategy", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "(Lorg/http4k/security/oauth/server/request/RequestJWTValidator;Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;)V", "combineAuthRequestAndRequestObject", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/security/oauth/server/AuthRequest;", "Lorg/http4k/security/oauth/server/InvalidAuthorizationRequest;", "authRequest", "requestObject", "Lorg/http4k/security/oauth/server/request/RequestObject;", "extract", "request", "Lorg/http4k/core/Request;", "nonEmptyScopeIfExistsOrErrorIfNotEqual", "", "", "authRequestValue", "requestObjectValue", "nonNullValueIfExistsOrErrorIfNotEqual", "T", "(Ljava/lang/Object;Ljava/lang/Object;)Ldev/forkhandles/result4k/Result;", "CombineAuthRequestRequestStrategy", "http4k-security-oauth"})
public final class AuthRequestWithRequestAuthRequestExtractor
implements AuthRequestExtractor {
    private final RequestJWTValidator requestJWTValidator;
    private final CombineAuthRequestRequestStrategy combineAuthRequestRequestStrategy;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Result<AuthRequest, InvalidAuthorizationRequest> extract(@NotNull Request request2) {
        Result<AuthRequest, InvalidAuthorizationRequest> result;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Result<AuthRequest, InvalidAuthorizationRequest> $this$flatMap$iv = AuthRequestFromQueryParameters.INSTANCE.extract(request2);
        boolean $i$f$flatMap = false;
        Result<AuthRequest, InvalidAuthorizationRequest> result2 = $this$flatMap$iv;
        if (result2 instanceof Success) {
            AuthRequest authRequest = (AuthRequest)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            RequestJwtContainer requestJwtContainer = authRequest.getRequest();
            if (requestJwtContainer != null) {
                InvalidAuthorizationRequest requestJwtValidationError = this.requestJWTValidator.validate(authRequest.getClient(), requestJwtContainer);
                if (requestJwtValidationError != null) {
                    result = (Result)new Failure((Object)requestJwtValidationError);
                    return result;
                } else {
                    void $this$flatMap$iv2;
                    Result result3;
                    void $this$mapFailure$iv;
                    Result<RequestObject, InvalidRequestObject> result4 = RequestObjectExtractor.INSTANCE.extractRequestObjectFromJwt(requestJwtContainer.getValue());
                    boolean $i$f$mapFailure = false;
                    void $this$flatMapFailure$iv$iv = $this$mapFailure$iv;
                    boolean $i$f$flatMapFailure = false;
                    void var13_14 = $this$flatMapFailure$iv$iv;
                    if (var13_14 instanceof Success) {
                        result3 = $this$flatMapFailure$iv$iv;
                    } else {
                        InvalidAuthorizationRequest invalidAuthorizationRequest;
                        if (!(var13_14 instanceof Failure)) throw new NoWhenBranchMatchedException();
                        Object reason$iv = ((Failure)$this$flatMapFailure$iv$iv).getReason();
                        boolean bl2 = false;
                        InvalidRequestObject it = (InvalidRequestObject)reason$iv;
                        boolean bl3 = false;
                        InvalidAuthorizationRequest invalidAuthorizationRequest2 = invalidAuthorizationRequest = new InvalidAuthorizationRequest("Query 'request' is invalid");
                        result3 = (Result)new Failure((Object)invalidAuthorizationRequest2);
                    }
                    $this$mapFailure$iv = result3;
                    boolean $i$f$flatMap2 = false;
                    void var11_11 = $this$flatMap$iv2;
                    if (var11_11 instanceof Success) {
                        RequestObject requestObject = (RequestObject)((Success)$this$flatMap$iv2).getValue();
                        boolean bl4 = false;
                        result = this.combineAuthRequestAndRequestObject(authRequest, requestObject);
                        return result;
                    } else {
                        if (!(var11_11 instanceof Failure)) throw new NoWhenBranchMatchedException();
                        result = $this$flatMap$iv2;
                    }
                }
                return result;
            } else {
                result = (Result<AuthRequest, InvalidAuthorizationRequest>)new Success((Object)authRequest);
            }
            return result;
        } else {
            if (!(result2 instanceof Failure)) throw new NoWhenBranchMatchedException();
            result = $this$flatMap$iv;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Result<AuthRequest, InvalidAuthorizationRequest> combineAuthRequestAndRequestObject(AuthRequest authRequest, RequestObject requestObject) {
        if (requestObject.getClient() != null && Intrinsics.areEqual((Object)authRequest.getClient(), (Object)requestObject.getClient()) ^ true) {
            return (Result)new Failure((Object)new InvalidAuthorizationRequest("'client_id' is invalid"));
        }
        AuthRequest authRequest2 = authRequest;
        RequestObject requestObject2 = requestObject;
        Object $this$onFailure$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getRedirectUri(), requestObject.getRedirectUri());
        boolean $i$f$onFailure = false;
        Result<Uri, InvalidAuthorizationRequest> result = $this$onFailure$iv;
        if (!(result instanceof Success)) {
            if (result instanceof Failure) {
                void it;
                Failure failure = (Failure)$this$onFailure$iv;
                RequestObject requestObject3 = requestObject2;
                ClientId clientId = null;
                AuthRequest authRequest3 = authRequest2;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Uri uri = (Uri)((Success)$this$onFailure$iv).getValue();
        $this$onFailure$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getState(), requestObject.getState());
        $i$f$onFailure = false;
        result = $this$onFailure$iv;
        if (!(result instanceof Success)) {
            if (result instanceof Failure) {
                Failure it = (Failure)$this$onFailure$iv;
                Uri uri2 = uri;
                RequestObject requestObject4 = requestObject2;
                ClientId clientId = null;
                AuthRequest authRequest4 = authRequest2;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        State state2 = (State)((Success)$this$onFailure$iv).getValue();
        $this$onFailure$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getNonce(), requestObject.getNonce());
        $i$f$onFailure = false;
        result = $this$onFailure$iv;
        if (!(result instanceof Success)) {
            if (result instanceof Failure) {
                Failure it = (Failure)$this$onFailure$iv;
                State state3 = state2;
                Uri uri3 = uri;
                RequestObject requestObject5 = requestObject2;
                ClientId clientId = null;
                AuthRequest authRequest5 = authRequest2;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Nonce nonce2 = (Nonce)((Success)$this$onFailure$iv).getValue();
        $this$onFailure$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getResponseType(), requestObject.getResponseType());
        $i$f$onFailure = false;
        result = $this$onFailure$iv;
        if (!(result instanceof Success)) {
            if (result instanceof Failure) {
                Failure it = (Failure)$this$onFailure$iv;
                Nonce nonce3 = nonce2;
                State state4 = state2;
                Uri uri4 = uri;
                RequestObject requestObject6 = requestObject2;
                ClientId clientId = null;
                AuthRequest authRequest6 = authRequest2;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        ResponseType responseType2 = (ResponseType)((Object)((Success)$this$onFailure$iv).getValue());
        if (responseType2 == null) {
            responseType2 = ResponseType.Code;
        }
        $this$onFailure$iv = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getResponseMode(), requestObject.getResponseMode());
        $i$f$onFailure = false;
        result = $this$onFailure$iv;
        if (!(result instanceof Success)) {
            if (result instanceof Failure) {
                Failure it = (Failure)$this$onFailure$iv;
                ResponseType responseType3 = responseType2;
                Nonce nonce4 = nonce2;
                State state5 = state2;
                Uri uri5 = uri;
                RequestObject requestObject7 = requestObject2;
                ClientId clientId = null;
                AuthRequest authRequest7 = authRequest2;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        ResponseMode responseMode2 = (ResponseMode)((Object)((Success)$this$onFailure$iv).getValue());
        $this$onFailure$iv = this.nonEmptyScopeIfExistsOrErrorIfNotEqual(authRequest.getScopes(), requestObject.getScope());
        $i$f$onFailure = false;
        result = $this$onFailure$iv;
        if (!(result instanceof Success)) {
            if (result instanceof Failure) {
                Failure it = (Failure)$this$onFailure$iv;
                Object var22_53 = null;
                ResponseMode responseMode3 = responseMode2;
                ResponseType responseType4 = responseType2;
                Nonce nonce5 = nonce2;
                State state6 = state2;
                Uri uri6 = uri;
                RequestObject requestObject8 = requestObject2;
                ClientId clientId = null;
                AuthRequest authRequest8 = authRequest2;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Map map = null;
        List list = (List)((Success)$this$onFailure$iv).getValue();
        result = null;
        ResponseMode responseMode4 = responseMode2;
        ResponseType responseType5 = responseType2;
        Nonce nonce6 = nonce2;
        State state7 = state2;
        Uri uri7 = uri;
        RequestObject requestObject9 = requestObject2;
        AuthRequest authRequest9 = AuthRequest.copy$default(authRequest2, null, list, uri7, state7, responseType5, nonce6, responseMode4, result, requestObject9, map, 641, null);
        return (Result)new Success((Object)authRequest9);
    }

    private final <T> Result<T, InvalidAuthorizationRequest> nonNullValueIfExistsOrErrorIfNotEqual(T authRequestValue, T requestObjectValue) {
        if (authRequestValue != null && requestObjectValue != null && Intrinsics.areEqual(authRequestValue, requestObjectValue) ^ true) {
            return (Result)new Failure((Object)new InvalidAuthorizationRequest("request object is invalid"));
        }
        return (Result)new Success(this.combineAuthRequestRequestStrategy.combine(authRequestValue, requestObjectValue));
    }

    private final Result<List<String>, InvalidAuthorizationRequest> nonEmptyScopeIfExistsOrErrorIfNotEqual(List<String> authRequestValue, List<String> requestObjectValue) {
        Collection collection = authRequestValue;
        boolean bl = false;
        if (!collection.isEmpty()) {
            collection = requestObjectValue;
            bl = false;
            if (!collection.isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)authRequestValue), (Object)CollectionsKt.toSet((Iterable)requestObjectValue)) ^ true) {
                return (Result)new Failure((Object)new InvalidAuthorizationRequest("request object is invalid"));
            }
        }
        return (Result)new Success(this.combineAuthRequestRequestStrategy.combine(authRequestValue, requestObjectValue));
    }

    public AuthRequestWithRequestAuthRequestExtractor(@NotNull RequestJWTValidator requestJWTValidator, @NotNull CombineAuthRequestRequestStrategy combineAuthRequestRequestStrategy) {
        Intrinsics.checkNotNullParameter((Object)requestJWTValidator, (String)"requestJWTValidator");
        Intrinsics.checkNotNullParameter((Object)combineAuthRequestRequestStrategy, (String)"combineAuthRequestRequestStrategy");
        this.requestJWTValidator = requestJWTValidator;
        this.combineAuthRequestRequestStrategy = combineAuthRequestRequestStrategy;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00042\b\u0010\u0006\u001a\u0004\u0018\u0001H\u0004H&\u00a2\u0006\u0002\u0010\u0007J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00040\b\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH&\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "", "()V", "combine", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "AuthRequestOnly", "Combine", "RequestObjectOnly", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$Combine;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$AuthRequestOnly;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$RequestObjectOnly;", "http4k-security-oauth"})
    public static abstract class CombineAuthRequestRequestStrategy {
        @Nullable
        public abstract <T> T combine(@Nullable T var1, @Nullable T var2);

        @NotNull
        public abstract <T> List<T> combine(@NotNull List<? extends T> var1, @NotNull List<? extends T> var2);

        private CombineAuthRequestRequestStrategy() {
        }

        public /* synthetic */ CombineAuthRequestRequestStrategy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00042\b\u0010\u0006\u001a\u0004\u0018\u0001H\u0004H\u0016\u00a2\u0006\u0002\u0010\u0007J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00040\b\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$Combine;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "()V", "combine", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "http4k-security-oauth"})
        public static final class Combine
        extends CombineAuthRequestRequestStrategy {
            @NotNull
            public static final Combine INSTANCE;

            @Override
            @Nullable
            public <T> T combine(@Nullable T authRequestValue, @Nullable T requestObjectValue) {
                T t = authRequestValue;
                if (t == null) {
                    t = requestObjectValue;
                }
                return t;
            }

            @Override
            @NotNull
            public <T> List<T> combine(@NotNull List<? extends T> authRequestValue, @NotNull List<? extends T> requestObjectValue) {
                Intrinsics.checkNotNullParameter(authRequestValue, (String)"authRequestValue");
                Intrinsics.checkNotNullParameter(requestObjectValue, (String)"requestObjectValue");
                Collection collection = authRequestValue;
                boolean bl = false;
                return !collection.isEmpty() ? authRequestValue : requestObjectValue;
            }

            private Combine() {
                super(null);
            }

            static {
                Combine combine;
                INSTANCE = combine = new Combine();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00042\b\u0010\u0006\u001a\u0004\u0018\u0001H\u0004H\u0016\u00a2\u0006\u0002\u0010\u0007J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00040\b\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$AuthRequestOnly;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "()V", "combine", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "http4k-security-oauth"})
        public static final class AuthRequestOnly
        extends CombineAuthRequestRequestStrategy {
            @NotNull
            public static final AuthRequestOnly INSTANCE;

            @Override
            @Nullable
            public <T> T combine(@Nullable T authRequestValue, @Nullable T requestObjectValue) {
                return authRequestValue;
            }

            @Override
            @NotNull
            public <T> List<T> combine(@NotNull List<? extends T> authRequestValue, @NotNull List<? extends T> requestObjectValue) {
                Intrinsics.checkNotNullParameter(authRequestValue, (String)"authRequestValue");
                Intrinsics.checkNotNullParameter(requestObjectValue, (String)"requestObjectValue");
                return authRequestValue;
            }

            private AuthRequestOnly() {
                super(null);
            }

            static {
                AuthRequestOnly authRequestOnly;
                INSTANCE = authRequestOnly = new AuthRequestOnly();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00042\b\u0010\u0006\u001a\u0004\u0018\u0001H\u0004H\u0016\u00a2\u0006\u0002\u0010\u0007J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00040\b\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$RequestObjectOnly;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "()V", "combine", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "http4k-security-oauth"})
        public static final class RequestObjectOnly
        extends CombineAuthRequestRequestStrategy {
            @NotNull
            public static final RequestObjectOnly INSTANCE;

            @Override
            @Nullable
            public <T> T combine(@Nullable T authRequestValue, @Nullable T requestObjectValue) {
                return requestObjectValue;
            }

            @Override
            @NotNull
            public <T> List<T> combine(@NotNull List<? extends T> authRequestValue, @NotNull List<? extends T> requestObjectValue) {
                Intrinsics.checkNotNullParameter(authRequestValue, (String)"authRequestValue");
                Intrinsics.checkNotNullParameter(requestObjectValue, (String)"requestObjectValue");
                return requestObjectValue;
            }

            private RequestObjectOnly() {
                super(null);
            }

            static {
                RequestObjectOnly requestObjectOnly;
                INSTANCE = requestObjectOnly = new RequestObjectOnly();
            }
        }
    }
}

