/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import java.time.Clock;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Body;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.format.AutoMarshalling;
import org.http4k.lens.BiDiBodyLens;
import org.http4k.lens.BiDiLens;
import org.http4k.lens.BiDiLensSpec;
import org.http4k.lens.FormField;
import org.http4k.lens.Lens;
import org.http4k.lens.LensSpec;
import org.http4k.lens.LensSpecKt;
import org.http4k.lens.Query;
import org.http4k.lens.Validator;
import org.http4k.lens.WebForm;
import org.http4k.lens.WebFormKt;
import org.http4k.routing.RoutingHttpHandler;
import org.http4k.routing.RoutingKt;
import org.http4k.security.Nonce;
import org.http4k.security.ResponseMode;
import org.http4k.security.ResponseType;
import org.http4k.security.State;
import org.http4k.security.oauth.server.AccessTokens;
import org.http4k.security.oauth.server.AuthRequestExtractor;
import org.http4k.security.oauth.server.AuthRequestFromQueryParameters;
import org.http4k.security.oauth.server.AuthRequestTracking;
import org.http4k.security.oauth.server.AuthRequestTrackingFilter;
import org.http4k.security.oauth.server.AuthenticationComplete;
import org.http4k.security.oauth.server.AuthoriseRequestErrorRender;
import org.http4k.security.oauth.server.AuthoriseRequestValidator;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.ClientValidationFilter;
import org.http4k.security.oauth.server.ClientValidator;
import org.http4k.security.oauth.server.GenerateAccessToken;
import org.http4k.security.oauth.server.IdTokens;
import org.http4k.security.oauth.server.JsonResponseErrorRenderer;
import org.http4k.security.oauth.server.OAuthServer;
import org.http4k.security.oauth.server.OAuthServerMoshi;
import org.http4k.security.oauth.server.SimpleAuthoriseRequestValidator;
import org.http4k.security.oauth.server.accesstoken.AccessTokenRequestAuthentication;
import org.http4k.security.oauth.server.accesstoken.ClientSecretAccessTokenRequestAuthentication;
import org.http4k.security.oauth.server.accesstoken.GrantTypesConfiguration;
import org.http4k.security.oauth.server.refreshtoken.RefreshTokens;
import org.http4k.security.oauth.server.request.RequestJWTValidator;
import org.http4k.security.openid.RequestJwtContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u00011B\u007f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u001bB\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u00062"}, d2={"Lorg/http4k/security/oauth/server/OAuthServer;", "", "tokenPath", "", "authRequestTracking", "Lorg/http4k/security/oauth/server/AuthRequestTracking;", "clientValidator", "Lorg/http4k/security/oauth/server/ClientValidator;", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "accessTokens", "Lorg/http4k/security/oauth/server/AccessTokens;", "clock", "Ljava/time/Clock;", "json", "Lorg/http4k/format/AutoMarshalling;", "authRequestExtractor", "Lorg/http4k/security/oauth/server/AuthRequestExtractor;", "grantTypes", "Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;", "idTokens", "Lorg/http4k/security/oauth/server/IdTokens;", "refreshTokens", "Lorg/http4k/security/oauth/server/refreshtoken/RefreshTokens;", "requestJWTValidator", "Lorg/http4k/security/oauth/server/request/RequestJWTValidator;", "documentationUri", "(Ljava/lang/String;Lorg/http4k/security/oauth/server/AuthRequestTracking;Lorg/http4k/security/oauth/server/ClientValidator;Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Ljava/time/Clock;Lorg/http4k/format/AutoMarshalling;Lorg/http4k/security/oauth/server/AuthRequestExtractor;Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;Lorg/http4k/security/oauth/server/IdTokens;Lorg/http4k/security/oauth/server/refreshtoken/RefreshTokens;Lorg/http4k/security/oauth/server/request/RequestJWTValidator;Ljava/lang/String;)V", "authoriseRequestValidator", "Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;", "accessTokenRequestAuthentication", "Lorg/http4k/security/oauth/server/accesstoken/AccessTokenRequestAuthentication;", "(Ljava/lang/String;Lorg/http4k/security/oauth/server/AuthRequestTracking;Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;Lorg/http4k/security/oauth/server/accesstoken/AccessTokenRequestAuthentication;Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Ljava/time/Clock;Lorg/http4k/format/AutoMarshalling;Lorg/http4k/security/oauth/server/AuthRequestExtractor;Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;Lorg/http4k/security/oauth/server/IdTokens;Lorg/http4k/security/oauth/server/refreshtoken/RefreshTokens;Lorg/http4k/security/oauth/server/request/RequestJWTValidator;Ljava/lang/String;)V", "authenticationComplete", "Lorg/http4k/security/oauth/server/AuthenticationComplete;", "getAuthenticationComplete", "()Lorg/http4k/security/oauth/server/AuthenticationComplete;", "authenticationStart", "Lorg/http4k/core/Filter;", "getAuthenticationStart", "()Lorg/http4k/core/Filter;", "authoriseRequestErrorRender", "Lorg/http4k/security/oauth/server/AuthoriseRequestErrorRender;", "errorRenderer", "Lorg/http4k/security/oauth/server/JsonResponseErrorRenderer;", "tokenRoute", "Lorg/http4k/routing/RoutingHttpHandler;", "getTokenRoute", "()Lorg/http4k/routing/RoutingHttpHandler;", "Companion", "http4k-security-oauth"})
public final class OAuthServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonResponseErrorRenderer errorRenderer;
    @NotNull
    private final AuthoriseRequestErrorRender authoriseRequestErrorRender;
    @NotNull
    private final RoutingHttpHandler tokenRoute;
    @NotNull
    private final Filter authenticationStart;
    @NotNull
    private final AuthenticationComplete authenticationComplete;
    @NotNull
    private static final BiDiLens<Request, ClientId> clientIdQueryParameter = (BiDiLens)LensSpec.required$default((LensSpec)((LensSpec)Query.INSTANCE.map((Function1)Companion.clientIdQueryParameter.1.INSTANCE, (Function1)Companion.clientIdQueryParameter.2.INSTANCE)), (String)"client_id", null, (int)2, null);
    @NotNull
    private static final BiDiLens<Request, List<String>> scopesQueryParameter = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)Query.INSTANCE.map((Function1)Companion.scopesQueryParameter.1.INSTANCE, (Function1)Companion.scopesQueryParameter.2.INSTANCE)), (String)"scope", null, (int)2, null);
    @NotNull
    private static final BiDiLens<Request, Uri> redirectUriQueryParameter = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)Query.INSTANCE))), (String)"redirect_uri", null, (int)2, null);
    @NotNull
    private static final BiDiLens<Request, State> state = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)Query.INSTANCE.map((Function1)Companion.state.1.INSTANCE, (Function1)Companion.state.2.INSTANCE)), (String)"state", null, (int)2, null);
    @NotNull
    private static final BiDiLens<Request, ResponseType> responseType = (BiDiLens)LensSpec.required$default((LensSpec)((LensSpec)Query.INSTANCE.map((Function1)new Function1<String, ResponseType>((Object)ResponseType.Companion){

        @NotNull
        public final ResponseType invoke(@NotNull String p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return ((ResponseType.Companion)this.receiver).fromQueryParameterValue(p0);
        }
    }, (Function1)Companion.responseType.2.INSTANCE)), (String)"response_type", null, (int)2, null);
    @NotNull
    private static final BiDiLens<Request, ResponseMode> responseMode = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)Query.INSTANCE.map((Function1)new Function1<String, ResponseMode>((Object)ResponseMode.Companion){

        @NotNull
        public final ResponseMode invoke(@NotNull String p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return ((ResponseMode.Companion)this.receiver).fromQueryParameterValue(p0);
        }
    }, (Function1)Companion.responseMode.2.INSTANCE)), (String)"response_mode", null, (int)2, null);
    @NotNull
    private static final BiDiLens<Request, Nonce> nonce = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)Query.INSTANCE.map((Function1)Companion.nonce.1.INSTANCE, (Function1)Companion.nonce.2.INSTANCE)), (String)"nonce", null, (int)2, null);
    @NotNull
    private static final BiDiLens<Request, RequestJwtContainer> request = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)Query.INSTANCE.map((Function1)Companion.request.1.INSTANCE, (Function1)Companion.request.2.INSTANCE)), (String)"request", null, (int)2, null);
    @NotNull
    private static final BiDiLens<WebForm, ClientId> clientIdForm = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)FormField.INSTANCE.map((Function1)Companion.clientIdForm.1.INSTANCE, (Function1)Companion.clientIdForm.2.INSTANCE)), (String)"client_id", null, (int)2, null);
    @NotNull
    private static final BiDiLens<WebForm, String> clientSecret = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)FormField.INSTANCE), (String)"client_secret", null, (int)2, null);
    @NotNull
    private static final BiDiLens<WebForm, String> code = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)FormField.INSTANCE), (String)"code", null, (int)2, null);
    @NotNull
    private static final BiDiLens<WebForm, Uri> redirectUriForm = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)FormField.INSTANCE))), (String)"redirect_uri", null, (int)2, null);
    @NotNull
    private static final BiDiLens<WebForm, List<String>> scopesForm = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)FormField.INSTANCE.map((Function1)Companion.scopesForm.1.INSTANCE, (Function1)Companion.scopesForm.2.INSTANCE)), (String)"scope", null, (int)2, null);
    @NotNull
    private static final BiDiLens<WebForm, Uri> clientAssertionType = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)FormField.INSTANCE))), (String)"client_assertion_type", null, (int)2, null);
    @NotNull
    private static final BiDiLens<WebForm, String> clientAssertion = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)FormField.INSTANCE), (String)"client_assertion", null, (int)2, null);
    @NotNull
    private static final BiDiLens<WebForm, String> refreshToken = (BiDiLens)LensSpec.optional$default((LensSpec)((LensSpec)FormField.INSTANCE), (String)"refresh_token", null, (int)2, null);
    @NotNull
    private static final BiDiBodyLens<WebForm> tokenRequestWebForm;

    public OAuthServer(@NotNull String tokenPath, @NotNull AuthRequestTracking authRequestTracking, @NotNull AuthoriseRequestValidator authoriseRequestValidator, @NotNull AccessTokenRequestAuthentication accessTokenRequestAuthentication, @NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull Clock clock, @NotNull AutoMarshalling json, @NotNull AuthRequestExtractor authRequestExtractor, @NotNull GrantTypesConfiguration grantTypes, @NotNull IdTokens idTokens, @NotNull RefreshTokens refreshTokens, @NotNull RequestJWTValidator requestJWTValidator, @Nullable String documentationUri) {
        Intrinsics.checkNotNullParameter((Object)tokenPath, (String)"tokenPath");
        Intrinsics.checkNotNullParameter((Object)authRequestTracking, (String)"authRequestTracking");
        Intrinsics.checkNotNullParameter((Object)authoriseRequestValidator, (String)"authoriseRequestValidator");
        Intrinsics.checkNotNullParameter((Object)accessTokenRequestAuthentication, (String)"accessTokenRequestAuthentication");
        Intrinsics.checkNotNullParameter((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkNotNullParameter((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)authRequestExtractor, (String)"authRequestExtractor");
        Intrinsics.checkNotNullParameter((Object)grantTypes, (String)"grantTypes");
        Intrinsics.checkNotNullParameter((Object)idTokens, (String)"idTokens");
        Intrinsics.checkNotNullParameter((Object)refreshTokens, (String)"refreshTokens");
        Intrinsics.checkNotNullParameter((Object)requestJWTValidator, (String)"requestJWTValidator");
        this.errorRenderer = new JsonResponseErrorRenderer(json, documentationUri);
        this.authoriseRequestErrorRender = new AuthoriseRequestErrorRender(authoriseRequestValidator, requestJWTValidator, this.errorRenderer, documentationUri);
        Object object = new RoutingHttpHandler[]{RoutingKt.bind((String)tokenPath, (Method)Method.POST).to((Function1)new GenerateAccessToken(authorizationCodes, accessTokens, clock, idTokens, refreshTokens, this.errorRenderer, grantTypes))};
        this.tokenRoute = RoutingKt.routes((RoutingHttpHandler[])object);
        object = new AuthRequestTrackingFilter(authRequestTracking, authRequestExtractor, this.authoriseRequestErrorRender);
        this.authenticationStart = Http4kKt.then((Filter)new ClientValidationFilter(authoriseRequestValidator, this.authoriseRequestErrorRender, authRequestExtractor), (Filter)new Filter((Function1)object){
            private final /* synthetic */ Function1 function;
            {
                this.function = function;
            }

            public final /* synthetic */ Function1 invoke(Function1 p1) {
                return (Function1)this.function.invoke((Object)p1);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Filter ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        this.authenticationComplete = new AuthenticationComplete(authorizationCodes, authRequestTracking, idTokens, documentationUri);
    }

    public /* synthetic */ OAuthServer(String string, AuthRequestTracking authRequestTracking, AuthoriseRequestValidator authoriseRequestValidator, AccessTokenRequestAuthentication accessTokenRequestAuthentication, AuthorizationCodes authorizationCodes, AccessTokens accessTokens, Clock clock, AutoMarshalling autoMarshalling, AuthRequestExtractor authRequestExtractor, GrantTypesConfiguration grantTypesConfiguration, IdTokens idTokens, RefreshTokens refreshTokens, RequestJWTValidator requestJWTValidator, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            autoMarshalling = (AutoMarshalling)OAuthServerMoshi.INSTANCE;
        }
        if ((n & 0x100) != 0) {
            authRequestExtractor = AuthRequestFromQueryParameters.INSTANCE;
        }
        if ((n & 0x200) != 0) {
            grantTypesConfiguration = GrantTypesConfiguration.Companion.default(accessTokenRequestAuthentication);
        }
        if ((n & 0x400) != 0) {
            idTokens = IdTokens.Companion.getUnsupported();
        }
        if ((n & 0x800) != 0) {
            refreshTokens = RefreshTokens.Companion.getUnsupported();
        }
        if ((n & 0x1000) != 0) {
            requestJWTValidator = RequestJWTValidator.Companion.getUnsupported();
        }
        if ((n & 0x2000) != 0) {
            string2 = null;
        }
        this(string, authRequestTracking, authoriseRequestValidator, accessTokenRequestAuthentication, authorizationCodes, accessTokens, clock, autoMarshalling, authRequestExtractor, grantTypesConfiguration, idTokens, refreshTokens, requestJWTValidator, string2);
    }

    public OAuthServer(@NotNull String tokenPath, @NotNull AuthRequestTracking authRequestTracking, @NotNull ClientValidator clientValidator, @NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull Clock clock, @NotNull AutoMarshalling json, @NotNull AuthRequestExtractor authRequestExtractor, @NotNull GrantTypesConfiguration grantTypes, @NotNull IdTokens idTokens, @NotNull RefreshTokens refreshTokens, @NotNull RequestJWTValidator requestJWTValidator, @Nullable String documentationUri) {
        Intrinsics.checkNotNullParameter((Object)tokenPath, (String)"tokenPath");
        Intrinsics.checkNotNullParameter((Object)authRequestTracking, (String)"authRequestTracking");
        Intrinsics.checkNotNullParameter((Object)clientValidator, (String)"clientValidator");
        Intrinsics.checkNotNullParameter((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkNotNullParameter((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)authRequestExtractor, (String)"authRequestExtractor");
        Intrinsics.checkNotNullParameter((Object)grantTypes, (String)"grantTypes");
        Intrinsics.checkNotNullParameter((Object)idTokens, (String)"idTokens");
        Intrinsics.checkNotNullParameter((Object)refreshTokens, (String)"refreshTokens");
        Intrinsics.checkNotNullParameter((Object)requestJWTValidator, (String)"requestJWTValidator");
        this(tokenPath, authRequestTracking, new SimpleAuthoriseRequestValidator(clientValidator), new ClientSecretAccessTokenRequestAuthentication(clientValidator), authorizationCodes, accessTokens, clock, json, authRequestExtractor, grantTypes, idTokens, refreshTokens, requestJWTValidator, documentationUri);
    }

    public /* synthetic */ OAuthServer(String string, AuthRequestTracking authRequestTracking, ClientValidator clientValidator, AuthorizationCodes authorizationCodes, AccessTokens accessTokens, Clock clock, AutoMarshalling autoMarshalling, AuthRequestExtractor authRequestExtractor, GrantTypesConfiguration grantTypesConfiguration, IdTokens idTokens, RefreshTokens refreshTokens, RequestJWTValidator requestJWTValidator, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            autoMarshalling = (AutoMarshalling)OAuthServerMoshi.INSTANCE;
        }
        if ((n & 0x80) != 0) {
            authRequestExtractor = AuthRequestFromQueryParameters.INSTANCE;
        }
        if ((n & 0x100) != 0) {
            grantTypesConfiguration = GrantTypesConfiguration.Companion.default(new ClientSecretAccessTokenRequestAuthentication(clientValidator));
        }
        if ((n & 0x200) != 0) {
            idTokens = IdTokens.Companion.getUnsupported();
        }
        if ((n & 0x400) != 0) {
            refreshTokens = RefreshTokens.Companion.getUnsupported();
        }
        if ((n & 0x800) != 0) {
            requestJWTValidator = RequestJWTValidator.Companion.getUnsupported();
        }
        if ((n & 0x1000) != 0) {
            string2 = null;
        }
        this(string, authRequestTracking, clientValidator, authorizationCodes, accessTokens, clock, autoMarshalling, authRequestExtractor, grantTypesConfiguration, idTokens, refreshTokens, requestJWTValidator, string2);
    }

    @NotNull
    public final RoutingHttpHandler getTokenRoute() {
        return this.tokenRoute;
    }

    @NotNull
    public final Filter getAuthenticationStart() {
        return this.authenticationStart;
    }

    @NotNull
    public final AuthenticationComplete getAuthenticationComplete() {
        return this.authenticationComplete;
    }

    static {
        Lens[] lensArray = new Lens[]{(Lens)clientIdForm, (Lens)clientSecret, (Lens)code, (Lens)redirectUriForm, (Lens)scopesForm, (Lens)clientAssertionType, (Lens)clientAssertion, (Lens)refreshToken};
        tokenRequestWebForm = WebFormKt.webForm((Body.Companion)Body.Companion, (Validator)Validator.Strict, (Lens[])lensArray).toLens();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u001f\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u001f\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR\u001f\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR\u001f\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR\u001f\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\bR\u001f\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u001f\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\bR\u001f\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010 0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\bR\u001f\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010#0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\bR\u001d\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020&0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\bR%\u0010(\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010)0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\bR%\u0010+\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010)0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\bR\u001f\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010.0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\bR\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020\u000501\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Lorg/http4k/security/oauth/server/OAuthServer$Companion;", "", "()V", "clientAssertion", "Lorg/http4k/lens/BiDiLens;", "Lorg/http4k/lens/WebForm;", "", "getClientAssertion", "()Lorg/http4k/lens/BiDiLens;", "clientAssertionType", "Lorg/http4k/core/Uri;", "getClientAssertionType", "clientIdForm", "Lorg/http4k/security/oauth/server/ClientId;", "getClientIdForm", "clientIdQueryParameter", "Lorg/http4k/core/Request;", "getClientIdQueryParameter", "clientSecret", "getClientSecret", "code", "getCode", "nonce", "Lorg/http4k/security/Nonce;", "getNonce", "redirectUriForm", "getRedirectUriForm", "redirectUriQueryParameter", "getRedirectUriQueryParameter", "refreshToken", "getRefreshToken", "request", "Lorg/http4k/security/openid/RequestJwtContainer;", "getRequest", "responseMode", "Lorg/http4k/security/ResponseMode;", "getResponseMode", "responseType", "Lorg/http4k/security/ResponseType;", "getResponseType", "scopesForm", "", "getScopesForm", "scopesQueryParameter", "getScopesQueryParameter", "state", "Lorg/http4k/security/State;", "getState", "tokenRequestWebForm", "Lorg/http4k/lens/BiDiBodyLens;", "getTokenRequestWebForm", "()Lorg/http4k/lens/BiDiBodyLens;", "http4k-security-oauth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BiDiLens<Request, ClientId> getClientIdQueryParameter() {
            return clientIdQueryParameter;
        }

        @NotNull
        public final BiDiLens<Request, List<String>> getScopesQueryParameter() {
            return scopesQueryParameter;
        }

        @NotNull
        public final BiDiLens<Request, Uri> getRedirectUriQueryParameter() {
            return redirectUriQueryParameter;
        }

        @NotNull
        public final BiDiLens<Request, State> getState() {
            return state;
        }

        @NotNull
        public final BiDiLens<Request, ResponseType> getResponseType() {
            return responseType;
        }

        @NotNull
        public final BiDiLens<Request, ResponseMode> getResponseMode() {
            return responseMode;
        }

        @NotNull
        public final BiDiLens<Request, Nonce> getNonce() {
            return nonce;
        }

        @NotNull
        public final BiDiLens<Request, RequestJwtContainer> getRequest() {
            return request;
        }

        @NotNull
        public final BiDiLens<WebForm, ClientId> getClientIdForm() {
            return clientIdForm;
        }

        @NotNull
        public final BiDiLens<WebForm, String> getClientSecret() {
            return clientSecret;
        }

        @NotNull
        public final BiDiLens<WebForm, String> getCode() {
            return code;
        }

        @NotNull
        public final BiDiLens<WebForm, Uri> getRedirectUriForm() {
            return redirectUriForm;
        }

        @NotNull
        public final BiDiLens<WebForm, List<String>> getScopesForm() {
            return scopesForm;
        }

        @NotNull
        public final BiDiLens<WebForm, Uri> getClientAssertionType() {
            return clientAssertionType;
        }

        @NotNull
        public final BiDiLens<WebForm, String> getClientAssertion() {
            return clientAssertion;
        }

        @NotNull
        public final BiDiLens<WebForm, String> getRefreshToken() {
            return refreshToken;
        }

        @NotNull
        public final BiDiBodyLens<WebForm> getTokenRequestWebForm() {
            return tokenRequestWebForm;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

