/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.client;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.security.AccessToken;
import org.http4k.security.AccessTokenKt;
import org.http4k.security.AccessTokenResponse;
import org.http4k.security.ExpiringCredentials;
import org.http4k.security.OAuthProviderConfig;
import org.http4k.security.oauth.client.AccessTokens;
import org.http4k.security.oauth.client.TokenRequest;
import org.http4k.security.oauth.client.TokenRequestKt;
import org.http4k.security.oauth.core.RefreshToken;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/http4k/security/oauth/client/OAuthOfflineRequestAuthorizer;", "", "config", "Lorg/http4k/security/OAuthProviderConfig;", "accessTokens", "Lorg/http4k/security/oauth/client/AccessTokens;", "backend", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "authRequestFilter", "Lorg/http4k/core/Filter;", "gracePeriod", "Ljava/time/Duration;", "clock", "Ljava/time/Clock;", "(Lorg/http4k/security/OAuthProviderConfig;Lorg/http4k/security/oauth/client/AccessTokens;Lkotlin/jvm/functions/Function1;Lorg/http4k/core/Filter;Ljava/time/Duration;Ljava/time/Clock;)V", "authClient", "refresh", "Lorg/http4k/security/ExpiringCredentials;", "Lorg/http4k/security/AccessToken;", "refreshToken", "Lorg/http4k/security/oauth/core/RefreshToken;", "toFilter", "http4k-security-oauth"})
public final class OAuthOfflineRequestAuthorizer {
    @NotNull
    private final OAuthProviderConfig config;
    @NotNull
    private final AccessTokens accessTokens;
    @NotNull
    private final Duration gracePeriod;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Function1<Request, Response> authClient;

    public OAuthOfflineRequestAuthorizer(@NotNull OAuthProviderConfig config, @NotNull AccessTokens accessTokens, @NotNull Function1<? super Request, ? extends Response> backend, @NotNull Filter authRequestFilter, @NotNull Duration gracePeriod, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkNotNullParameter(backend, (String)"backend");
        Intrinsics.checkNotNullParameter((Object)authRequestFilter, (String)"authRequestFilter");
        Intrinsics.checkNotNullParameter((Object)gracePeriod, (String)"gracePeriod");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.config = config;
        this.accessTokens = accessTokens;
        this.gracePeriod = gracePeriod;
        this.clock = clock;
        this.authClient = Http4kKt.then((Filter)authRequestFilter, backend);
    }

    public /* synthetic */ OAuthOfflineRequestAuthorizer(OAuthProviderConfig oAuthProviderConfig, AccessTokens accessTokens, Function1 function1, Filter filter, Duration object, Clock object2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Object object3;
        if ((n & 0x10) != 0) {
            object3 = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"ofSeconds(10)");
            object = object3;
        }
        if ((n & 0x20) != 0) {
            object3 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"systemUTC()");
            object2 = object3;
        }
        this(oAuthProviderConfig, accessTokens, (Function1<? super Request, ? extends Response>)function1, filter, (Duration)object, (Clock)object2);
    }

    private final ExpiringCredentials<AccessToken> refresh(RefreshToken refreshToken2) {
        TokenRequest body = TokenRequest.Companion.refreshToken(refreshToken2);
        Function1[] function1Array = new Function1[]{TokenRequestKt.getTokenRequestLens().of((Object)body)};
        Request request2 = (Request)HttpKt.with((HttpMessage)((HttpMessage)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.POST, (Uri)this.config.getTokenUri(), null, (int)4, null)), (Function1[])function1Array);
        Response response = (Response)this.authClient.invoke((Object)request2);
        if (!response.getStatus().getSuccessful()) {
            return null;
        }
        AccessTokenResponse responseBody = (AccessTokenResponse)AccessTokenKt.getAccessTokenResponseBody().invoke((HttpMessage)response);
        AccessToken accessToken = responseBody.toAccessToken();
        Long l = responseBody.getExpires_in();
        Instant instant = this.clock.instant().plusSeconds(l == null ? Long.MAX_VALUE : l);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant().plusSeco\u2026res_in ?: Long.MAX_VALUE)");
        return new ExpiringCredentials((Object)accessToken, instant);
    }

    @NotNull
    public final Filter toFilter(@NotNull RefreshToken refreshToken2) {
        Intrinsics.checkNotNullParameter((Object)refreshToken2, (String)"refreshToken");
        return arg_0 -> OAuthOfflineRequestAuthorizer.toFilter$lambda-0(this, refreshToken2, arg_0);
    }

    private static final Function1 toFilter$lambda-0(OAuthOfflineRequestAuthorizer this$0, RefreshToken $refreshToken, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$refreshToken, (String)"$refreshToken");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return (Function1)new Function1<Request, Response>(this$0, $refreshToken, (Function1<? super Request, ? extends Response>)next){
            final /* synthetic */ OAuthOfflineRequestAuthorizer this$0;
            final /* synthetic */ RefreshToken $refreshToken;
            final /* synthetic */ Function1<Request, Response> $next;
            {
                this.this$0 = $receiver;
                this.$refreshToken = $refreshToken;
                this.$next = $next;
                super(1);
            }

            @NotNull
            public final Response invoke(@NotNull Request request2) {
                Object object;
                Object object2;
                Object object3;
                OAuthOfflineRequestAuthorizer oAuthOfflineRequestAuthorizer;
                Object object4;
                Object object5;
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                ExpiringCredentials expiringCredentials = OAuthOfflineRequestAuthorizer.access$getAccessTokens$p(this.this$0).get(this.$refreshToken);
                if (expiringCredentials == null) {
                    object5 = null;
                } else {
                    object4 = expiringCredentials;
                    oAuthOfflineRequestAuthorizer = this.this$0;
                    ExpiringCredentials it = object4;
                    boolean bl = false;
                    object5 = object3 = Duration.between(OAuthOfflineRequestAuthorizer.access$getClock$p(oAuthOfflineRequestAuthorizer).instant(), it.getExpiry()).compareTo(OAuthOfflineRequestAuthorizer.access$getGracePeriod$p(oAuthOfflineRequestAuthorizer)) > 0 ? object4 : null;
                }
                if (object3 == null) {
                    ExpiringCredentials expiringCredentials2 = OAuthOfflineRequestAuthorizer.access$refresh(this.this$0, this.$refreshToken);
                    if (expiringCredentials2 == null) {
                        object2 = null;
                    } else {
                        object4 = expiringCredentials2;
                        oAuthOfflineRequestAuthorizer = this.this$0;
                        RefreshToken refreshToken2 = this.$refreshToken;
                        Object it = object4;
                        boolean bl = false;
                        OAuthOfflineRequestAuthorizer.access$getAccessTokens$p(oAuthOfflineRequestAuthorizer).set(refreshToken2, (ExpiringCredentials<AccessToken>)it);
                        object2 = object4;
                    }
                } else {
                    object2 = object3;
                }
                Object tokenData = object2;
                expiringCredentials = tokenData;
                if (expiringCredentials == null) {
                    object = request2;
                } else {
                    object4 = (AccessToken)expiringCredentials.getCredentials();
                    if (object4 == null) {
                        object = request2;
                    } else {
                        Object it = object4;
                        boolean bl = false;
                        StringBuilder stringBuilder = new StringBuilder();
                        String string = ((AccessToken)it).getType();
                        if (string == null) {
                            string = "Bearer";
                        }
                        object = (oAuthOfflineRequestAuthorizer = request2.header("Authorization", stringBuilder.append(string).append(' ').append(((AccessToken)it).getValue()).toString())) == null ? request2 : oAuthOfflineRequestAuthorizer;
                    }
                }
                Request withToken = object;
                return (Response)this.$next.invoke((Object)withToken);
            }
        };
    }

    public static final /* synthetic */ AccessTokens access$getAccessTokens$p(OAuthOfflineRequestAuthorizer $this) {
        return $this.accessTokens;
    }

    public static final /* synthetic */ ExpiringCredentials access$refresh(OAuthOfflineRequestAuthorizer $this, RefreshToken refreshToken2) {
        return $this.refresh(refreshToken2);
    }

    public static final /* synthetic */ Clock access$getClock$p(OAuthOfflineRequestAuthorizer $this) {
        return $this.clock;
    }

    public static final /* synthetic */ Duration access$getGracePeriod$p(OAuthOfflineRequestAuthorizer $this) {
        return $this.gracePeriod;
    }
}

