/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.ResultKt;
import dev.forkhandles.result4k.Success;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.security.ResponseType;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthRequestTracking;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.IdTokens;
import org.http4k.security.oauth.server.OAuthError;
import org.http4k.security.oauth.server.ResponseRender;
import org.http4k.security.oauth.server.UserRejectedRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004B)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0002H\u0096\u0002J&\u0010\u0010\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00022\b\b\u0002\u0010\u0014\u001a\u00020\u0003H\u0002J\u0014\u0010\u0015\u001a\u00020\u0011*\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/http4k/security/oauth/server/AuthenticationComplete;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "requestTracking", "Lorg/http4k/security/oauth/server/AuthRequestTracking;", "idTokens", "Lorg/http4k/security/oauth/server/IdTokens;", "documentationUri", "", "(Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AuthRequestTracking;Lorg/http4k/security/oauth/server/IdTokens;Ljava/lang/String;)V", "invoke", "request", "addResponseTypeValues", "Lorg/http4k/security/oauth/server/ResponseRender;", "authorizationRequest", "Lorg/http4k/security/oauth/server/AuthRequest;", "response", "addTo", "responseRender", "http4k-security-oauth"})
public final class AuthenticationComplete
implements Function1<Request, Response> {
    @NotNull
    private final AuthorizationCodes authorizationCodes;
    @NotNull
    private final AuthRequestTracking requestTracking;
    @NotNull
    private final IdTokens idTokens;
    @Nullable
    private final String documentationUri;

    public AuthenticationComplete(@NotNull AuthorizationCodes authorizationCodes, @NotNull AuthRequestTracking requestTracking, @NotNull IdTokens idTokens, @Nullable String documentationUri) {
        Intrinsics.checkNotNullParameter((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkNotNullParameter((Object)requestTracking, (String)"requestTracking");
        Intrinsics.checkNotNullParameter((Object)idTokens, (String)"idTokens");
        this.authorizationCodes = authorizationCodes;
        this.requestTracking = requestTracking;
        this.idTokens = idTokens;
        this.documentationUri = documentationUri;
    }

    public /* synthetic */ AuthenticationComplete(AuthorizationCodes authorizationCodes, AuthRequestTracking authRequestTracking, IdTokens idTokens, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        this(authorizationCodes, authRequestTracking, idTokens, string);
    }

    @NotNull
    public Response invoke(@NotNull Request request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        AuthRequest authRequest = this.requestTracking.resolveAuthRequest(request2);
        if (authRequest == null) {
            throw new IllegalStateException("Authorization request could not be found.".toString());
        }
        AuthRequest authorizationRequest = authRequest;
        return AuthenticationComplete.addResponseTypeValues$default(this, ResponseRender.Companion.forAuthRequest(authorizationRequest), authorizationRequest, request2, null, 4, null).withState(authorizationRequest.getState()).complete();
    }

    /*
     * WARNING - void declaration
     */
    private final ResponseRender addResponseTypeValues(ResponseRender $this$addResponseTypeValues, AuthRequest authorizationRequest, Request request2, Response response) {
        Result result;
        void $this$mapFailure$iv;
        Result result2;
        Object it;
        Result $this$addResponseTypeValues_u24lambda_u2d2 = this.authorizationCodes.create(request2, authorizationRequest, response);
        boolean bl = false;
        Result $this$map$iv = $this$addResponseTypeValues_u24lambda_u2d2;
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = $this$map$iv;
        boolean $i$f$flatMap = false;
        Result result3 = $this$flatMap$iv$iv;
        if (result3 instanceof Success) {
            ResponseRender responseRender;
            Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
            boolean bl2 = false;
            it = (AuthorizationCode)value$iv;
            boolean bl3 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[authorizationRequest.getResponseType().ordinal()]) {
                case 1: {
                    responseRender = $this$addResponseTypeValues.addParameter("code", ((AuthorizationCode)it).getValue());
                    break;
                }
                case 2: {
                    responseRender = $this$addResponseTypeValues.addParameter("code", ((AuthorizationCode)it).getValue()).addParameter("id_token", this.idTokens.createForAuthorization(request2, authorizationRequest, response, authorizationRequest.getNonce(), (AuthorizationCode)it).getValue());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            ResponseRender responseRender2 = responseRender;
            result2 = (Result)new Success((Object)responseRender2);
        } else if (result3 instanceof Failure) {
            result2 = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$map$iv = result2;
        boolean $i$f$mapFailure = false;
        void $this$flatMapFailure$iv$iv = $this$mapFailure$iv;
        boolean $i$f$flatMapFailure = false;
        result3 = $this$flatMapFailure$iv$iv;
        if (result3 instanceof Success) {
            result = $this$flatMapFailure$iv$iv;
        } else if (result3 instanceof Failure) {
            ResponseRender responseRender;
            Object reason$iv = ((Failure)$this$flatMapFailure$iv$iv).getReason();
            boolean bl4 = false;
            it = (UserRejectedRequest)reason$iv;
            boolean bl5 = false;
            ResponseRender responseRender3 = $this$addResponseTypeValues.addParameter("error", ((OAuthError)it).getRfcError().getRfcValue()).addParameter("error_description", ((OAuthError)it).getDescription());
            String string = this.documentationUri;
            if (string == null) {
                responseRender = responseRender3;
            } else {
                responseRender = this.addTo(string, responseRender3);
                if (responseRender == null) {
                    responseRender = responseRender3;
                }
            }
            ResponseRender responseRender4 = responseRender;
            result = (Result)new Failure((Object)responseRender4);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (ResponseRender)ResultKt.get((Result)result);
    }

    static /* synthetic */ ResponseRender addResponseTypeValues$default(AuthenticationComplete authenticationComplete, ResponseRender responseRender, AuthRequest authRequest, Request request2, Response response, int n, Object object) {
        if ((n & 4) != 0) {
            response = responseRender.complete();
        }
        return authenticationComplete.addResponseTypeValues(responseRender, authRequest, request2, response);
    }

    private final ResponseRender addTo(String $this$addTo, ResponseRender responseRender) {
        return responseRender.addParameter("error_uri", $this$addTo);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            nArray[ResponseType.Code.ordinal()] = 1;
            nArray[ResponseType.CodeIdToken.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

