/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.testing;

import dev.forkhandles.result4k.Success;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.oauth.server.AuthorizationCodeDetails;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/http4k/security/oauth/testing/InMemoryAuthorizationCodes;", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "clock", "Ljava/time/Clock;", "(Ljava/time/Clock;)V", "inFlightCodes", "", "Lorg/http4k/security/oauth/server/AuthorizationCode;", "Lorg/http4k/security/oauth/server/AuthorizationCodeDetails;", "create", "Ldev/forkhandles/result4k/Success;", "request", "Lorg/http4k/core/Request;", "authRequest", "Lorg/http4k/security/oauth/server/AuthRequest;", "response", "Lorg/http4k/core/Response;", "detailsFor", "code", "http4k-security-oauth"})
final class InMemoryAuthorizationCodes
implements AuthorizationCodes {
    @NotNull
    private final Clock clock;
    @NotNull
    private final Map<AuthorizationCode, AuthorizationCodeDetails> inFlightCodes;

    public InMemoryAuthorizationCodes(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        this.inFlightCodes = new LinkedHashMap();
    }

    @Override
    @NotNull
    public AuthorizationCodeDetails detailsFor(@NotNull AuthorizationCode code) {
        AuthorizationCodeDetails authorizationCodeDetails;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        AuthorizationCodeDetails authorizationCodeDetails2 = this.inFlightCodes.get(code);
        if (authorizationCodeDetails2 == null) {
            authorizationCodeDetails = null;
        } else {
            AuthorizationCodeDetails authorizationCodeDetails3;
            AuthorizationCodeDetails it = authorizationCodeDetails3 = authorizationCodeDetails2;
            boolean bl = false;
            this.inFlightCodes.remove(code);
            authorizationCodeDetails = authorizationCodeDetails3;
        }
        if (authorizationCodeDetails == null) {
            throw new IllegalStateException("code not stored".toString());
        }
        return authorizationCodeDetails;
    }

    @NotNull
    public Success<AuthorizationCode> create(@NotNull Request request2, @NotNull AuthRequest authRequest, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Object object = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"randomUUID().toString()");
        Object it = object = new AuthorizationCode((String)object);
        boolean bl = false;
        Map<AuthorizationCode, AuthorizationCodeDetails> map = this.inFlightCodes;
        ClientId clientId = authRequest.getClient();
        Uri uri = authRequest.getRedirectUri();
        Intrinsics.checkNotNull((Object)uri);
        Object object2 = this.clock.instant().plus(1L, ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"clock.instant().plus(1, ChronoUnit.DAYS)");
        object2 = new AuthorizationCodeDetails(clientId, uri, (Instant)object2, null, false, authRequest.getResponseType(), null, 64, null);
        map.put((AuthorizationCode)it, (AuthorizationCodeDetails)object2);
        Object object3 = object;
        return new Success(object3);
    }
}

