/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.ContentType;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.format.AutoMarshalling;
import org.http4k.lens.Header;
import org.http4k.security.oauth.server.InvalidClientCredentials;
import org.http4k.security.oauth.server.OAuthError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/http4k/security/oauth/server/JsonResponseErrorRenderer;", "", "json", "Lorg/http4k/format/AutoMarshalling;", "documentationUri", "", "(Lorg/http4k/format/AutoMarshalling;Ljava/lang/String;)V", "createResponse", "Lorg/http4k/core/Response;", "error", "Lorg/http4k/security/oauth/server/OAuthError;", "response", "ErrorResponse", "http4k-security-oauth"})
public final class JsonResponseErrorRenderer {
    @NotNull
    private final AutoMarshalling json;
    @Nullable
    private final String documentationUri;

    public JsonResponseErrorRenderer(@NotNull AutoMarshalling json, @Nullable String documentationUri) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.json = json;
        this.documentationUri = documentationUri;
    }

    public /* synthetic */ JsonResponseErrorRenderer(AutoMarshalling autoMarshalling, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(autoMarshalling, string);
    }

    @NotNull
    public final Response response(@NotNull OAuthError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return error instanceof InvalidClientCredentials ? this.createResponse(error, Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.UNAUTHORIZED, null, (int)2, null)) : this.createResponse(error, Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.BAD_REQUEST, null, (int)2, null));
    }

    private final Response createResponse(OAuthError error, Response response) {
        Function1[] function1Array = new Function1[]{Header.INSTANCE.getCONTENT_TYPE().of((Object)ContentType.Companion.getAPPLICATION_JSON())};
        return ((Response)HttpKt.with((HttpMessage)((HttpMessage)response), (Function1[])function1Array)).body(this.json.asFormatString((Object)new ErrorResponse(error.getRfcError().getRfcValue(), error.getDescription(), this.documentationUri)));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/http4k/security/oauth/server/JsonResponseErrorRenderer$ErrorResponse;", "", "error", "", "error_description", "error_uri", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "getError_description", "getError_uri", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "http4k-security-oauth"})
    private static final class ErrorResponse {
        @NotNull
        private final String error;
        @NotNull
        private final String error_description;
        @Nullable
        private final String error_uri;

        public ErrorResponse(@NotNull String error, @NotNull String error_description, @Nullable String error_uri) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter((Object)error_description, (String)"error_description");
            this.error = error;
            this.error_description = error_description;
            this.error_uri = error_uri;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }

        @NotNull
        public final String getError_description() {
            return this.error_description;
        }

        @Nullable
        public final String getError_uri() {
            return this.error_uri;
        }

        @NotNull
        public final String component1() {
            return this.error;
        }

        @NotNull
        public final String component2() {
            return this.error_description;
        }

        @Nullable
        public final String component3() {
            return this.error_uri;
        }

        @NotNull
        public final ErrorResponse copy(@NotNull String error, @NotNull String error_description, @Nullable String error_uri) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter((Object)error_description, (String)"error_description");
            return new ErrorResponse(error, error_description, error_uri);
        }

        public static /* synthetic */ ErrorResponse copy$default(ErrorResponse errorResponse, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = errorResponse.error;
            }
            if ((n & 2) != 0) {
                string2 = errorResponse.error_description;
            }
            if ((n & 4) != 0) {
                string3 = errorResponse.error_uri;
            }
            return errorResponse.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ErrorResponse(error=" + this.error + ", error_description=" + this.error_description + ", error_uri=" + this.error_uri + ')';
        }

        public int hashCode() {
            int result = this.error.hashCode();
            result = result * 31 + this.error_description.hashCode();
            result = result * 31 + (this.error_uri == null ? 0 : this.error_uri.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ErrorResponse)) {
                return false;
            }
            ErrorResponse errorResponse = (ErrorResponse)other;
            if (!Intrinsics.areEqual((Object)this.error, (Object)errorResponse.error)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.error_description, (Object)errorResponse.error_description)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error_uri, (Object)errorResponse.error_uri);
        }
    }
}

