/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.ResultKt;
import dev.forkhandles.result4k.Success;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.security.AccessTokenDetails;
import org.http4k.security.AccessTokenFetcher;
import org.http4k.security.CrossSiteRequestForgeryToken;
import org.http4k.security.FragmentParametersKt;
import org.http4k.security.Nonce;
import org.http4k.security.OAuthCallbackError;
import org.http4k.security.OAuthPersistence;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.openid.IdToken;
import org.http4k.security.openid.IdTokenConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004:\u0001'B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0011\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0002H\u0096\u0002J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J.\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J&\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001d0\r2\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0\r*\u00020\u0002H\u0002J\u0018\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\"0\r*\u00020\u0002H\u0002J\u0016\u0010$\u001a\u0004\u0018\u00010%*\u00020\u00022\u0006\u0010&\u001a\u00020%H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/http4k/security/OAuthCallback;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "oAuthPersistence", "Lorg/http4k/security/OAuthPersistence;", "idTokenConsumer", "Lorg/http4k/security/openid/IdTokenConsumer;", "accessTokenFetcher", "Lorg/http4k/security/AccessTokenFetcher;", "(Lorg/http4k/security/OAuthPersistence;Lorg/http4k/security/openid/IdTokenConsumer;Lorg/http4k/security/AccessTokenFetcher;)V", "consumeIdToken", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/security/AccessTokenDetails;", "Lorg/http4k/security/OAuthCallbackError$InvalidIdToken;", "tokenDetails", "Lorg/http4k/security/OAuthCallback$CallbackParameters;", "parameters", "fetchAccessToken", "Lorg/http4k/security/OAuthCallbackError$CouldNotFetchAccessToken;", "invoke", "request", "redirectionResponse", "validateCsrf", "Lorg/http4k/security/OAuthCallbackError$InvalidCsrfToken;", "persistedToken", "Lorg/http4k/security/CrossSiteRequestForgeryToken;", "validateNonce", "Lorg/http4k/security/OAuthCallbackError$InvalidNonce;", "storedNonce", "Lorg/http4k/security/Nonce;", "authorizationCode", "Lorg/http4k/security/oauth/server/AuthorizationCode;", "Lorg/http4k/security/OAuthCallbackError$AuthorizationCodeMissing;", "callbackParameters", "queryOrFragmentParameter", "", "name", "CallbackParameters", "http4k-security-oauth"})
public final class OAuthCallback
implements Function1<Request, Response> {
    @NotNull
    private final OAuthPersistence oAuthPersistence;
    @NotNull
    private final IdTokenConsumer idTokenConsumer;
    @NotNull
    private final AccessTokenFetcher accessTokenFetcher;

    public OAuthCallback(@NotNull OAuthPersistence oAuthPersistence, @NotNull IdTokenConsumer idTokenConsumer, @NotNull AccessTokenFetcher accessTokenFetcher) {
        Intrinsics.checkNotNullParameter((Object)oAuthPersistence, (String)"oAuthPersistence");
        Intrinsics.checkNotNullParameter((Object)idTokenConsumer, (String)"idTokenConsumer");
        Intrinsics.checkNotNullParameter((Object)accessTokenFetcher, (String)"accessTokenFetcher");
        this.oAuthPersistence = oAuthPersistence;
        this.idTokenConsumer = idTokenConsumer;
        this.accessTokenFetcher = accessTokenFetcher;
    }

    @NotNull
    public Response invoke(@NotNull Request request2) {
        Result result;
        Result result2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        CallbackParameters parameters;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Result $this$flatMap$iv = this.callbackParameters(request2);
        boolean $i$f$flatMap = false;
        Result result3 = $this$flatMap$iv;
        if (result3 instanceof Success) {
            parameters = (CallbackParameters)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            object5 = this.validateCsrf(parameters, request2, this.oAuthPersistence.retrieveCsrf(request2));
        } else if (result3 instanceof Failure) {
            object5 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$flatMap$iv = object5;
        $i$f$flatMap = false;
        result3 = $this$flatMap$iv;
        if (result3 instanceof Success) {
            parameters = (CallbackParameters)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            object4 = this.validateNonce(parameters, this.oAuthPersistence.retrieveNonce(request2));
        } else if (result3 instanceof Failure) {
            object4 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$flatMap$iv = object4;
        $i$f$flatMap = false;
        result3 = $this$flatMap$iv;
        if (result3 instanceof Success) {
            parameters = (CallbackParameters)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            object3 = this.consumeIdToken(parameters);
        } else if (result3 instanceof Failure) {
            object3 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$flatMap$iv = object3;
        $i$f$flatMap = false;
        result3 = $this$flatMap$iv;
        if (result3 instanceof Success) {
            parameters = (CallbackParameters)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            object2 = this.fetchAccessToken(parameters);
        } else if (result3 instanceof Failure) {
            object2 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$flatMap$iv = object2;
        $i$f$flatMap = false;
        result3 = $this$flatMap$iv;
        if (result3 instanceof Success) {
            AccessTokenDetails tokenDetails = (AccessTokenDetails)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            object = this.consumeIdToken(tokenDetails);
        } else if (result3 instanceof Failure) {
            object = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Result $this$map$iv = object;
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = $this$map$iv;
        boolean $i$f$flatMap2 = false;
        Result result4 = $this$flatMap$iv$iv;
        if (result4 instanceof Success) {
            Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            AccessTokenDetails tokenDetails = (AccessTokenDetails)value$iv;
            boolean bl2 = false;
            Response response = this.oAuthPersistence.assignToken(request2, this.redirectionResponse(request2), tokenDetails.getAccessToken(), tokenDetails.getIdToken());
            result2 = (Result)new Success((Object)response);
        } else if (result4 instanceof Failure) {
            result2 = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Result $this$mapFailure$iv = result2;
        boolean $i$f$mapFailure = false;
        Result $this$flatMapFailure$iv$iv = $this$mapFailure$iv;
        boolean $i$f$flatMapFailure = false;
        result4 = $this$flatMapFailure$iv$iv;
        if (result4 instanceof Success) {
            result = $this$flatMapFailure$iv$iv;
        } else if (result4 instanceof Failure) {
            Object reason$iv = ((Failure)$this$flatMapFailure$iv$iv).getReason();
            boolean bl = false;
            OAuthCallbackError it = (OAuthCallbackError)reason$iv;
            boolean bl3 = false;
            Response response = this.oAuthPersistence.authFailureResponse(it);
            result = (Result)new Failure((Object)response);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (Response)ResultKt.get(result);
    }

    private final Result<AccessTokenDetails, OAuthCallbackError.InvalidIdToken> consumeIdToken(AccessTokenDetails tokenDetails) {
        Result result;
        IdToken idToken2 = tokenDetails.getIdToken();
        if (idToken2 == null) {
            result = null;
        } else {
            IdToken idToken3 = idToken2;
            IdTokenConsumer idTokenConsumer = this.idTokenConsumer;
            IdToken p0 = idToken3;
            boolean bl = false;
            Result result2 = idTokenConsumer.consumeFromAccessTokenResponse(p0);
            if (result2 == null) {
                result = null;
            } else {
                Result $this$map$iv = result2;
                boolean $i$f$map = false;
                Result $this$flatMap$iv$iv = $this$map$iv;
                boolean $i$f$flatMap = false;
                Result result3 = $this$flatMap$iv$iv;
                if (result3 instanceof Success) {
                    Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
                    boolean bl2 = false;
                    Unit it = (Unit)value$iv;
                    boolean bl3 = false;
                    AccessTokenDetails accessTokenDetails = tokenDetails;
                    result = (Result)new Success((Object)accessTokenDetails);
                } else if (result3 instanceof Failure) {
                    result = $this$flatMap$iv$iv;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        Result result4 = result;
        return result4 == null ? (Result)new Success((Object)tokenDetails) : result4;
    }

    private final Result<CallbackParameters, OAuthCallbackError.InvalidIdToken> consumeIdToken(CallbackParameters parameters) {
        Result result;
        IdToken idToken2 = parameters.getIdToken();
        if (idToken2 == null) {
            result = null;
        } else {
            IdToken idToken3 = idToken2;
            IdTokenConsumer idTokenConsumer = this.idTokenConsumer;
            IdToken p0 = idToken3;
            boolean bl = false;
            Result result2 = idTokenConsumer.consumeFromAuthorizationResponse(p0);
            if (result2 == null) {
                result = null;
            } else {
                Result $this$map$iv = result2;
                boolean $i$f$map = false;
                Result $this$flatMap$iv$iv = $this$map$iv;
                boolean $i$f$flatMap = false;
                Result result3 = $this$flatMap$iv$iv;
                if (result3 instanceof Success) {
                    Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
                    boolean bl2 = false;
                    Unit it = (Unit)value$iv;
                    boolean bl3 = false;
                    CallbackParameters callbackParameters = parameters;
                    result = (Result)new Success((Object)callbackParameters);
                } else if (result3 instanceof Failure) {
                    result = $this$flatMap$iv$iv;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        Result result4 = result;
        return result4 == null ? (Result)new Success((Object)parameters) : result4;
    }

    private final Result<CallbackParameters, OAuthCallbackError.AuthorizationCodeMissing> callbackParameters(Request $this$callbackParameters) {
        Result result;
        Result $this$map$iv = this.authorizationCode($this$callbackParameters);
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = $this$map$iv;
        boolean $i$f$flatMap = false;
        Result result2 = $this$flatMap$iv$iv;
        if (result2 instanceof Success) {
            IdToken idToken2;
            String p0;
            AuthorizationCode authorizationCode;
            CrossSiteRequestForgeryToken crossSiteRequestForgeryToken;
            Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            AuthorizationCode it = (AuthorizationCode)value$iv;
            boolean bl2 = false;
            AuthorizationCode authorizationCode2 = it;
            String string = this.queryOrFragmentParameter($this$callbackParameters, "state");
            if (string == null) {
                crossSiteRequestForgeryToken = null;
            } else {
                String string2 = string;
                authorizationCode = authorizationCode2;
                boolean bl3 = false;
                crossSiteRequestForgeryToken = new CrossSiteRequestForgeryToken(p0);
                authorizationCode2 = authorizationCode;
            }
            String string3 = this.queryOrFragmentParameter($this$callbackParameters, "id_token");
            if (string3 == null) {
                idToken2 = null;
            } else {
                p0 = string3;
                CrossSiteRequestForgeryToken crossSiteRequestForgeryToken2 = crossSiteRequestForgeryToken;
                authorizationCode = authorizationCode2;
                boolean bl4 = false;
                IdToken idToken3 = new IdToken(p0);
                authorizationCode2 = authorizationCode;
                crossSiteRequestForgeryToken = crossSiteRequestForgeryToken2;
                idToken2 = idToken3;
            }
            IdToken idToken4 = idToken2;
            CrossSiteRequestForgeryToken crossSiteRequestForgeryToken3 = crossSiteRequestForgeryToken;
            AuthorizationCode authorizationCode3 = authorizationCode2;
            CallbackParameters callbackParameters = new CallbackParameters(authorizationCode3, crossSiteRequestForgeryToken3, idToken4);
            result = (Result)new Success((Object)callbackParameters);
        } else if (result2 instanceof Failure) {
            result = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    private final Result<AuthorizationCode, OAuthCallbackError.AuthorizationCodeMissing> authorizationCode(Request $this$authorizationCode) {
        Success success;
        String string = this.queryOrFragmentParameter($this$authorizationCode, "code");
        if (string == null) {
            success = null;
        } else {
            Object p0 = string;
            boolean bl = false;
            AuthorizationCode authorizationCode = new AuthorizationCode((String)p0);
            p0 = authorizationCode;
            boolean bl2 = false;
            success = new Success(p0);
        }
        Success success2 = success;
        return success2 == null ? (Result)new Failure((Object)OAuthCallbackError.AuthorizationCodeMissing.INSTANCE) : (Result)success2;
    }

    private final Result<CallbackParameters, OAuthCallbackError.InvalidCsrfToken> validateCsrf(CallbackParameters parameters, Request request2, CrossSiteRequestForgeryToken persistedToken) {
        Result result;
        CrossSiteRequestForgeryToken crossSiteRequestForgeryToken;
        String string = this.queryOrFragmentParameter(request2, "state");
        if (string == null) {
            crossSiteRequestForgeryToken = null;
        } else {
            String p0 = string;
            boolean bl = false;
            crossSiteRequestForgeryToken = new CrossSiteRequestForgeryToken(p0);
        }
        CrossSiteRequestForgeryToken it = crossSiteRequestForgeryToken;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)it, (Object)persistedToken)) {
            result = (Result)new Success((Object)parameters);
        } else {
            CrossSiteRequestForgeryToken crossSiteRequestForgeryToken2 = persistedToken;
            CrossSiteRequestForgeryToken crossSiteRequestForgeryToken3 = it;
            result = (Result)new Failure((Object)new OAuthCallbackError.InvalidCsrfToken((String)(crossSiteRequestForgeryToken2 == null ? null : crossSiteRequestForgeryToken2.getValue()), (String)(crossSiteRequestForgeryToken3 == null ? null : crossSiteRequestForgeryToken3.getValue())));
        }
        return result;
    }

    private final Result<CallbackParameters, OAuthCallbackError.InvalidNonce> validateNonce(CallbackParameters parameters, Nonce storedNonce) {
        Result result;
        IdToken idToken2 = parameters.getIdToken();
        if (idToken2 == null) {
            result = null;
        } else {
            IdToken idToken3 = idToken2;
            boolean bl = false;
            Nonce received = this.idTokenConsumer.nonceFromIdToken(idToken3);
            if (Intrinsics.areEqual((Object)received, (Object)storedNonce)) {
                result = (Result)new Success((Object)parameters);
            } else {
                Nonce nonce2 = storedNonce;
                Nonce nonce3 = received;
                result = (Result)new Failure((Object)new OAuthCallbackError.InvalidNonce((String)(nonce2 == null ? null : nonce2.getValue()), (String)(nonce3 == null ? null : nonce3.getValue())));
            }
        }
        Result result2 = result;
        return result2 == null ? (Result)new Success((Object)parameters) : result2;
    }

    private final Result<AccessTokenDetails, OAuthCallbackError.CouldNotFetchAccessToken> fetchAccessToken(CallbackParameters parameters) {
        return this.accessTokenFetcher.fetch(parameters.getCode().getValue());
    }

    private final Response redirectionResponse(Request request2) {
        String string;
        Response response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.TEMPORARY_REDIRECT, null, (int)2, null);
        Uri uri = this.oAuthPersistence.retrieveOriginalUri(request2);
        if (uri == null) {
            string = "/";
        } else {
            string = uri.toString();
            if (string == null) {
                string = "/";
            }
        }
        return response.header("Location", string);
    }

    private final String queryOrFragmentParameter(Request $this$queryOrFragmentParameter, String name) {
        String string = $this$queryOrFragmentParameter.query(name);
        if (string == null) {
            string = FragmentParametersKt.fragmentParameter($this$queryOrFragmentParameter, name);
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/http4k/security/OAuthCallback$CallbackParameters;", "", "code", "Lorg/http4k/security/oauth/server/AuthorizationCode;", "state", "Lorg/http4k/security/CrossSiteRequestForgeryToken;", "idToken", "Lorg/http4k/security/openid/IdToken;", "(Lorg/http4k/security/oauth/server/AuthorizationCode;Lorg/http4k/security/CrossSiteRequestForgeryToken;Lorg/http4k/security/openid/IdToken;)V", "getCode", "()Lorg/http4k/security/oauth/server/AuthorizationCode;", "getIdToken", "()Lorg/http4k/security/openid/IdToken;", "getState", "()Lorg/http4k/security/CrossSiteRequestForgeryToken;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "http4k-security-oauth"})
    private static final class CallbackParameters {
        @NotNull
        private final AuthorizationCode code;
        @Nullable
        private final CrossSiteRequestForgeryToken state;
        @Nullable
        private final IdToken idToken;

        public CallbackParameters(@NotNull AuthorizationCode code, @Nullable CrossSiteRequestForgeryToken state2, @Nullable IdToken idToken2) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            this.code = code;
            this.state = state2;
            this.idToken = idToken2;
        }

        @NotNull
        public final AuthorizationCode getCode() {
            return this.code;
        }

        @Nullable
        public final CrossSiteRequestForgeryToken getState() {
            return this.state;
        }

        @Nullable
        public final IdToken getIdToken() {
            return this.idToken;
        }

        @NotNull
        public final AuthorizationCode component1() {
            return this.code;
        }

        @Nullable
        public final CrossSiteRequestForgeryToken component2() {
            return this.state;
        }

        @Nullable
        public final IdToken component3() {
            return this.idToken;
        }

        @NotNull
        public final CallbackParameters copy(@NotNull AuthorizationCode code, @Nullable CrossSiteRequestForgeryToken state2, @Nullable IdToken idToken2) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return new CallbackParameters(code, state2, idToken2);
        }

        public static /* synthetic */ CallbackParameters copy$default(CallbackParameters callbackParameters, AuthorizationCode authorizationCode, CrossSiteRequestForgeryToken crossSiteRequestForgeryToken, IdToken idToken2, int n, Object object) {
            if ((n & 1) != 0) {
                authorizationCode = callbackParameters.code;
            }
            if ((n & 2) != 0) {
                crossSiteRequestForgeryToken = callbackParameters.state;
            }
            if ((n & 4) != 0) {
                idToken2 = callbackParameters.idToken;
            }
            return callbackParameters.copy(authorizationCode, crossSiteRequestForgeryToken, idToken2);
        }

        @NotNull
        public String toString() {
            return "CallbackParameters(code=" + this.code + ", state=" + this.state + ", idToken=" + this.idToken + ')';
        }

        public int hashCode() {
            int result = this.code.hashCode();
            result = result * 31 + (this.state == null ? 0 : this.state.hashCode());
            result = result * 31 + (this.idToken == null ? 0 : this.idToken.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CallbackParameters)) {
                return false;
            }
            CallbackParameters callbackParameters = (CallbackParameters)other;
            if (!Intrinsics.areEqual((Object)this.code, (Object)callbackParameters.code)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.state, (Object)callbackParameters.state)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.idToken, (Object)callbackParameters.idToken);
        }
    }
}

