/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server.request;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.http4k.core.Uri;
import org.http4k.security.Nonce;
import org.http4k.security.ResponseMode;
import org.http4k.security.ResponseType;
import org.http4k.security.State;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.InvalidRequestObject;
import org.http4k.security.oauth.server.OAuthServerMoshi;
import org.http4k.security.oauth.server.OAuthServerMoshiKt;
import org.http4k.security.oauth.server.request.Claim;
import org.http4k.security.oauth.server.request.Claims;
import org.http4k.security.oauth.server.request.RequestObject;
import org.http4k.security.oauth.server.request.RequestObjectExtractor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006H\u0002J\"\u0010\n\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007J\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007J(\u0010\u0010\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/http4k/security/oauth/server/request/RequestObjectExtractor;", "", "()V", "moshi", "Lorg/http4k/security/oauth/server/OAuthServerMoshi;", "asClaims", "", "", "Lorg/http4k/security/oauth/server/request/Claim;", "claims", "extractRequestJwtClaimsAsMap", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/security/oauth/server/InvalidRequestObject;", "value", "extractRequestObjectFromJwt", "Lorg/http4k/security/oauth/server/request/RequestObject;", "parseJsonFromJWT", "toAudience", "", "audience", "toClaims", "Lorg/http4k/security/oauth/server/request/Claims;", "http4k-security-oauth"})
public final class RequestObjectExtractor {
    @NotNull
    public static final RequestObjectExtractor INSTANCE = new RequestObjectExtractor();
    @NotNull
    private static final OAuthServerMoshi moshi = OAuthServerMoshi.INSTANCE;

    private RequestObjectExtractor() {
    }

    @NotNull
    public final Result<Map<?, ?>, InvalidRequestObject> extractRequestJwtClaimsAsMap(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.parseJsonFromJWT(value);
    }

    @NotNull
    public final Result<RequestObject, InvalidRequestObject> extractRequestObjectFromJwt(@NotNull String value) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Result $this$map$iv = this.parseJsonFromJWT(value);
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = $this$map$iv;
        boolean $i$f$flatMap = false;
        Result result2 = $this$flatMap$iv$iv;
        if (result2 instanceof Success) {
            String[] stringArray;
            Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            Map jsonFromJWT = (Map)value$iv;
            boolean bl2 = false;
            Map $this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0 = jsonFromJWT;
            boolean bl3 = false;
            ClientId clientId = (ClientId)OAuthServerMoshiKt.value($this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0, "client_id", extractRequestObjectFromJwt.1.1.1.INSTANCE);
            Uri uri = (Uri)OAuthServerMoshiKt.value($this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0, "redirect_uri", (Function1)new Function1<String, Uri>((Object)Uri.Companion){

                @NotNull
                public final Uri invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((Uri.Companion)this.receiver).of(p0);
                }
            });
            List<String> list = INSTANCE.toAudience($this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0.get("aud"));
            String string = OAuthServerMoshiKt.string($this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0, "iss");
            Object object = OAuthServerMoshiKt.string($this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0, "scope");
            if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{" "}), (boolean)false, (int)0, (int)6, null)) == null) {
                object = CollectionsKt.emptyList();
            }
            RequestObject requestObject = new RequestObject(clientId, uri, list, string, (List<String>)object, (ResponseMode)((Object)OAuthServerMoshiKt.value($this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0, "response_mode", (Function1)new Function1<String, ResponseMode>((Object)ResponseMode.Companion){

                @NotNull
                public final ResponseMode invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((ResponseMode.Companion)this.receiver).fromQueryParameterValue(p0);
                }
            })), (ResponseType)((Object)OAuthServerMoshiKt.value($this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0, "response_type", (Function1)new Function1<String, ResponseType>((Object)ResponseType.Companion){

                @NotNull
                public final ResponseType invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((ResponseType.Companion)this.receiver).fromQueryParameterValue(p0);
                }
            })), (State)OAuthServerMoshiKt.value($this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0, "state", extractRequestObjectFromJwt.1.1.5.INSTANCE), (Nonce)OAuthServerMoshiKt.value($this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0, "nonce", extractRequestObjectFromJwt.1.1.6.INSTANCE), OAuthServerMoshiKt.long($this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0, "max_age"), OAuthServerMoshiKt.long($this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0, "exp"), INSTANCE.toClaims($this$extractRequestObjectFromJwt_u24lambda_u2d1_u24lambda_u2d0.get("claims")));
            result = (Result)new Success((Object)requestObject);
        } else if (result2 instanceof Failure) {
            result = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    private final Claims toClaims(Object claims) {
        return claims instanceof Map ? new Claims(this.asClaims(OAuthServerMoshiKt.map((Map)claims, "userinfo")), this.asClaims(OAuthServerMoshiKt.map((Map)claims, "id_token"))) : new Claims(null, null, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Claim> asClaims(Map<String, ? extends Object> claims) {
        Map map;
        if (claims != null) {
            void $this$mapValuesTo$iv$iv;
            Map<String, ? extends Object> $this$mapValues$iv = claims;
            boolean $i$f$mapValues = false;
            Map<String, ? extends Object> map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                Map claim = (Map)v;
                Boolean bl3 = OAuthServerMoshiKt.boolean(claim, "essential");
                Claim claim2 = new Claim(bl3 != null ? bl3 : false, OAuthServerMoshiKt.string(claim, "value"), OAuthServerMoshiKt.strings(claim, "values"));
                map4.put(k, claim2);
            }
            map = destination$iv$iv;
        } else {
            map = null;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> toAudience(Object audience) {
        List list;
        Object object = audience;
        if (object instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)audience;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(String.valueOf(it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = object instanceof String ? CollectionsKt.listOf((Object)audience) : CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final Result<Map<String, Object>, InvalidRequestObject> parseJsonFromJWT(String value) {
        Result result;
        try {
            Result result2;
            String[] stringArray = new String[]{"."};
            List jwtParts = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (jwtParts.size() != 3) {
                result2 = (Result)new Failure((Object)InvalidRequestObject.INSTANCE);
            } else {
                void input$iv;
                void this_$iv;
                stringArray = (String[])moshi;
                byte[] byArray = Base64.getUrlDecoder().decode((String)jwtParts.get(1));
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getUrlDecoder().decode(jwtParts[1])");
                Object object = byArray;
                object = new String((byte[])object, Charsets.UTF_8);
                boolean $i$f$stringAsA = false;
                result2 = (Result)new Success(this_$iv.asA((String)input$iv, Reflection.getOrCreateKotlinClass(Map.class)));
            }
            result = result2;
        }
        catch (Exception e) {
            result = (Result)new Failure((Object)InvalidRequestObject.INSTANCE);
        }
        return result;
    }
}

