/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security;

import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.core.cookie.Cookie;
import org.http4k.core.cookie.CookieExtensionsKt;
import org.http4k.security.AccessToken;
import org.http4k.security.CrossSiteRequestForgeryToken;
import org.http4k.security.Nonce;
import org.http4k.security.OAuthCallbackError;
import org.http4k.security.OAuthPersistence;
import org.http4k.security.openid.IdToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J*\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/http4k/security/InsecureCookieBasedOAuthPersistence;", "Lorg/http4k/security/OAuthPersistence;", "cookieNamePrefix", "", "cookieValidity", "Ljava/time/Duration;", "clock", "Ljava/time/Clock;", "(Ljava/lang/String;Ljava/time/Duration;Ljava/time/Clock;)V", "accessTokenCookieName", "csrfName", "nonceName", "originalUriName", "assignCsrf", "Lorg/http4k/core/Response;", "redirect", "csrf", "Lorg/http4k/security/CrossSiteRequestForgeryToken;", "assignNonce", "nonce", "Lorg/http4k/security/Nonce;", "assignOriginalUri", "originalUri", "Lorg/http4k/core/Uri;", "assignToken", "request", "Lorg/http4k/core/Request;", "accessToken", "Lorg/http4k/security/AccessToken;", "idToken", "Lorg/http4k/security/openid/IdToken;", "authFailureResponse", "reason", "Lorg/http4k/security/OAuthCallbackError;", "expiring", "Lorg/http4k/core/cookie/Cookie;", "name", "value", "retrieveCsrf", "retrieveNonce", "retrieveOriginalUri", "retrieveToken", "http4k-security-oauth"})
public final class InsecureCookieBasedOAuthPersistence
implements OAuthPersistence {
    @NotNull
    private final Duration cookieValidity;
    @NotNull
    private final Clock clock;
    @NotNull
    private final String csrfName;
    @NotNull
    private final String nonceName;
    @NotNull
    private final String originalUriName;
    @NotNull
    private final String accessTokenCookieName;

    public InsecureCookieBasedOAuthPersistence(@NotNull String cookieNamePrefix, @NotNull Duration cookieValidity, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)cookieNamePrefix, (String)"cookieNamePrefix");
        Intrinsics.checkNotNullParameter((Object)cookieValidity, (String)"cookieValidity");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.cookieValidity = cookieValidity;
        this.clock = clock;
        this.csrfName = cookieNamePrefix + "Csrf";
        this.nonceName = cookieNamePrefix + "Nonce";
        this.originalUriName = cookieNamePrefix + "OriginalUri";
        this.accessTokenCookieName = cookieNamePrefix + "AccessToken";
    }

    public /* synthetic */ InsecureCookieBasedOAuthPersistence(String string, Duration duration, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofDays(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofDays(1)");
            duration = duration2;
        }
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        this(string, duration, clock);
    }

    @Override
    @Nullable
    public CrossSiteRequestForgeryToken retrieveCsrf(@NotNull Request request2) {
        CrossSiteRequestForgeryToken crossSiteRequestForgeryToken;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request2, (String)this.csrfName);
        if (object != null && (object = object.getValue()) != null) {
            Object p0 = object;
            boolean bl = false;
            crossSiteRequestForgeryToken = new CrossSiteRequestForgeryToken((String)p0);
        } else {
            crossSiteRequestForgeryToken = null;
        }
        return crossSiteRequestForgeryToken;
    }

    @Override
    @Nullable
    public AccessToken retrieveToken(@NotNull Request request2) {
        AccessToken accessToken;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request2, (String)this.accessTokenCookieName);
        if (object != null && (object = object.getValue()) != null) {
            Object it = object;
            boolean bl = false;
            accessToken = new AccessToken((String)it, null, null, null, null, 30, null);
        } else {
            accessToken = null;
        }
        return accessToken;
    }

    @Override
    @Nullable
    public Nonce retrieveNonce(@NotNull Request request2) {
        Nonce nonce2;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request2, (String)this.nonceName);
        if (object != null && (object = object.getValue()) != null) {
            Object it = object;
            boolean bl = false;
            nonce2 = new Nonce((String)it);
        } else {
            nonce2 = null;
        }
        return nonce2;
    }

    @Override
    @Nullable
    public Uri retrieveOriginalUri(@NotNull Request request2) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request2, (String)this.originalUriName);
        if (object != null && (object = object.getValue()) != null) {
            Object it = object;
            boolean bl = false;
            uri = Uri.Companion.of((String)it);
        } else {
            uri = null;
        }
        return uri;
    }

    @Override
    @NotNull
    public Response assignCsrf(@NotNull Response redirect, @NotNull CrossSiteRequestForgeryToken csrf) {
        Intrinsics.checkNotNullParameter((Object)redirect, (String)"redirect");
        Intrinsics.checkNotNullParameter((Object)csrf, (String)"csrf");
        return CookieExtensionsKt.cookie((Response)redirect, (Cookie)this.expiring(this.csrfName, csrf.getValue()));
    }

    @Override
    @NotNull
    public Response assignToken(@NotNull Request request2, @NotNull Response redirect, @NotNull AccessToken accessToken, @Nullable IdToken idToken2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)redirect, (String)"redirect");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        return CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.cookie((Response)redirect, (Cookie)this.expiring(this.accessTokenCookieName, accessToken.getValue())), (String)this.csrfName, null, (int)2, null), (String)this.nonceName, null, (int)2, null), (String)this.originalUriName, null, (int)2, null);
    }

    @Override
    @NotNull
    public Response assignNonce(@NotNull Response redirect, @NotNull Nonce nonce2) {
        Intrinsics.checkNotNullParameter((Object)redirect, (String)"redirect");
        Intrinsics.checkNotNullParameter((Object)nonce2, (String)"nonce");
        return CookieExtensionsKt.cookie((Response)redirect, (Cookie)this.expiring(this.nonceName, nonce2.getValue()));
    }

    @Override
    @NotNull
    public Response assignOriginalUri(@NotNull Response redirect, @NotNull Uri originalUri) {
        Intrinsics.checkNotNullParameter((Object)redirect, (String)"redirect");
        Intrinsics.checkNotNullParameter((Object)originalUri, (String)"originalUri");
        return CookieExtensionsKt.cookie((Response)redirect, (Cookie)this.expiring(this.originalUriName, originalUri.toString()));
    }

    @Override
    @NotNull
    public Response authFailureResponse(@NotNull OAuthCallbackError reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.FORBIDDEN, null, (int)2, null), (String)this.csrfName, null, (int)2, null), (String)this.accessTokenCookieName, null, (int)2, null), (String)this.nonceName, null, (int)2, null), (String)this.originalUriName, null, (int)2, null);
    }

    private final Cookie expiring(String name, String value) {
        return new Cookie(name, value, null, this.clock.instant().plus(this.cookieValidity), null, "/", false, false, null, 468, null);
    }
}

