/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthoriseRequestValidator;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.ClientValidator;
import org.http4k.security.oauth.server.InvalidClientId;
import org.http4k.security.oauth.server.InvalidRedirectUri;
import org.http4k.security.oauth.server.InvalidScopes;
import org.http4k.security.oauth.server.OAuthError;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/http4k/security/oauth/server/SimpleAuthoriseRequestValidator;", "Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;", "clientValidator", "Lorg/http4k/security/oauth/server/ClientValidator;", "(Lorg/http4k/security/oauth/server/ClientValidator;)V", "isValidClientAndRedirectUriInCaseOfError", "", "request", "Lorg/http4k/core/Request;", "clientId", "Lorg/http4k/security/oauth/server/ClientId;", "redirectUri", "Lorg/http4k/core/Uri;", "validate", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/security/oauth/server/OAuthError;", "authorizationRequest", "Lorg/http4k/security/oauth/server/AuthRequest;", "http4k-security-oauth"})
public final class SimpleAuthoriseRequestValidator
implements AuthoriseRequestValidator {
    @NotNull
    private final ClientValidator clientValidator;

    public SimpleAuthoriseRequestValidator(@NotNull ClientValidator clientValidator) {
        Intrinsics.checkNotNullParameter((Object)clientValidator, (String)"clientValidator");
        this.clientValidator = clientValidator;
    }

    @Override
    public boolean isValidClientAndRedirectUriInCaseOfError(@NotNull Request request2, @NotNull ClientId clientId, @NotNull Uri redirectUri) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        return this.clientValidator.validateRedirection(request2, clientId, redirectUri);
    }

    @Override
    @NotNull
    public Result<Request, OAuthError> validate(@NotNull Request request2, @NotNull AuthRequest authorizationRequest) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)authorizationRequest, (String)"authorizationRequest");
        if (!this.clientValidator.validateClientId(request2, authorizationRequest.getClient())) {
            result = (Result)new Failure((Object)InvalidClientId.INSTANCE);
        } else {
            ClientId clientId = authorizationRequest.getClient();
            Uri uri = authorizationRequest.getRedirectUri();
            Intrinsics.checkNotNull((Object)uri);
            result = !this.clientValidator.validateRedirection(request2, clientId, uri) ? (Result)new Failure((Object)InvalidRedirectUri.INSTANCE) : (!this.clientValidator.validateScopes(request2, authorizationRequest.getClient(), authorizationRequest.getScopes()) ? (Result)new Failure((Object)InvalidScopes.INSTANCE) : (Result)new Success((Object)request2));
        }
        return result;
    }
}

