/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.security.AccessToken;
import org.http4k.security.CrossSiteRequestForgeryToken;
import org.http4k.security.Nonce;
import org.http4k.security.OAuthCallbackError;
import org.http4k.security.openid.IdToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH&J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH&J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH&J,\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H&J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H&R\u000f\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a8\u0006\u001d"}, d2={"Lorg/http4k/security/OAuthPersistence;", "", "description", "", "Lorg/http4k/security/OAuthCallbackError;", "assignCsrf", "Lorg/http4k/core/Response;", "redirect", "csrf", "Lorg/http4k/security/CrossSiteRequestForgeryToken;", "assignNonce", "nonce", "Lorg/http4k/security/Nonce;", "assignOriginalUri", "originalUri", "Lorg/http4k/core/Uri;", "assignToken", "request", "Lorg/http4k/core/Request;", "accessToken", "Lorg/http4k/security/AccessToken;", "idToken", "Lorg/http4k/security/openid/IdToken;", "authFailureResponse", "reason", "retrieveCsrf", "retrieveNonce", "retrieveOriginalUri", "retrieveToken", "http4k-security-oauth"})
public interface OAuthPersistence {
    @NotNull
    public Response assignCsrf(@NotNull Response var1, @NotNull CrossSiteRequestForgeryToken var2);

    @Nullable
    public CrossSiteRequestForgeryToken retrieveCsrf(@NotNull Request var1);

    @NotNull
    public Response assignNonce(@NotNull Response var1, @NotNull Nonce var2);

    @Nullable
    public Nonce retrieveNonce(@NotNull Request var1);

    @NotNull
    public Response assignOriginalUri(@NotNull Response var1, @NotNull Uri var2);

    @Nullable
    public Uri retrieveOriginalUri(@NotNull Request var1);

    @NotNull
    public Response assignToken(@NotNull Request var1, @NotNull Response var2, @NotNull AccessToken var3, @Nullable IdToken var4);

    @Nullable
    public AccessToken retrieveToken(@NotNull Request var1);

    @NotNull
    public Response authFailureResponse(@NotNull OAuthCallbackError var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ Response assignToken$default(OAuthPersistence oAuthPersistence, Request request2, Response response, AccessToken accessToken, IdToken idToken2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assignToken");
            }
            if ((n & 8) != 0) {
                idToken2 = null;
            }
            return oAuthPersistence.assignToken(request2, response, accessToken, idToken2);
        }

        @NotNull
        public static Response authFailureResponse(@NotNull OAuthPersistence $this, @NotNull OAuthCallbackError reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.FORBIDDEN.description(DefaultImpls.getDescription($this, reason)), null, (int)2, null);
        }

        private static String getDescription(OAuthPersistence $this, OAuthCallbackError $receiver) {
            String string;
            OAuthCallbackError oAuthCallbackError = $receiver;
            if (oAuthCallbackError instanceof OAuthCallbackError.AuthorizationCodeMissing) {
                string = "Authorization code missing";
            } else if (oAuthCallbackError instanceof OAuthCallbackError.CouldNotFetchAccessToken) {
                string = "Failed to fetch access token (status: " + ((OAuthCallbackError.CouldNotFetchAccessToken)$receiver).getStatus() + ')';
            } else if (oAuthCallbackError instanceof OAuthCallbackError.InvalidCsrfToken) {
                string = "Invalid state (expected: " + ((OAuthCallbackError.InvalidCsrfToken)$receiver).getExpected() + ", received: " + ((OAuthCallbackError.InvalidCsrfToken)$receiver).getReceived() + ')';
            } else if (oAuthCallbackError instanceof OAuthCallbackError.InvalidNonce) {
                string = "Invalid nonce (expected: " + ((OAuthCallbackError.InvalidNonce)$receiver).getExpected() + ", received: " + ((OAuthCallbackError.InvalidNonce)$receiver).getReceived() + ')';
            } else if (oAuthCallbackError instanceof OAuthCallbackError.InvalidAccessToken) {
                string = "Invalid access token: " + ((OAuthCallbackError.InvalidAccessToken)$receiver).getReason();
            } else if (oAuthCallbackError instanceof OAuthCallbackError.InvalidIdToken) {
                string = "Invalid id token: " + ((OAuthCallbackError.InvalidIdToken)$receiver).getReason();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }
    }
}

