/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.client;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.security.AccessToken;
import org.http4k.security.AccessTokenDetails;
import org.http4k.security.AccessTokenExtractor;
import org.http4k.security.ContentTypeJsonOrForm;
import org.http4k.security.ExpiringCredentials;
import org.http4k.security.OAuthProviderConfig;
import org.http4k.security.oauth.client.AccessTokens;
import org.http4k.security.oauth.client.TokenRequest;
import org.http4k.security.oauth.client.TokenRequestKt;
import org.http4k.security.oauth.core.RefreshToken;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001Bb\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012%\u0010\u0006\u001a!\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007j\u0002`\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0017\u001a!\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007j\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/http4k/security/oauth/client/OAuthOfflineRequestAuthorizer;", "", "config", "Lorg/http4k/security/OAuthProviderConfig;", "accessTokens", "Lorg/http4k/security/oauth/client/AccessTokens;", "backend", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "authRequestFilter", "Lorg/http4k/core/Filter;", "gracePeriod", "Ljava/time/Duration;", "clock", "Ljava/time/Clock;", "accessTokenExtractor", "Lorg/http4k/security/AccessTokenExtractor;", "(Lorg/http4k/security/OAuthProviderConfig;Lorg/http4k/security/oauth/client/AccessTokens;Lkotlin/jvm/functions/Function1;Lorg/http4k/core/Filter;Ljava/time/Duration;Ljava/time/Clock;Lorg/http4k/security/AccessTokenExtractor;)V", "authClient", "refresh", "Lorg/http4k/security/ExpiringCredentials;", "Lorg/http4k/security/AccessToken;", "refreshToken", "Lorg/http4k/security/oauth/core/RefreshToken;", "toFilter", "http4k-security-oauth"})
@SourceDebugExtension(value={"SMAP\nOAuthOfflineRequestAuthorizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuthOfflineRequestAuthorizer.kt\norg/http4k/security/oauth/client/OAuthOfflineRequestAuthorizer\n+ 2 result.kt\ndev/forkhandles/result4k/ResultKt\n*L\n1#1,60:1\n71#2,4:61\n*S KotlinDebug\n*F\n+ 1 OAuthOfflineRequestAuthorizer.kt\norg/http4k/security/oauth/client/OAuthOfflineRequestAuthorizer\n*L\n39#1:61,4\n*E\n"})
public final class OAuthOfflineRequestAuthorizer {
    @NotNull
    private final OAuthProviderConfig config;
    @NotNull
    private final AccessTokens accessTokens;
    @NotNull
    private final Duration gracePeriod;
    @NotNull
    private final Clock clock;
    @NotNull
    private final AccessTokenExtractor accessTokenExtractor;
    @NotNull
    private final Function1<Request, Response> authClient;

    public OAuthOfflineRequestAuthorizer(@NotNull OAuthProviderConfig config, @NotNull AccessTokens accessTokens, @NotNull Function1<? super Request, ? extends Response> backend, @NotNull Filter authRequestFilter, @NotNull Duration gracePeriod, @NotNull Clock clock, @NotNull AccessTokenExtractor accessTokenExtractor) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkNotNullParameter(backend, (String)"backend");
        Intrinsics.checkNotNullParameter((Object)authRequestFilter, (String)"authRequestFilter");
        Intrinsics.checkNotNullParameter((Object)gracePeriod, (String)"gracePeriod");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)accessTokenExtractor, (String)"accessTokenExtractor");
        this.config = config;
        this.accessTokens = accessTokens;
        this.gracePeriod = gracePeriod;
        this.clock = clock;
        this.accessTokenExtractor = accessTokenExtractor;
        this.authClient = Http4kKt.then((Filter)authRequestFilter, backend);
    }

    public /* synthetic */ OAuthOfflineRequestAuthorizer(OAuthProviderConfig oAuthProviderConfig, AccessTokens accessTokens, Function1 function1, Filter filter, Duration duration, Clock clock, AccessTokenExtractor accessTokenExtractor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            Duration duration2 = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(10)");
            duration = duration2;
        }
        if ((n & 0x20) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        if ((n & 0x40) != 0) {
            accessTokenExtractor = new ContentTypeJsonOrForm();
        }
        this(oAuthProviderConfig, accessTokens, (Function1<? super Request, ? extends Response>)function1, filter, duration, clock, accessTokenExtractor);
    }

    private final ExpiringCredentials<AccessToken> refresh(RefreshToken refreshToken2) {
        TokenRequest body = TokenRequest.Companion.refreshToken(refreshToken2);
        Function1[] function1Array = new Function1[]{TokenRequestKt.getTokenRequestLens().of((Object)body)};
        Request request2 = (Request)HttpKt.with((HttpMessage)((HttpMessage)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.POST, (Uri)this.config.getTokenUri(), null, (int)4, null)), (Function1[])function1Array);
        Response response = (Response)this.authClient.invoke((Object)request2);
        if (!response.getStatus().getSuccessful()) {
            return null;
        }
        Result $this$onFailure$iv = (Result)this.accessTokenExtractor.invoke(response);
        boolean $i$f$onFailure = false;
        Result result = $this$onFailure$iv;
        if (!(result instanceof Success)) {
            if (result instanceof Failure) {
                Failure it = (Failure)$this$onFailure$iv;
                boolean bl = false;
                return null;
            }
            throw new NoWhenBranchMatchedException();
        }
        AccessToken accessToken = ((AccessTokenDetails)((Success)$this$onFailure$iv).getValue()).getAccessToken();
        Long l = accessToken.getExpiresIn();
        Instant instant = this.clock.instant().plusSeconds(l != null ? l : Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant().plusSeco\u2026iresIn ?: Long.MAX_VALUE)");
        return new ExpiringCredentials((Object)accessToken, instant);
    }

    @NotNull
    public final Filter toFilter(@NotNull RefreshToken refreshToken2) {
        Intrinsics.checkNotNullParameter((Object)refreshToken2, (String)"refreshToken");
        return arg_0 -> OAuthOfflineRequestAuthorizer.toFilter$lambda$1(this, refreshToken2, arg_0);
    }

    private static final Function1 toFilter$lambda$1(OAuthOfflineRequestAuthorizer this$0, RefreshToken $refreshToken, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$refreshToken, (String)"$refreshToken");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return (Function1)new Function1<Request, Response>(this$0, $refreshToken, (Function1<? super Request, ? extends Response>)next){
            final /* synthetic */ OAuthOfflineRequestAuthorizer this$0;
            final /* synthetic */ RefreshToken $refreshToken;
            final /* synthetic */ Function1<Request, Response> $next;
            {
                this.this$0 = $receiver;
                this.$refreshToken = $refreshToken;
                this.$next = $next;
                super(1);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @NotNull
            public final Response invoke(@NotNull Request request) {
                block9: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                        var3_2 = OAuthOfflineRequestAuthorizer.access$getAccessTokens$p(this.this$0).get(this.$refreshToken);
                        if (var3_2 == null) ** GOTO lbl-1000
                        var5_3 = var3_2;
                        var6_4 = this.this$0;
                        it = var5_3;
                        $i$a$-takeIf-OAuthOfflineRequestAuthorizer$toFilter$1$1$tokenData$1 = false;
                        v0 /* !! */  = var4_8 = Duration.between(OAuthOfflineRequestAuthorizer.access$getClock$p(var6_4).instant(), it.getExpiry()).compareTo(OAuthOfflineRequestAuthorizer.access$getGracePeriod$p(var6_4)) > 0 != false ? var5_3 : null;
                        if (var4_8 != null) {
                            v1 = var4_8;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = OAuthOfflineRequestAuthorizer.access$refresh(this.this$0, this.$refreshToken);
                            if (v2 != null) {
                                var6_4 = v2;
                                it = this.this$0;
                                $i$a$-takeIf-OAuthOfflineRequestAuthorizer$toFilter$1$1$tokenData$1 = this.$refreshToken;
                                it = var6_4;
                                $i$a$-also-OAuthOfflineRequestAuthorizer$toFilter$1$1$tokenData$2 = false;
                                OAuthOfflineRequestAuthorizer.access$getAccessTokens$p((OAuthOfflineRequestAuthorizer)it).set($i$a$-takeIf-OAuthOfflineRequestAuthorizer$toFilter$1$1$tokenData$1, (ExpiringCredentials<AccessToken>)it);
                                v1 = var6_4;
                            } else {
                                v1 = null;
                            }
                        }
                        if ((v3 = (tokenData = v1)) == null || (v3 = (AccessToken)v3.getCredentials()) == null) break block8;
                        it = v3;
                        $i$a$-let-OAuthOfflineRequestAuthorizer$toFilter$1$1$withToken$1 = false;
                        v4 = new StringBuilder();
                        v5 = it.getType();
                        if (v5 == null) {
                            v5 = "Bearer";
                        }
                        v6 = request.header("Authorization", v4.append(v5).append(' ').append(it.getValue()).toString());
                        v3 = v6;
                        if (v6 != null) break block9;
                    }
                    v3 = request;
                }
                withToken = v3;
                return (Response)this.$next.invoke(withToken);
            }
        };
    }

    public static final /* synthetic */ AccessTokens access$getAccessTokens$p(OAuthOfflineRequestAuthorizer $this) {
        return $this.accessTokens;
    }

    public static final /* synthetic */ ExpiringCredentials access$refresh(OAuthOfflineRequestAuthorizer $this, RefreshToken refreshToken2) {
        return $this.refresh(refreshToken2);
    }

    public static final /* synthetic */ Clock access$getClock$p(OAuthOfflineRequestAuthorizer $this) {
        return $this.clock;
    }

    public static final /* synthetic */ Duration access$getGracePeriod$p(OAuthOfflineRequestAuthorizer $this) {
        return $this.gracePeriod;
    }
}

