/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.core.cookie.Cookie;
import org.http4k.core.cookie.CookieExtensionsKt;
import org.http4k.lens.BiDiLens;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthRequestTracking;
import org.http4k.security.oauth.server.OAuthServer;
import org.http4k.security.oauth.server.OAuthServerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\u000e\u001a\u00020\u0005*\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/http4k/security/oauth/server/InsecureCookieBasedAuthRequestTracking;", "Lorg/http4k/security/oauth/server/AuthRequestTracking;", "<init>", "()V", "cookieName", "", "trackAuthRequest", "Lorg/http4k/core/Response;", "request", "Lorg/http4k/core/Request;", "authRequest", "Lorg/http4k/security/oauth/server/AuthRequest;", "response", "resolveAuthRequest", "serialise", "http4k-security-oauth"})
@SourceDebugExtension(value={"SMAP\nInsecureCookieBasedAuthRequestTracking.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsecureCookieBasedAuthRequestTracking.kt\norg/http4k/security/oauth/server/InsecureCookieBasedAuthRequestTracking\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,30:1\n1#2:31\n*E\n"})
public final class InsecureCookieBasedAuthRequestTracking
implements AuthRequestTracking {
    @NotNull
    private final String cookieName;

    public InsecureCookieBasedAuthRequestTracking() {
        this.cookieName = "OauthFlowId";
    }

    @Override
    @NotNull
    public Response trackAuthRequest(@NotNull Request request2, @NotNull AuthRequest authRequest, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return CookieExtensionsKt.cookie((Response)response, (Cookie)new Cookie(this.cookieName, this.serialise(authRequest), null, null, null, null, false, false, null, 508, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public AuthRequest resolveAuthRequest(@NotNull Request request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Cookie cookie = CookieExtensionsKt.cookie((Request)request2, (String)this.cookieName);
        if (cookie == null) return null;
        String string = cookie.getValue();
        if (string == null) return null;
        String it = string;
        boolean bl = false;
        Request request3 = Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.GET, (Uri)Uri.Companion.of("dummy").query(it), null, (int)4, null);
        if (request3 == null) return null;
        AuthRequest authRequest = OAuthServerKt.authorizationRequest(request3);
        return authRequest;
    }

    private final String serialise(AuthRequest $this$serialise) {
        Function1[] function1Array = new Function1[]{OAuthServer.Companion.getClientIdQueryParameter().of((Object)$this$serialise.getClient())};
        HttpMessage httpMessage = HttpKt.with((HttpMessage)((HttpMessage)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.GET, (String)"dummy", null, (int)4, null)), (Function1[])function1Array);
        function1Array = new Function1[1];
        BiDiLens<Request, Uri> biDiLens = OAuthServer.Companion.getRedirectUriQueryParameter();
        Uri uri = $this$serialise.getRedirectUri();
        Intrinsics.checkNotNull((Object)uri);
        function1Array[0] = biDiLens.of((Object)uri);
        HttpMessage httpMessage2 = HttpKt.with((HttpMessage)httpMessage, (Function1[])function1Array);
        function1Array = new Function1[]{OAuthServer.Companion.getScopesQueryParameter().of($this$serialise.getScopes())};
        HttpMessage httpMessage3 = HttpKt.with((HttpMessage)httpMessage2, (Function1[])function1Array);
        function1Array = new Function1[]{OAuthServer.Companion.getState().of((Object)$this$serialise.getState())};
        HttpMessage httpMessage4 = HttpKt.with((HttpMessage)httpMessage3, (Function1[])function1Array);
        function1Array = new Function1[]{OAuthServer.Companion.getResponseType().of((Object)$this$serialise.getResponseType())};
        HttpMessage httpMessage5 = HttpKt.with((HttpMessage)httpMessage4, (Function1[])function1Array);
        function1Array = new Function1[]{OAuthServer.Companion.getResponseMode().of((Object)$this$serialise.getResponseMode())};
        return ((Request)HttpKt.with((HttpMessage)httpMessage5, (Function1[])function1Array)).getUri().getQuery();
    }
}

