/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.testing;

import dev.forkhandles.result4k.Success;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.oauth.server.AuthorizationCodeDetails;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\bH\u0016J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/http4k/security/oauth/testing/InMemoryAuthorizationCodes;", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/time/Clock;)V", "inFlightCodes", "", "Lorg/http4k/security/oauth/server/AuthorizationCode;", "Lorg/http4k/security/oauth/server/AuthorizationCodeDetails;", "detailsFor", "code", "create", "Ldev/forkhandles/result4k/Success;", "request", "Lorg/http4k/core/Request;", "authRequest", "Lorg/http4k/security/oauth/server/AuthRequest;", "response", "Lorg/http4k/core/Response;", "http4k-security-oauth"})
@SourceDebugExtension(value={"SMAP\nFakeOAuthServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeOAuthServer.kt\norg/http4k/security/oauth/testing/InMemoryAuthorizationCodes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
final class InMemoryAuthorizationCodes
implements AuthorizationCodes {
    @NotNull
    private final Clock clock;
    @NotNull
    private final Map<AuthorizationCode, AuthorizationCodeDetails> inFlightCodes;

    public InMemoryAuthorizationCodes(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        this.inFlightCodes = new LinkedHashMap();
    }

    @Override
    @NotNull
    public AuthorizationCodeDetails detailsFor(@NotNull AuthorizationCode code) {
        AuthorizationCodeDetails authorizationCodeDetails;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        AuthorizationCodeDetails authorizationCodeDetails2 = this.inFlightCodes.get(code);
        if (authorizationCodeDetails2 == null) {
            throw new IllegalStateException("code not stored".toString());
        }
        AuthorizationCodeDetails it = authorizationCodeDetails = authorizationCodeDetails2;
        boolean bl = false;
        this.inFlightCodes.remove(code);
        return authorizationCodeDetails;
    }

    @NotNull
    public Success<AuthorizationCode> create(@NotNull Request request2, @NotNull AuthRequest authRequest, @NotNull Response response) {
        AuthorizationCode authorizationCode;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        AuthorizationCode it = authorizationCode = new AuthorizationCode(string);
        boolean bl = false;
        Map<AuthorizationCode, AuthorizationCodeDetails> map = this.inFlightCodes;
        ClientId clientId = authRequest.getClient();
        Uri uri = authRequest.getRedirectUri();
        Intrinsics.checkNotNull((Object)uri);
        Instant instant = this.clock.instant().plus(1L, ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
        AuthorizationCodeDetails authorizationCodeDetails = new AuthorizationCodeDetails(clientId, uri, instant, null, false, authRequest.getResponseType(), null, 64, null);
        map.put(it, authorizationCodeDetails);
        AuthorizationCode authorizationCode2 = authorizationCode;
        return new Success((Object)authorizationCode2);
    }
}

