/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.ResultKt;
import dev.forkhandles.result4k.Success;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Filter;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.security.ResponseType;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthRequestExtractor;
import org.http4k.security.oauth.server.AuthoriseRequestErrorRender;
import org.http4k.security.oauth.server.AuthoriseRequestValidator;
import org.http4k.security.oauth.server.InvalidAuthorizationRequest;
import org.http4k.security.oauth.server.MustHaveRedirectUri;
import org.http4k.security.oauth.server.OAuthError;
import org.http4k.security.oauth.server.UnsupportedResponseType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJO\u0010\n\u001a!\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bj\u0002`\u00112%\u0010\u0012\u001a!\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bj\u0002`\u0011H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/http4k/security/oauth/server/ClientValidationFilter;", "Lorg/http4k/core/Filter;", "authoriseRequestValidator", "Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;", "errorRenderer", "Lorg/http4k/security/oauth/server/AuthoriseRequestErrorRender;", "extractor", "Lorg/http4k/security/oauth/server/AuthRequestExtractor;", "<init>", "(Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;Lorg/http4k/security/oauth/server/AuthoriseRequestErrorRender;Lorg/http4k/security/oauth/server/AuthRequestExtractor;)V", "invoke", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "next", "Companion", "http4k-security-oauth"})
@SourceDebugExtension(value={"SMAP\nClientValidationFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientValidationFilter.kt\norg/http4k/security/oauth/server/ClientValidationFilter\n+ 2 result.kt\ndev/forkhandles/result4k/ResultKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n37#2,10:38\n52#2:48\n72#2,4:49\n1557#3:53\n1628#3,3:54\n*S KotlinDebug\n*F\n+ 1 ClientValidationFilter.kt\norg/http4k/security/oauth/server/ClientValidationFilter\n*L\n23#1:38,10\n29#1:48\n29#1:49,4\n34#1:53\n34#1:54,3\n*E\n"})
public final class ClientValidationFilter
implements Filter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final AuthoriseRequestValidator authoriseRequestValidator;
    @NotNull
    private final AuthoriseRequestErrorRender errorRenderer;
    @NotNull
    private final AuthRequestExtractor extractor;
    @NotNull
    private static final List<String> validResponseTypes;

    public ClientValidationFilter(@NotNull AuthoriseRequestValidator authoriseRequestValidator, @NotNull AuthoriseRequestErrorRender errorRenderer, @NotNull AuthRequestExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)authoriseRequestValidator, (String)"authoriseRequestValidator");
        Intrinsics.checkNotNullParameter((Object)errorRenderer, (String)"errorRenderer");
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        this.authoriseRequestValidator = authoriseRequestValidator;
        this.errorRenderer = errorRenderer;
        this.extractor = extractor;
    }

    @NotNull
    public Function1<Request, Response> invoke(@NotNull Function1<? super Request, ? extends Response> next) {
        Intrinsics.checkNotNullParameter(next, (String)"next");
        return arg_0 -> ClientValidationFilter.invoke$lambda$2(this, next, arg_0);
    }

    private static final Response invoke$lambda$2(ClientValidationFilter this$0, Function1 $next, Request it) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!CollectionsKt.contains((Iterable)validResponseTypes, (Object)it.query("response_type"))) {
            AuthoriseRequestErrorRender authoriseRequestErrorRender = this$0.errorRenderer;
            String string = it.query("response_type");
            if (string == null) {
                string = "";
            }
            response = authoriseRequestErrorRender.errorFor(it, new UnsupportedResponseType(string));
        } else {
            Result result;
            Result result2;
            Result $this$map$iv = this$0.extractor.extract(it);
            boolean $i$f$map = false;
            Result $this$flatMap$iv$iv = $this$map$iv;
            boolean $i$f$flatMap = false;
            Result result3 = $this$flatMap$iv$iv;
            if (result3 instanceof Success) {
                Response response2;
                Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
                boolean bl = false;
                AuthRequest authorizationRequest = (AuthRequest)value$iv;
                boolean bl2 = false;
                Result<Request, OAuthError> result4 = new MustHaveRedirectUri(this$0.authoriseRequestValidator).validate(it, authorizationRequest);
                if (result4 instanceof Success) {
                    response2 = (Response)$next.invoke(((Success)result4).getValue());
                } else if (result4 instanceof Failure) {
                    response2 = this$0.errorRenderer.errorFor(it, (OAuthError)((Failure)result4).getReason());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Response response3 = response2;
                result2 = (Result)new Success((Object)response3);
            } else if (result3 instanceof Failure) {
                result2 = $this$flatMap$iv$iv;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Result $this$mapFailure$iv = result2;
            boolean $i$f$mapFailure = false;
            Result $this$flatMapFailure$iv$iv = $this$mapFailure$iv;
            boolean $i$f$flatMapFailure = false;
            result3 = $this$flatMapFailure$iv$iv;
            if (result3 instanceof Success) {
                result = $this$flatMapFailure$iv$iv;
            } else if (result3 instanceof Failure) {
                Object reason$iv = ((Failure)$this$flatMapFailure$iv$iv).getReason();
                boolean bl = false;
                InvalidAuthorizationRequest error = (InvalidAuthorizationRequest)reason$iv;
                boolean bl3 = false;
                Response response4 = this$0.errorRenderer.errorFor(it, error);
                result = (Result)new Failure((Object)response4);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            response = (Response)ResultKt.get(result);
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$map$iv = (Iterable)ResponseType.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResponseType responseType2 = (ResponseType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getQueryParameterValue());
        }
        validResponseTypes = (List)var3_3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/http4k/security/oauth/server/ClientValidationFilter$Companion;", "", "<init>", "()V", "validResponseTypes", "", "", "getValidResponseTypes", "()Ljava/util/List;", "http4k-security-oauth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getValidResponseTypes() {
            return validResponseTypes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

