/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server.accesstoken;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.time.Clock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.security.AccessToken;
import org.http4k.security.AccessTokenDetails;
import org.http4k.security.oauth.server.AccessTokenError;
import org.http4k.security.oauth.server.AccessTokens;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.oauth.server.AuthorizationCodeDetails;
import org.http4k.security.oauth.server.AuthorizationCodeExpired;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.ClientIdMismatch;
import org.http4k.security.oauth.server.IdTokens;
import org.http4k.security.oauth.server.MissingAuthorizationCode;
import org.http4k.security.oauth.server.MissingRedirectUri;
import org.http4k.security.oauth.server.RedirectUriMismatch;
import org.http4k.security.oauth.server.TokenRequest;
import org.http4k.security.oauth.server.accesstoken.AccessTokenGenerator;
import org.http4k.security.oauth.server.accesstoken.AuthorizationCodeAccessTokenRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ,\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/http4k/security/oauth/server/accesstoken/AuthorizationCodeAccessTokenGenerator;", "Lorg/http4k/security/oauth/server/accesstoken/AccessTokenGenerator;", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "accessTokens", "Lorg/http4k/security/oauth/server/AccessTokens;", "clock", "Ljava/time/Clock;", "idTokens", "Lorg/http4k/security/oauth/server/IdTokens;", "<init>", "(Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Ljava/time/Clock;Lorg/http4k/security/oauth/server/IdTokens;)V", "generate", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/security/AccessTokenDetails;", "Lorg/http4k/security/oauth/server/AccessTokenError;", "request", "Lorg/http4k/core/Request;", "clientId", "Lorg/http4k/security/oauth/server/ClientId;", "tokenRequest", "Lorg/http4k/security/oauth/server/TokenRequest;", "Lorg/http4k/security/oauth/server/accesstoken/AuthorizationCodeAccessTokenRequest;", "Companion", "http4k-security-oauth"})
@SourceDebugExtension(value={"SMAP\nAuthorizationCodeAccessTokenGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationCodeAccessTokenGenerator.kt\norg/http4k/security/oauth/server/accesstoken/AuthorizationCodeAccessTokenGenerator\n+ 2 result.kt\ndev/forkhandles/result4k/ResultKt\n*L\n1#1,79:1\n43#2,4:80\n37#2,10:84\n*S KotlinDebug\n*F\n+ 1 AuthorizationCodeAccessTokenGenerator.kt\norg/http4k/security/oauth/server/accesstoken/AuthorizationCodeAccessTokenGenerator\n*L\n32#1:80,4\n42#1:84,10\n*E\n"})
public final class AuthorizationCodeAccessTokenGenerator
implements AccessTokenGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthorizationCodes authorizationCodes;
    @NotNull
    private final AccessTokens accessTokens;
    @NotNull
    private final Clock clock;
    @NotNull
    private final IdTokens idTokens;

    public AuthorizationCodeAccessTokenGenerator(@NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull Clock clock, @NotNull IdTokens idTokens) {
        Intrinsics.checkNotNullParameter((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkNotNullParameter((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)idTokens, (String)"idTokens");
        this.authorizationCodes = authorizationCodes;
        this.accessTokens = accessTokens;
        this.clock = clock;
        this.idTokens = idTokens;
    }

    @Override
    @NotNull
    public Result<AccessTokenDetails, AccessTokenError> generate(@NotNull Request request2, @NotNull ClientId clientId, @NotNull TokenRequest tokenRequest) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Result<AuthorizationCodeAccessTokenRequest, AccessTokenError> $this$flatMap$iv = Companion.extract(clientId, tokenRequest);
        boolean $i$f$flatMap = false;
        Result<AuthorizationCodeAccessTokenRequest, AccessTokenError> result = $this$flatMap$iv;
        if (result instanceof Success) {
            AuthorizationCodeAccessTokenRequest it = (AuthorizationCodeAccessTokenRequest)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            object = this.generate(it);
        } else if (result instanceof Failure) {
            object = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final Result<AccessTokenDetails, AccessTokenError> generate(@NotNull AuthorizationCodeAccessTokenRequest request2) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        AuthorizationCodeDetails codeDetails = this.authorizationCodes.detailsFor(request2.getAuthorizationCode());
        if (codeDetails.getExpiresAt().isBefore(this.clock.instant())) {
            result = (Result)new Failure((Object)AuthorizationCodeExpired.INSTANCE);
        } else if (!Intrinsics.areEqual((Object)codeDetails.getClientId(), (Object)request2.getClientId())) {
            result = (Result)new Failure((Object)ClientIdMismatch.INSTANCE);
        } else if (!Intrinsics.areEqual((Object)codeDetails.getRedirectUri(), (Object)request2.getRedirectUri())) {
            result = (Result)new Failure((Object)RedirectUriMismatch.INSTANCE);
        } else {
            Result $this$map$iv = this.accessTokens.create(codeDetails.getClientId(), request2);
            boolean $i$f$map = false;
            Result $this$flatMap$iv$iv = $this$map$iv;
            boolean $i$f$flatMap = false;
            Result result2 = $this$flatMap$iv$iv;
            if (result2 instanceof Success) {
                Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
                boolean bl = false;
                AccessToken token = (AccessToken)value$iv;
                boolean bl2 = false;
                AccessTokenDetails accessTokenDetails = codeDetails.isOIDC() ? new AccessTokenDetails(token, this.idTokens.createForAccessToken(codeDetails, request2.getAuthorizationCode(), token)) : new AccessTokenDetails(token, null, 2, null);
                result = (Result)new Success((Object)accessTokenDetails);
            } else if (result2 instanceof Failure) {
                result = $this$flatMap$iv$iv;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return result;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/http4k/security/oauth/server/accesstoken/AuthorizationCodeAccessTokenGenerator$Companion;", "", "<init>", "()V", "extract", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/security/oauth/server/accesstoken/AuthorizationCodeAccessTokenRequest;", "Lorg/http4k/security/oauth/server/AccessTokenError;", "clientId", "Lorg/http4k/security/oauth/server/ClientId;", "tokenRequest", "Lorg/http4k/security/oauth/server/TokenRequest;", "http4k-security-oauth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Result<AuthorizationCodeAccessTokenRequest, AccessTokenError> extract(@NotNull ClientId clientId, @NotNull TokenRequest tokenRequest) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
            String string = tokenRequest.getClientSecret();
            if (string == null) {
                string = "";
            }
            Uri uri = tokenRequest.getRedirectUri();
            if (uri == null) {
                return (Result)new Failure((Object)MissingRedirectUri.INSTANCE);
            }
            String string2 = tokenRequest.getCode();
            if (string2 == null) {
                return (Result)new Failure((Object)MissingAuthorizationCode.INSTANCE);
            }
            return (Result)new Success((Object)new AuthorizationCodeAccessTokenRequest(clientId, string, uri, tokenRequest.getScopes(), new AuthorizationCode(string2)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

