/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.security.AccessToken;
import org.http4k.security.CrossSiteRequestForgeryToken;
import org.http4k.security.Nonce;
import org.http4k.security.OAuthCallbackError;
import org.http4k.security.PkceChallengeAndVerifier;
import org.http4k.security.openid.IdToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH&J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH&J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tH&J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH&J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH&J,\u0010\u0016\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH&J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000f\u0010\u001f\u001a\u00020 *\u00020\u001e8BX\u0082\u0004\u00a8\u0006!"}, d2={"Lorg/http4k/security/OAuthPersistence;", "", "assignCsrf", "Lorg/http4k/core/Response;", "redirect", "csrf", "Lorg/http4k/security/CrossSiteRequestForgeryToken;", "retrieveCsrf", "request", "Lorg/http4k/core/Request;", "assignNonce", "nonce", "Lorg/http4k/security/Nonce;", "retrieveNonce", "assignOriginalUri", "originalUri", "Lorg/http4k/core/Uri;", "retrieveOriginalUri", "assignPkce", "pkce", "Lorg/http4k/security/PkceChallengeAndVerifier;", "retrievePkce", "assignToken", "accessToken", "Lorg/http4k/security/AccessToken;", "idToken", "Lorg/http4k/security/openid/IdToken;", "retrieveToken", "authFailureResponse", "reason", "Lorg/http4k/security/OAuthCallbackError;", "description", "", "http4k-security-oauth"})
public interface OAuthPersistence {
    @NotNull
    public Response assignCsrf(@NotNull Response var1, @NotNull CrossSiteRequestForgeryToken var2);

    @Nullable
    public CrossSiteRequestForgeryToken retrieveCsrf(@NotNull Request var1);

    @NotNull
    public Response assignNonce(@NotNull Response var1, @NotNull Nonce var2);

    @Nullable
    public Nonce retrieveNonce(@NotNull Request var1);

    @NotNull
    public Response assignOriginalUri(@NotNull Response var1, @NotNull Uri var2);

    @Nullable
    public Uri retrieveOriginalUri(@NotNull Request var1);

    @NotNull
    public Response assignPkce(@NotNull Response var1, @NotNull PkceChallengeAndVerifier var2);

    @Nullable
    public PkceChallengeAndVerifier retrievePkce(@NotNull Request var1);

    @NotNull
    public Response assignToken(@NotNull Request var1, @NotNull Response var2, @NotNull AccessToken var3, @Nullable IdToken var4);

    @Nullable
    public AccessToken retrieveToken(@NotNull Request var1);

    @NotNull
    public Response authFailureResponse(@NotNull OAuthCallbackError var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ Response assignToken$default(OAuthPersistence oAuthPersistence, Request request2, Response response, AccessToken accessToken, IdToken idToken2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assignToken");
            }
            if ((n & 8) != 0) {
                idToken2 = null;
            }
            return oAuthPersistence.assignToken(request2, response, accessToken, idToken2);
        }

        @NotNull
        public static Response authFailureResponse(@NotNull OAuthPersistence $this, @NotNull OAuthCallbackError reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.FORBIDDEN.description(DefaultImpls.getDescription($this, reason)), null, (int)2, null);
        }

        private static String getDescription(OAuthPersistence $this, OAuthCallbackError $receiver) {
            Object object;
            OAuthCallbackError oAuthCallbackError = $receiver;
            if (oAuthCallbackError instanceof OAuthCallbackError.AuthorizationCodeMissing) {
                object = "Authorization code missing";
            } else if (oAuthCallbackError instanceof OAuthCallbackError.CouldNotFetchAccessToken) {
                object = "Failed to fetch access token (status: " + ((OAuthCallbackError.CouldNotFetchAccessToken)$receiver).getStatus() + ")";
            } else if (oAuthCallbackError instanceof OAuthCallbackError.InvalidCsrfToken) {
                object = "Invalid state (expected: " + ((OAuthCallbackError.InvalidCsrfToken)$receiver).getExpected() + ", received: " + ((OAuthCallbackError.InvalidCsrfToken)$receiver).getReceived() + ")";
            } else if (oAuthCallbackError instanceof OAuthCallbackError.InvalidNonce) {
                object = "Invalid nonce (expected: " + ((OAuthCallbackError.InvalidNonce)$receiver).getExpected() + ", received: " + ((OAuthCallbackError.InvalidNonce)$receiver).getReceived() + ")";
            } else if (oAuthCallbackError instanceof OAuthCallbackError.InvalidAccessToken) {
                object = "Invalid access token: " + ((OAuthCallbackError.InvalidAccessToken)$receiver).getReason();
            } else if (oAuthCallbackError instanceof OAuthCallbackError.InvalidIdToken) {
                object = "Invalid id token: " + ((OAuthCallbackError.InvalidIdToken)$receiver).getReason();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return object;
        }
    }
}

